/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.cardboard;

import android.content.Context;
import android.os.RemoteException;
import android.util.Log;
import com.google.vr.cardboard.UsedByNative;
import com.google.vr.ndk.base.Version;
import com.google.vr.vrcore.base.api.VrCoreNotAvailableException;
import com.google.vr.vrcore.base.api.VrCoreUtils;
import com.google.vr.vrcore.library.api.IVrCreator;
import com.google.vr.vrcore.library.api.IVrNativeLibraryLoader;
import com.google.vr.vrcore.library.api.ObjectWrapper;
import com.google.vr.vrcore.library.api.VrCoreLoader;

@UsedByNative
public class VrCoreLibraryLoader {
    private static final String TAG = VrCoreLibraryLoader.class.getSimpleName();

    @UsedByNative
    public static long loadNativeGvrLibrary(Context context, int n, int n2, int n3) {
        try {
            String string2 = VrCoreUtils.getVrCoreSdkLibraryVersion(context);
            Version version = Version.parse(string2);
            if (version == null) {
                Log.i((String)TAG, (String)"VrCore version does not support library loading.");
                return 0L;
            }
            Version version2 = new Version(n, n2, n3);
            if (!version.isAtLeast(version2)) {
                Log.w((String)TAG, (String)String.format("Not loading GVR library from VrCore; VrCore supports %s but target version is %s", string2, version2.toString()));
                return 0L;
            }
            Context context2 = VrCoreLoader.getRemoteContext(context);
            IVrCreator iVrCreator = VrCoreLoader.getRemoteCreator(context);
            IVrNativeLibraryLoader iVrNativeLibraryLoader = iVrCreator.newNativeLibraryLoader(ObjectWrapper.wrap(context2), ObjectWrapper.wrap(context));
            if (iVrNativeLibraryLoader == null) {
                Log.e((String)TAG, (String)"Failed to load native GVR library from VrCore: no library loader available.");
                return 0L;
            }
            return iVrNativeLibraryLoader.loadNativeGvrLibrary(version2.majorVersion, version2.minorVersion, version2.patchVersion);
        }
        catch (RemoteException | VrCoreNotAvailableException | IllegalStateException | SecurityException | UnsatisfiedLinkError throwable) {
            String string3 = String.valueOf(throwable);
            Log.e((String)TAG, (String)new StringBuilder(47 + String.valueOf(string3).length()).append("Failed to load native GVR library from VrCore: ").append(string3).toString());
            return 0L;
        }
    }
}

