/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.cardboard;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.widget.Toast;
import com.google.vr.cardboard.ContextUtils;
import com.google.vr.cardboard.PackageUtils;
import com.google.vr.cardboard.R;
import com.google.vr.cardboard.StoragePermissionUtils;
import com.google.vr.cardboard.VrParamsProviderFactory;
import java.util.ArrayList;
import java.util.List;

public class UiUtils {
    private static final String CARDBOARD_WEBSITE = "https://google.com/cardboard/cfg";
    private static final String CARDBOARD_CONFIGURE_ACTION = "com.google.vrtoolkit.cardboard.CONFIGURE";
    private static final String DAYDREAM_HELP_CENTER_LINK = "https://support.google.com/daydream";
    public static StoragePermissionUtils permissionUtils = new StoragePermissionUtils();
    public static AlertDialog.Builder dialogBuilderForTesting;

    public static void launchOrInstallCardboard(Context context, boolean bl) {
        PackageManager packageManager = context.getPackageManager();
        Intent intent = new Intent();
        intent.setAction(CARDBOARD_CONFIGURE_ACTION);
        List list = packageManager.queryIntentActivities(intent, 0);
        ArrayList<Intent> arrayList = new ArrayList<Intent>();
        Integer n = null;
        Intent intent2 = list.iterator();
        while (intent2.hasNext()) {
            ResolveInfo resolveInfo = (ResolveInfo)intent2.next();
            String string2 = resolveInfo.activityInfo.packageName;
            if (!PackageUtils.isGooglePackage(string2)) continue;
            int n2 = resolveInfo.priority;
            if (PackageUtils.isSystemPackage(context, string2)) {
                ++n2;
            }
            if (n == null) {
                n = n2;
            } else if (n2 > n) {
                n = n2;
                arrayList.clear();
            } else if (n2 < n) continue;
            Intent intent3 = new Intent(intent);
            intent3.setClassName(string2, resolveInfo.activityInfo.name);
            arrayList.add(intent3);
        }
        if (!VrParamsProviderFactory.isContentProviderAvailable(context)) {
            permissionUtils.requestStoragePermission(context);
        }
        if (arrayList.isEmpty()) {
            UiUtils.showInstallDialog(context);
            return;
        }
        Intent intent4 = intent2 = arrayList.size() == 1 ? (Intent)arrayList.get(0) : intent;
        if (bl) {
            UiUtils.showConfigureDialog(context, intent2);
            return;
        }
        context.startActivity(intent2);
    }

    static void launchOrInstallCardboard(Context context) {
        UiUtils.launchOrInstallCardboard(context, true);
    }

    public static AlertDialog showDaydreamHelpCenterDialog(final Context context, int n, int n2, final Runnable runnable) {
        DialogInterface.OnClickListener onClickListener = new DialogInterface.OnClickListener(){

            public final void onClick(DialogInterface dialogInterface, int n) {
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)UiUtils.DAYDREAM_HELP_CENTER_LINK));
                try {
                    context.startActivity(intent);
                    return;
                }
                catch (ActivityNotFoundException activityNotFoundException) {
                    Toast.makeText((Context)context, (int)R.string.no_browser_text, (int)1).show();
                    dialogInterface.cancel();
                    return;
                }
            }
        };
        AlertDialog.Builder builder = UiUtils.createAlertDialogBuilder(context);
        builder.setTitle(n).setMessage(n2).setCancelable(false).setPositiveButton(R.string.dialog_button_open_help_center, onClickListener).setNegativeButton(R.string.dialog_button_got_it, new DialogInterface.OnClickListener(){

            public final void onClick(DialogInterface dialogInterface, int n) {
                dialogInterface.cancel();
            }
        });
        if (runnable != null) {
            builder.setOnCancelListener(new DialogInterface.OnCancelListener(){

                public final void onCancel(DialogInterface dialogInterface) {
                    runnable.run();
                }
            });
        }
        AlertDialog alertDialog = builder.create();
        alertDialog.setCanceledOnTouchOutside(false);
        return UiUtils.showImmersiveDialog(context, alertDialog);
    }

    private static void showInstallDialog(final Context context) {
        DialogInterface.OnClickListener onClickListener = new DialogInterface.OnClickListener(){

            public final void onClick(DialogInterface dialogInterface, int n) {
                try {
                    context.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)UiUtils.CARDBOARD_WEBSITE)));
                    return;
                }
                catch (ActivityNotFoundException activityNotFoundException) {
                    Toast.makeText((Context)context, (int)R.string.no_browser_text, (int)1).show();
                    return;
                }
            }
        };
        AlertDialog.Builder builder = UiUtils.createAlertDialogBuilder(context);
        builder.setTitle(R.string.dialog_title).setMessage(R.string.dialog_message_no_cardboard).setPositiveButton(R.string.go_to_playstore_button, onClickListener).setNegativeButton(R.string.cancel_button, null);
        UiUtils.showImmersiveDialog(context, builder.create());
    }

    private static void showConfigureDialog(final Context context, final Intent intent) {
        DialogInterface.OnClickListener onClickListener = new DialogInterface.OnClickListener(){

            public final void onClick(DialogInterface dialogInterface, int n) {
                try {
                    context.startActivity(intent);
                    return;
                }
                catch (ActivityNotFoundException activityNotFoundException) {
                    UiUtils.showInstallDialog(context);
                    return;
                }
            }
        };
        AlertDialog.Builder builder = UiUtils.createAlertDialogBuilder(context);
        builder.setTitle(R.string.dialog_title).setMessage(R.string.dialog_message_setup).setPositiveButton(R.string.setup_button, onClickListener).setNegativeButton(R.string.cancel_button, null);
        UiUtils.showImmersiveDialog(context, builder.create());
    }

    private static AlertDialog showImmersiveDialog(Context context, AlertDialog alertDialog) {
        alertDialog.getWindow().setFlags(8, 8);
        alertDialog.show();
        Activity activity = ContextUtils.getActivity(context);
        if (activity != null) {
            alertDialog.getWindow().getDecorView().setSystemUiVisibility(activity.getWindow().getDecorView().getSystemUiVisibility());
        }
        alertDialog.getWindow().clearFlags(8);
        return alertDialog;
    }

    private static AlertDialog.Builder createAlertDialogBuilder(Context context) {
        if (dialogBuilderForTesting != null) {
            return dialogBuilderForTesting;
        }
        return new AlertDialog.Builder(context, R.style.GvrDialogTheme);
    }
}

