/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.base;

import android.content.Context;
import android.opengl.EGL14;
import android.opengl.EGLDisplay;
import android.opengl.GLSurfaceView;
import android.os.Trace;
import android.util.Log;
import android.view.Display;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowManager;
import com.google.vr.cardboard.CardboardGLSurfaceView;
import com.google.vr.cardboard.ThreadUtils;
import com.google.vr.cardboard.UsedByNative;
import com.google.vr.ndk.base.BufferSpec;
import com.google.vr.ndk.base.GvrApi;
import com.google.vr.ndk.base.GvrLayout;
import com.google.vr.ndk.base.GvrSurfaceView;
import com.google.vr.ndk.base.GvrUiLayout;
import com.google.vr.sdk.base.CardboardViewApi;
import com.google.vr.sdk.base.Eye;
import com.google.vr.sdk.base.GvrView;
import com.google.vr.sdk.base.GvrViewerParams;
import com.google.vr.sdk.base.HeadMountedDisplay;
import com.google.vr.sdk.base.HeadMountedDisplayManager;
import com.google.vr.sdk.base.HeadTransform;
import com.google.vr.sdk.base.ScreenParams;
import java.lang.reflect.Field;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.opengles.GL10;

@UsedByNative
public class CardboardViewNativeImpl
implements CardboardGLSurfaceView.DetachListener,
CardboardViewApi {
    private static final String TAG = CardboardViewNativeImpl.class.getSimpleName();
    private final RendererHelper rendererHelper;
    private final HeadMountedDisplayManager hmdManager;
    private CountDownLatch shutdownLatch;
    private int cardboardTriggerCount = 0;
    private volatile Runnable cardboardTriggerListener;
    private volatile Runnable cardboardBackListener;
    private Runnable transitionDoneListener;
    private final CardboardGLSurfaceView glSurfaceView;
    private final GvrLayout gvrLayout;
    private final GvrUiLayout uiLayout;
    private final GvrApi gvrApi;
    private final Context context;
    private boolean stereoMode = true;
    private volatile boolean distortionCorrectionEnabled = true;
    private long nativeCardboardView;

    public CardboardViewNativeImpl(Context context) {
        String nativeLibrary;
        this.context = context;
        this.hmdManager = new HeadMountedDisplayManager(context);
        try {
            String proxyClassName = String.valueOf(this.getClass().getPackage().getName()).concat(".NativeProxy");
            Class<?> proxyClass = Class.forName(proxyClassName);
            Field proxyLibField = proxyClass.getDeclaredField("PROXY_LIBRARY");
            nativeLibrary = (String)proxyLibField.get(null);
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"NativeProxy not found");
            nativeLibrary = "gvr";
        }
        String string = String.valueOf(nativeLibrary);
        Log.d((String)TAG, (String)(string.length() != 0 ? "Loading native library ".concat(string) : new String("Loading native library ")));
        System.loadLibrary(nativeLibrary);
        Log.d((String)TAG, (String)"Native library loaded");
        CardboardViewNativeImpl.nativeSetApplicationState(this.getClass().getClassLoader(), context.getApplicationContext());
        this.glSurfaceView = new CardboardGLSurfaceView(context, (CardboardGLSurfaceView.DetachListener)this);
        this.gvrLayout = new GvrLayout(context);
        this.gvrLayout.setPresentationView((View)this.glSurfaceView);
        this.gvrLayout.addPresentationListener((GvrLayout.PresentationListener)new PresentationListener());
        this.rendererHelper = new RendererHelper();
        this.uiLayout = this.gvrLayout.getUiLayout();
        this.gvrApi = this.gvrLayout.getGvrApi();
        this.nativeCardboardView = this.nativeInit(this.gvrApi.getNativeGvrContext());
    }

    protected void finalize() throws Throwable {
        try {
            if (this.nativeCardboardView != 0L) {
                Log.w((String)TAG, (String)"GvrView.shutdown() should be called to ensure resource cleanup");
                this.nativeDestroy(this.nativeCardboardView);
            }
        }
        finally {
            super.finalize();
        }
    }

    public void onSurfaceViewDetachedFromWindow() {
        if (this.shutdownLatch == null) {
            this.shutdownLatch = new CountDownLatch(1);
            this.rendererHelper.shutdown();
            try {
                this.shutdownLatch.await();
            }
            catch (InterruptedException e) {
                String string = String.valueOf(e.toString());
                Log.e((String)TAG, (String)(string.length() != 0 ? "Interrupted during shutdown: ".concat(string) : new String("Interrupted during shutdown: ")));
            }
            this.shutdownLatch = null;
        }
    }

    @Override
    public void setRenderer(GvrView.Renderer renderer) {
        this.rendererHelper.setRenderer(renderer);
        this.glSurfaceView.setRenderer((GLSurfaceView.Renderer)this.rendererHelper);
    }

    @Override
    public void setRenderer(GvrView.StereoRenderer renderer) {
        this.rendererHelper.setRenderer(renderer);
        this.glSurfaceView.setRenderer((GLSurfaceView.Renderer)this.rendererHelper);
    }

    @Override
    public void getCurrentEyeParams(HeadTransform head, Eye leftEye, Eye rightEye, Eye monocular, Eye leftEyeNoDistortionCorrection, Eye rightEyeNoDistortionCorrection) {
        this.rendererHelper.getCurrentEyeParams(head, leftEye, rightEye, monocular, leftEyeNoDistortionCorrection, rightEyeNoDistortionCorrection);
    }

    @Override
    public void setStereoModeEnabled(boolean enabled) {
        this.stereoMode = enabled;
        this.rendererHelper.setStereoModeEnabled(enabled);
    }

    @Override
    public boolean getStereoModeEnabled() {
        return this.stereoMode;
    }

    @Override
    public boolean setAsyncReprojectionEnabled(boolean enable) {
        return this.gvrLayout.setAsyncReprojectionEnabled(enable);
    }

    @Override
    public boolean getAsyncReprojectionEnabled() {
        return this.gvrLayout.getGvrApi().getAsyncReprojectionEnabled();
    }

    @Override
    public void setOnCloseButtonListener(Runnable listener) {
        this.uiLayout.setCloseButtonListener(listener);
    }

    @Override
    public void setTransitionViewEnabled(boolean enabled) {
        this.uiLayout.setTransitionViewEnabled(enabled);
    }

    @Override
    public void setOnTransitionViewDoneListener(Runnable listener) {
        this.uiLayout.setTransitionViewListener(listener);
    }

    @Override
    public HeadMountedDisplay getHeadMountedDisplay() {
        return this.hmdManager.getHeadMountedDisplay();
    }

    @Override
    public void setNeckModelEnabled(boolean enabled) {
        this.nativeSetNeckModelEnabled(this.nativeCardboardView, enabled);
    }

    @Override
    public float getNeckModelFactor() {
        return this.nativeGetNeckModelFactor(this.nativeCardboardView);
    }

    @Override
    public void setNeckModelFactor(float factor) {
        this.nativeSetNeckModelFactor(this.nativeCardboardView, factor);
    }

    @Override
    public void resetHeadTracker() {
        this.gvrApi.resetTracking();
    }

    @Override
    public void recenterHeadTracker() {
        this.gvrApi.recenterTracking();
    }

    @Override
    public void updateGvrViewerParams(GvrViewerParams gvrDeviceParams) {
        if (this.hmdManager.updateGvrViewerParams(gvrDeviceParams)) {
            this.setGvrViewerParams(this.getGvrViewerParams());
        }
    }

    @Override
    public GvrViewerParams getGvrViewerParams() {
        return this.hmdManager.getHeadMountedDisplay().getGvrViewerParams();
    }

    @Override
    public void updateScreenParams(ScreenParams screenParams) {
        if (this.hmdManager.updateScreenParams(screenParams)) {
            this.setScreenParams(this.getScreenParams());
        }
    }

    @Override
    public ScreenParams getScreenParams() {
        return this.hmdManager.getHeadMountedDisplay().getScreenParams();
    }

    @Override
    public float getInterpupillaryDistance() {
        return this.getGvrViewerParams().getInterLensDistance();
    }

    @Override
    public void setDistortionCorrectionEnabled(final boolean enabled) {
        this.checkNativeCardboardView();
        this.distortionCorrectionEnabled = enabled;
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                CardboardViewNativeImpl.this.nativeSetDistortionCorrectionEnabled(CardboardViewNativeImpl.this.nativeCardboardView, enabled);
            }
        });
    }

    @Override
    public boolean getDistortionCorrectionEnabled() {
        return this.distortionCorrectionEnabled;
    }

    @Override
    public void setDistortionCorrectionScale(final float scale) {
        this.checkNativeCardboardView();
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                CardboardViewNativeImpl.this.nativeSetDistortionCorrectionScale(CardboardViewNativeImpl.this.nativeCardboardView, scale);
            }
        });
    }

    @Override
    public void setMultisampling(final int numSamples) {
        this.checkNativeCardboardView();
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                CardboardViewNativeImpl.this.nativeSetMultisampling(CardboardViewNativeImpl.this.nativeCardboardView, numSamples);
            }
        });
    }

    @Override
    public void setDepthStencilFormat(final int format) {
        this.checkNativeCardboardView();
        if (!BufferSpec.isValidDepthStencilFormat((int)format)) {
            throw new IllegalArgumentException("Invalid depth-stencil format.");
        }
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                CardboardViewNativeImpl.this.nativeSetDepthStencilFormat(CardboardViewNativeImpl.this.nativeCardboardView, format);
            }
        });
    }

    @Override
    public void onResume() {
        this.checkNativeCardboardView();
        this.gvrLayout.onResume();
        this.glSurfaceView.onResume();
        this.hmdManager.onResume();
        this.setScreenParams(this.getScreenParams());
        this.setGvrViewerParams(this.getGvrViewerParams());
        this.gvrApi.resumeTracking();
    }

    @Override
    public void onPause() {
        this.checkNativeCardboardView();
        this.gvrApi.pauseTracking();
        this.hmdManager.onPause();
        this.glSurfaceView.onPause();
        this.gvrLayout.onPause();
    }

    @Override
    public void shutdown() {
        if (this.nativeCardboardView != 0L) {
            this.gvrLayout.shutdown();
            this.nativeDestroy(this.nativeCardboardView);
            this.nativeCardboardView = 0L;
        }
    }

    @Override
    public boolean onTouchEvent(MotionEvent e) {
        if (e.getActionMasked() == 0 && this.cardboardTriggerListener != null) {
            this.onCardboardTrigger();
            return true;
        }
        return false;
    }

    @Override
    public void setOnCardboardTriggerListener(Runnable listener) {
        this.cardboardTriggerListener = listener;
    }

    @Override
    public void enableCardboardTriggerEmulation() {
        this.gvrLayout.enableCardboardTriggerEmulation(new Runnable(){

            @Override
            public void run() {
                CardboardViewNativeImpl.this.onCardboardTrigger();
            }
        });
    }

    @Override
    public void setOnCardboardBackListener(Runnable listener) {
        this.cardboardBackListener = listener;
    }

    @Override
    public View getRootView() {
        return this.gvrLayout;
    }

    @Override
    public GvrSurfaceView getGvrSurfaceView() {
        return this.glSurfaceView;
    }

    private void runOnCardboardBackListener() {
        Runnable listener = this.cardboardBackListener;
        if (listener != null) {
            ThreadUtils.runOnUiThread((Runnable)listener);
        }
    }

    @UsedByNative
    private void onCardboardTrigger() {
        Runnable listener = this.cardboardTriggerListener;
        if (listener != null) {
            ThreadUtils.runOnUiThread((Runnable)listener);
        }
    }

    @UsedByNative
    private void onCardboardBack() {
        this.runOnCardboardBackListener();
    }

    private void queueEvent(Runnable r) {
        this.glSurfaceView.queueEvent(r);
    }

    private void setGvrViewerParams(final GvrViewerParams newParams) {
        GvrViewerParams deviceParams = new GvrViewerParams(newParams);
        this.uiLayout.setViewerName(deviceParams.getModel());
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                CardboardViewNativeImpl.this.nativeSetGvrViewerParams(CardboardViewNativeImpl.this.nativeCardboardView, newParams.toByteArray());
            }
        });
    }

    private void setScreenParams(ScreenParams newParams) {
        final ScreenParams screenParams = new ScreenParams(newParams);
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                CardboardViewNativeImpl.this.rendererHelper.setScreenParams(screenParams);
                CardboardViewNativeImpl.this.nativeSetScreenParams(CardboardViewNativeImpl.this.nativeCardboardView, screenParams.getWidth(), screenParams.getHeight(), screenParams.getWidthMeters() / (float)screenParams.getWidth(), screenParams.getHeightMeters() / (float)screenParams.getHeight(), screenParams.getBorderSizeMeters());
            }
        });
    }

    private void reconnectSensors() {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                CardboardViewNativeImpl.this.gvrApi.reconnectSensors();
            }
        });
    }

    private void checkNativeCardboardView() {
        if (this.nativeCardboardView == 0L) {
            throw new IllegalStateException("GvrView has already been shut down.");
        }
    }

    private static Display getDefaultDisplay(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        return windowManager.getDefaultDisplay();
    }

    private static native long nativeSetApplicationState(ClassLoader var0, Context var1);

    private native long nativeInit(long var1);

    private native void nativeDestroy(long var1);

    private native void nativeSetRenderer(long var1, GvrView.Renderer var3);

    private native void nativeSetStereoRenderer(long var1, GvrView.StereoRenderer var3);

    private native void nativeOnSurfaceCreated(long var1);

    private native void nativeOnSurfaceChanged(long var1, int var3, int var4);

    private native void nativeOnDrawFrame(long var1);

    private native void nativeGetCurrentEyeParams(long var1, HeadTransform var3, Eye var4, Eye var5, Eye var6, Eye var7, Eye var8);

    private native void nativeSetNeckModelEnabled(long var1, boolean var3);

    private native float nativeGetNeckModelFactor(long var1);

    private native void nativeSetNeckModelFactor(long var1, float var3);

    private native void nativeSetGvrViewerParams(long var1, byte[] var3);

    private native void nativeSetScreenParams(long var1, int var3, int var4, float var5, float var6, float var7);

    private native void nativeSetStereoModeEnabled(long var1, boolean var3);

    private native void nativeSetDistortionCorrectionEnabled(long var1, boolean var3);

    private native void nativeSetDistortionCorrectionScale(long var1, float var3);

    private native void nativeSetMultisampling(long var1, int var3);

    private native void nativeSetDepthStencilFormat(long var1, int var3);

    private native void nativeUndistortTexture(long var1, int var3);

    private native void nativeLogEvent(long var1, int var3);

    private class RendererHelper
    implements GLSurfaceView.Renderer {
        private GvrView.Renderer renderer;
        private GvrView.StereoRenderer stereoRenderer;
        private ScreenParams screenParams;
        private boolean stereoMode;
        private boolean surfaceCreated;
        private boolean invalidSurfaceSizeWarningShown;
        private EGLDisplay eglDisplay;

        public RendererHelper() {
            this.screenParams = new ScreenParams(CardboardViewNativeImpl.this.getScreenParams());
            this.stereoMode = CardboardViewNativeImpl.this.stereoMode;
        }

        public void setRenderer(GvrView.Renderer renderer) {
            this.renderer = renderer;
            CardboardViewNativeImpl.this.nativeSetRenderer(CardboardViewNativeImpl.this.nativeCardboardView, renderer);
        }

        public void setRenderer(GvrView.StereoRenderer stereoRenderer) {
            this.stereoRenderer = stereoRenderer;
            CardboardViewNativeImpl.this.nativeSetStereoRenderer(CardboardViewNativeImpl.this.nativeCardboardView, stereoRenderer);
        }

        public void setScreenParams(ScreenParams screenParams) {
            this.screenParams = screenParams;
        }

        public void shutdown() {
            CardboardViewNativeImpl.this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    if ((RendererHelper.this.renderer != null || RendererHelper.this.stereoRenderer != null) && RendererHelper.this.surfaceCreated) {
                        RendererHelper.this.surfaceCreated = false;
                        RendererHelper.this.callOnRendererShutdown();
                    }
                    CardboardViewNativeImpl.this.shutdownLatch.countDown();
                }
            });
        }

        public void setStereoModeEnabled(final boolean enabled) {
            CardboardViewNativeImpl.this.checkNativeCardboardView();
            CardboardViewNativeImpl.this.gvrLayout.setStereoModeEnabled(enabled);
            CardboardViewNativeImpl.this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    if (RendererHelper.this.stereoMode == enabled) {
                        return;
                    }
                    RendererHelper.this.stereoMode = enabled;
                    CardboardViewNativeImpl.this.nativeSetStereoModeEnabled(CardboardViewNativeImpl.this.nativeCardboardView, enabled);
                    if (!EGL10.EGL_NO_SURFACE.equals(((EGL10)EGLContext.getEGL()).eglGetCurrentSurface(12377))) {
                        RendererHelper.this.onSurfaceChanged(null, RendererHelper.this.screenParams.getWidth(), RendererHelper.this.screenParams.getHeight());
                    }
                }
            });
        }

        public void getCurrentEyeParams(final HeadTransform head, final Eye leftEye, final Eye rightEye, final Eye monocular, final Eye leftEyeNoDistortionCorrection, final Eye rightEyeNoDistortionCorrection) {
            CardboardViewNativeImpl.this.checkNativeCardboardView();
            final CountDownLatch finished = new CountDownLatch(1);
            CardboardViewNativeImpl.this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    CardboardViewNativeImpl.this.nativeGetCurrentEyeParams(CardboardViewNativeImpl.this.nativeCardboardView, head, leftEye, rightEye, monocular, leftEyeNoDistortionCorrection, rightEyeNoDistortionCorrection);
                    finished.countDown();
                }
            });
            try {
                finished.await();
            }
            catch (InterruptedException e) {
                String string = String.valueOf(e.toString());
                Log.e((String)TAG, (String)(string.length() != 0 ? "Interrupted while reading frame params: ".concat(string) : new String("Interrupted while reading frame params: ")));
            }
        }

        public void onDrawFrame(GL10 gl) {
            if (this.renderer == null && this.stereoRenderer == null || !this.surfaceCreated) {
                return;
            }
            Trace.beginSection((String)"Render");
            CardboardViewNativeImpl.this.nativeOnDrawFrame(CardboardViewNativeImpl.this.nativeCardboardView);
            Trace.endSection();
            EGL14.eglSwapInterval((EGLDisplay)this.eglDisplay, (int)1);
        }

        public void onSurfaceChanged(GL10 gl, int width, int height) {
            if (this.renderer == null && this.stereoRenderer == null || !this.surfaceCreated) {
                return;
            }
            if (this.stereoMode && (width != this.screenParams.getWidth() || height != this.screenParams.getHeight())) {
                if (!this.invalidSurfaceSizeWarningShown) {
                    int n = this.screenParams.getWidth();
                    int n2 = this.screenParams.getHeight();
                    Log.e((String)TAG, (String)new StringBuilder(134).append("Surface size ").append(width).append("x").append(height).append(" does not match the expected screen size ").append(n).append("x").append(n2).append(". Stereo rendering might feel off.").toString());
                }
                this.invalidSurfaceSizeWarningShown = true;
            } else {
                this.invalidSurfaceSizeWarningShown = false;
            }
            CardboardViewNativeImpl.this.nativeOnSurfaceChanged(CardboardViewNativeImpl.this.nativeCardboardView, width, height);
            this.callOnSurfaceChanged(width, height);
        }

        private void callOnSurfaceCreated(EGLConfig config) {
            CardboardViewNativeImpl.this.nativeOnSurfaceCreated(CardboardViewNativeImpl.this.nativeCardboardView);
            if (this.renderer != null) {
                this.renderer.onSurfaceCreated(config);
            } else if (this.stereoRenderer != null) {
                this.stereoRenderer.onSurfaceCreated(config);
            }
        }

        public void onSurfaceCreated(GL10 gl, EGLConfig config) {
            if (this.renderer == null && this.stereoRenderer == null) {
                return;
            }
            this.surfaceCreated = true;
            this.eglDisplay = EGL14.eglGetCurrentDisplay();
            this.callOnSurfaceCreated(config);
        }

        private void callOnSurfaceChanged(int width, int height) {
            if (this.renderer != null) {
                this.renderer.onSurfaceChanged(width, height);
            } else if (this.stereoRenderer != null) {
                if (this.stereoMode) {
                    this.stereoRenderer.onSurfaceChanged(width / 2, height);
                } else {
                    this.stereoRenderer.onSurfaceChanged(width, height);
                }
            }
        }

        private void callOnRendererShutdown() {
            if (this.renderer != null) {
                this.renderer.onRendererShutdown();
            } else if (this.stereoRenderer != null) {
                this.stereoRenderer.onRendererShutdown();
            }
        }
    }

    private class PresentationListener
    implements GvrLayout.PresentationListener {
        ScreenParams originalParams;

        private PresentationListener() {
        }

        public void onPresentationStarted(Display display) {
            this.originalParams = CardboardViewNativeImpl.this.getScreenParams();
            ScreenParams newParams = new ScreenParams(display);
            CardboardViewNativeImpl.this.updateScreenParams(newParams);
            CardboardViewNativeImpl.this.reconnectSensors();
        }

        public void onPresentationStopped() {
            if (this.originalParams != null) {
                CardboardViewNativeImpl.this.updateScreenParams(this.originalParams);
            }
        }
    }
}

