/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.vrcore.library.api;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.IBinder;
import com.google.vr.vrcore.base.api.VrCoreNotAvailableException;
import com.google.vr.vrcore.base.api.VrCoreUtils;
import com.google.vr.vrcore.library.api.IVrCreator;

public class VrCoreLoader {
    private static Context sRemoteContext;
    private static int sRemoteContextApiVersion;
    private static IVrCreator sCreator;

    public static IVrCreator getRemoteCreator(Context context) throws VrCoreNotAvailableException {
        if (sCreator == null) {
            ClassLoader classLoader = VrCoreLoader.getRemoteContext(context).getClassLoader();
            IBinder iBinder = VrCoreLoader.newBinderInstance(classLoader, "com.google.vr.vrcore.library.VrCreator");
            sCreator = IVrCreator.Stub.asInterface(iBinder);
        }
        return sCreator;
    }

    public static Context getRemoteContext(Context context) throws VrCoreNotAvailableException {
        if (sRemoteContext == null) {
            int n2 = VrCoreUtils.getVrCoreClientApiVersion(context);
            if (n2 < 9) {
                throw new VrCoreNotAvailableException(4);
            }
            try {
                sRemoteContext = context.createPackageContext("com.google.vr.vrcore", 3);
                sRemoteContextApiVersion = n2;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                throw new VrCoreNotAvailableException(1);
            }
        }
        return sRemoteContext;
    }

    public static int getRemoteContextClientApiVersion(Context context) throws VrCoreNotAvailableException {
        VrCoreLoader.getRemoteContext(context);
        return sRemoteContextApiVersion;
    }

    private static IBinder newBinderInstance(ClassLoader classLoader, String string2) {
        try {
            Class<?> clazz = classLoader.loadClass(string2);
            return (IBinder)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string3 = String.valueOf(string2);
            throw new IllegalStateException(string3.length() != 0 ? "Unable to find dynamic class ".concat(string3) : new String("Unable to find dynamic class "));
        }
        catch (InstantiationException instantiationException) {
            String string4 = String.valueOf(string2);
            throw new IllegalStateException(string4.length() != 0 ? "Unable to instantiate the remote class ".concat(string4) : new String("Unable to instantiate the remote class "));
        }
        catch (IllegalAccessException illegalAccessException) {
            String string5 = String.valueOf(string2);
            throw new IllegalStateException(string5.length() != 0 ? "Unable to call the default constructor of ".concat(string5) : new String("Unable to call the default constructor of "));
        }
    }
}

