/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.vrcore.base.api;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageInstaller;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Log;
import com.google.vr.cardboard.annotations.UsedByNative;
import com.google.vr.vrcore.base.api.BuildUtils;
import com.google.vr.vrcore.base.api.SignatureUtils;
import com.google.vr.vrcore.base.api.VrCoreNotAvailableException;

@UsedByNative
public final class VrCoreUtils {
    public VrCoreUtils() {
    }

    public static int checkVrCoreAvailability(Context context) {
        int n2 = VrCoreUtils.checkVrCoreAvailabilityImpl(context);
        return n2;
    }

    @UsedByNative
    public static int getVrCoreClientApiVersion(Context context) throws VrCoreNotAvailableException {
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo("com.google.vr.vrcore", 128);
            if (applicationInfo.enabled) {
                if (applicationInfo.metaData != null) {
                    return applicationInfo.metaData.getInt("com.google.vr.vrcore.ClientApiVersion", 0);
                }
                return 0;
            }
            throw new VrCoreNotAvailableException(2);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new VrCoreNotAvailableException(VrCoreUtils.checkVrCoreAvailability(context));
        }
    }

    public static String getVrCoreSdkLibraryVersion(Context context) throws VrCoreNotAvailableException {
        ApplicationInfo applicationInfo;
        try {
            applicationInfo = context.getPackageManager().getApplicationInfo("com.google.vr.vrcore", 128);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new VrCoreNotAvailableException(VrCoreUtils.checkVrCoreAvailability(context));
        }
        if (applicationInfo == null) {
            throw new VrCoreNotAvailableException(8);
        }
        if (!applicationInfo.enabled) {
            throw new VrCoreNotAvailableException(2);
        }
        if (applicationInfo.metaData == null) {
            throw new VrCoreNotAvailableException(4);
        }
        String string2 = applicationInfo.metaData.getString("com.google.vr.vrcore.SdkLibraryVersion", "");
        if (string2.isEmpty()) {
            throw new VrCoreNotAvailableException(4);
        }
        return string2.substring(1);
    }

    public static String getConnectionResultString(int n2) {
        switch (n2) {
            case 0: {
                return "VR Service present";
            }
            case 1: {
                return "VR Service missing";
            }
            case 2: {
                return "VR Service disabled";
            }
            case 3: {
                return "VR Service updating";
            }
            case 4: {
                return "VR Service obsolete";
            }
            case 5: {
                return "VR Service not connected";
            }
            case 6: {
                return "No permission to do operation";
            }
            case 7: {
                return "This operation is not supported on this device";
            }
            case 8: {
                return "An unknown failure occurred";
            }
        }
        return new StringBuilder(38).append("Invalid connection result: ").append(n2).toString();
    }

    public static boolean isVrCorePackage(String string2) {
        return "com.google.vr.vrcore".equalsIgnoreCase(string2);
    }

    private static int checkVrCoreAvailabilityImpl(Context context) {
        if ("com.google.vr.vrcore".equals(context.getPackageName())) {
            return 0;
        }
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo("com.google.vr.vrcore", 0);
            if (!applicationInfo.enabled) {
                return 2;
            }
            if (!VrCoreUtils.verifyRemotePackageSignature(context)) {
                return 9;
            }
            return 0;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Object object;
            Object object2;
            if (Build.VERSION.SDK_INT >= 21) {
                String string2;
                object2 = null;
                try {
                    object2 = context.getPackageManager().getPackageInstaller().getAllSessions();
                }
                catch (RuntimeException runtimeException) {
                    string2 = String.valueOf(runtimeException);
                    Log.w((String)"VrCoreUtils", (String)new StringBuilder(45 + String.valueOf(string2).length()).append("Failure querying package installer sessions: ").append(string2).toString());
                }
                if (object2 != null) {
                    object = object2.iterator();
                    while (object.hasNext()) {
                        string2 = (PackageInstaller.SessionInfo)object.next();
                        if (!"com.google.vr.vrcore".equals(string2.getAppPackageName())) continue;
                        return 3;
                    }
                }
            }
            object2 = context.getPackageManager();
            try {
                object = object2.getApplicationInfo("com.google.vr.vrcore", 8192);
                if (((ApplicationInfo)object).enabled) {
                    return 3;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException2) {}
            return 1;
        }
    }

    private static boolean verifyRemotePackageSignature(Context context) throws PackageManager.NameNotFoundException {
        PackageInfo packageInfo = context.getPackageManager().getPackageInfo("com.google.vr.vrcore", 64);
        if (SignatureUtils.verifySignature(packageInfo, SignatureUtils.VRCORE_RELEASE_SIGNATURE)) {
            return true;
        }
        if (BuildUtils.isDebugBuild(context)) {
            return SignatureUtils.verifySignature(packageInfo, SignatureUtils.VRCORE_DEBUG_SIGNATURE);
        }
        return false;
    }
}

