/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.proto.nano;

import com.google.vr.sdk.deps.dp;
import com.google.vr.sdk.deps.hl;
import com.google.vr.sdk.deps.hm;
import com.google.vr.sdk.deps.ho;
import com.google.vr.sdk.deps.hw;
import com.google.vr.sdk.proto.Preferences;
import java.io.IOException;

public class Preferences {

    public static final class TrackingConfigurationParams
    extends ho<TrackingConfigurationParams>
    implements Cloneable {
        private int bitField0_;
        private Integer controllerConfigType_;

        public TrackingConfigurationParams() {
            this.clear();
        }

        public final TrackingConfigurationParams clear() {
            this.bitField0_ = 0;
            this.controllerConfigType_ = Preferences.ControllerConfigurationType.GVR_CONTROLLER_CONFIGURATION_UNKNOWN == null ? null : Integer.valueOf(Preferences.ControllerConfigurationType.GVR_CONTROLLER_CONFIGURATION_UNKNOWN.getNumber());
            this.unknownFieldData = null;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public final TrackingConfigurationParams clone() {
            TrackingConfigurationParams trackingConfigurationParams;
            try {
                trackingConfigurationParams = (TrackingConfigurationParams)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError((Object)cloneNotSupportedException);
            }
            return trackingConfigurationParams;
        }

        @Override
        public final void writeTo(hm hm2) throws IOException {
            if ((this.bitField0_ & 1) != 0 && this.controllerConfigType_ != null) {
                hm2.a(1, this.controllerConfigType_);
            }
            super.writeTo(hm2);
        }

        @Override
        protected final int computeSerializedSize() {
            int n2 = super.computeSerializedSize();
            if ((this.bitField0_ & 1) != 0 && this.controllerConfigType_ != null) {
                n2 += hm.b(1, this.controllerConfigType_);
            }
            return n2;
        }

        @Override
        public final TrackingConfigurationParams mergeFrom(hl hl2) throws IOException {
            block7: while (true) {
                int n2 = hl2.a();
                switch (n2) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (super.storeUnknownField(hl2, n2)) continue block7;
                        return this;
                    }
                    case 8: 
                }
                this.bitField0_ |= 1;
                int n3 = hl2.i();
                int n4 = hl2.b();
                switch (n4) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        this.controllerConfigType_ = n4;
                        this.bitField0_ |= 1;
                        continue block7;
                    }
                }
                hl2.e(n3);
                this.storeUnknownField(hl2, n2);
            }
        }
    }

    public static final class SafetyCylinderParams
    extends ho<SafetyCylinderParams>
    implements Cloneable {
        private int bitField0_;
        private float collisionSphereRadius_;
        private float innerRadius_;
        private float outerRadius_;
        public float[] innerFogColor;
        public float[] outerFogColor;
        private float enterEventRadius_;
        private float exitEventRadius_;
        private float anchorWarningDistance_;
        private boolean graphicsEnabled_;

        public SafetyCylinderParams() {
            this.clear();
        }

        public final SafetyCylinderParams clear() {
            this.bitField0_ = 0;
            this.collisionSphereRadius_ = 0.0f;
            this.innerRadius_ = 0.0f;
            this.outerRadius_ = 0.0f;
            this.innerFogColor = hw.b;
            this.outerFogColor = hw.b;
            this.enterEventRadius_ = 0.0f;
            this.exitEventRadius_ = 0.0f;
            this.anchorWarningDistance_ = 0.0f;
            this.graphicsEnabled_ = true;
            this.unknownFieldData = null;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public final SafetyCylinderParams clone() {
            SafetyCylinderParams safetyCylinderParams;
            try {
                safetyCylinderParams = (SafetyCylinderParams)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError((Object)cloneNotSupportedException);
            }
            if (this.innerFogColor != null && this.innerFogColor.length > 0) {
                safetyCylinderParams.innerFogColor = (float[])this.innerFogColor.clone();
            }
            if (this.outerFogColor != null && this.outerFogColor.length > 0) {
                safetyCylinderParams.outerFogColor = (float[])this.outerFogColor.clone();
            }
            return safetyCylinderParams;
        }

        @Override
        public final void writeTo(hm hm2) throws IOException {
            int n2;
            if ((this.bitField0_ & 1) != 0) {
                hm2.a(1, this.collisionSphereRadius_);
            }
            if ((this.bitField0_ & 2) != 0) {
                hm2.a(2, this.innerRadius_);
            }
            if ((this.bitField0_ & 4) != 0) {
                hm2.a(3, this.outerRadius_);
            }
            if (this.innerFogColor != null && this.innerFogColor.length > 0) {
                for (n2 = 0; n2 < this.innerFogColor.length; ++n2) {
                    hm2.a(4, this.innerFogColor[n2]);
                }
            }
            if (this.outerFogColor != null && this.outerFogColor.length > 0) {
                for (n2 = 0; n2 < this.outerFogColor.length; ++n2) {
                    hm2.a(5, this.outerFogColor[n2]);
                }
            }
            if ((this.bitField0_ & 8) != 0) {
                hm2.a(6, this.enterEventRadius_);
            }
            if ((this.bitField0_ & 0x10) != 0) {
                hm2.a(7, this.exitEventRadius_);
            }
            if ((this.bitField0_ & 0x20) != 0) {
                hm2.a(8, this.anchorWarningDistance_);
            }
            if ((this.bitField0_ & 0x40) != 0) {
                hm2.a(9, this.graphicsEnabled_);
            }
            super.writeTo(hm2);
        }

        @Override
        protected final int computeSerializedSize() {
            int n2;
            int n3;
            float f2;
            int n4 = super.computeSerializedSize();
            if ((this.bitField0_ & 1) != 0) {
                f2 = this.collisionSphereRadius_;
                n3 = 1;
                n4 += hm.b(1) + 4;
            }
            if ((this.bitField0_ & 2) != 0) {
                f2 = this.innerRadius_;
                n3 = 2;
                n4 += hm.b(2) + 4;
            }
            if ((this.bitField0_ & 4) != 0) {
                f2 = this.outerRadius_;
                n3 = 3;
                n4 += hm.b(3) + 4;
            }
            if (this.innerFogColor != null && this.innerFogColor.length > 0) {
                n2 = 4 * this.innerFogColor.length;
                n4 += n2;
                n4 += 1 * this.innerFogColor.length;
            }
            if (this.outerFogColor != null && this.outerFogColor.length > 0) {
                n2 = 4 * this.outerFogColor.length;
                n4 += n2;
                n4 += 1 * this.outerFogColor.length;
            }
            if ((this.bitField0_ & 8) != 0) {
                f2 = this.enterEventRadius_;
                n3 = 6;
                n4 += hm.b(6) + 4;
            }
            if ((this.bitField0_ & 0x10) != 0) {
                f2 = this.exitEventRadius_;
                n3 = 7;
                n4 += hm.b(7) + 4;
            }
            if ((this.bitField0_ & 0x20) != 0) {
                f2 = this.anchorWarningDistance_;
                n3 = 8;
                n4 += hm.b(8) + 4;
            }
            if ((this.bitField0_ & 0x40) != 0) {
                boolean bl2 = this.graphicsEnabled_;
                n3 = 9;
                n4 += hm.b(9) + 1;
            }
            return n4;
        }

        @Override
        public final SafetyCylinderParams mergeFrom(hl hl2) throws IOException {
            block14: while (true) {
                int n2 = hl2.a();
                switch (n2) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (super.storeUnknownField(hl2, n2)) continue block14;
                        return this;
                    }
                    case 13: {
                        hl hl3 = hl2;
                        this.collisionSphereRadius_ = Float.intBitsToFloat(hl3.g());
                        this.bitField0_ |= 1;
                        continue block14;
                    }
                    case 21: {
                        hl hl3 = hl2;
                        this.innerRadius_ = Float.intBitsToFloat(hl3.g());
                        this.bitField0_ |= 2;
                        continue block14;
                    }
                    case 29: {
                        hl hl3 = hl2;
                        this.outerRadius_ = Float.intBitsToFloat(hl3.g());
                        this.bitField0_ |= 4;
                        continue block14;
                    }
                    case 37: {
                        hl hl3;
                        int n3 = hw.a(hl2, 37);
                        int n4 = this.innerFogColor == null ? 0 : this.innerFogColor.length;
                        float[] fArray = new float[n4 + n3];
                        if (n4 != 0) {
                            System.arraycopy(this.innerFogColor, 0, fArray, 0, n4);
                        }
                        while (n4 < fArray.length - 1) {
                            hl3 = hl2;
                            fArray[n4] = Float.intBitsToFloat(hl3.g());
                            hl2.a();
                            ++n4;
                        }
                        hl3 = hl2;
                        fArray[n4] = Float.intBitsToFloat(hl3.g());
                        this.innerFogColor = fArray;
                        continue block14;
                    }
                    case 34: {
                        hl hl3;
                        int n3 = hl2.e();
                        int n4 = hl2.c(n3);
                        int n5 = n3 / 4;
                        int n6 = this.innerFogColor == null ? 0 : this.innerFogColor.length;
                        float[] fArray = new float[n6 + n5];
                        if (n6 != 0) {
                            System.arraycopy(this.innerFogColor, 0, fArray, 0, n6);
                        }
                        while (n6 < fArray.length) {
                            hl3 = hl2;
                            fArray[n6] = Float.intBitsToFloat(hl3.g());
                            ++n6;
                        }
                        this.innerFogColor = fArray;
                        hl2.d(n4);
                        continue block14;
                    }
                    case 45: {
                        hl hl3;
                        int n3 = hw.a(hl2, 45);
                        int n4 = this.outerFogColor == null ? 0 : this.outerFogColor.length;
                        float[] fArray = new float[n4 + n3];
                        if (n4 != 0) {
                            System.arraycopy(this.outerFogColor, 0, fArray, 0, n4);
                        }
                        while (n4 < fArray.length - 1) {
                            hl3 = hl2;
                            fArray[n4] = Float.intBitsToFloat(hl3.g());
                            hl2.a();
                            ++n4;
                        }
                        hl3 = hl2;
                        fArray[n4] = Float.intBitsToFloat(hl3.g());
                        this.outerFogColor = fArray;
                        continue block14;
                    }
                    case 42: {
                        hl hl3;
                        int n3 = hl2.e();
                        int n4 = hl2.c(n3);
                        int n7 = n3 / 4;
                        int n6 = this.outerFogColor == null ? 0 : this.outerFogColor.length;
                        float[] fArray = new float[n6 + n7];
                        if (n6 != 0) {
                            System.arraycopy(this.outerFogColor, 0, fArray, 0, n6);
                        }
                        while (n6 < fArray.length) {
                            hl3 = hl2;
                            fArray[n6] = Float.intBitsToFloat(hl3.g());
                            ++n6;
                        }
                        this.outerFogColor = fArray;
                        hl2.d(n4);
                        continue block14;
                    }
                    case 53: {
                        hl hl3 = hl2;
                        this.enterEventRadius_ = Float.intBitsToFloat(hl3.g());
                        this.bitField0_ |= 8;
                        continue block14;
                    }
                    case 61: {
                        hl hl3 = hl2;
                        this.exitEventRadius_ = Float.intBitsToFloat(hl3.g());
                        this.bitField0_ |= 0x10;
                        continue block14;
                    }
                    case 69: {
                        hl hl3 = hl2;
                        this.anchorWarningDistance_ = Float.intBitsToFloat(hl3.g());
                        this.bitField0_ |= 0x20;
                        continue block14;
                    }
                    case 72: 
                }
                this.graphicsEnabled_ = hl2.c();
                this.bitField0_ |= 0x40;
            }
        }
    }

    public static final class DeveloperPrefs
    extends ho<DeveloperPrefs>
    implements Cloneable {
        private int bitField0_;
        private boolean performanceMonitoringEnabled_;
        private boolean sensorLoggingEnabled_;
        private boolean dEPRECATEDMotophoPatchEnabled_;
        private boolean developerLoggingEnabled_;
        private boolean forceUndistortedRendering_;
        private boolean performanceHudEnabled_;
        private boolean dEPRECATEDGvrPlatformLibraryEnabled_;
        private boolean dEPRECATEDHeadTrackingServiceEnabled_;
        private boolean captureEnabled_;
        public SafetyCylinderParams safetyCylinderParams;
        private boolean frameTrackerEnabled_;
        private Integer motophoPatchMode_;
        private boolean performanceLoggingActivated_;
        private boolean openglKhrDebugEnabled_;
        public TrackingConfigurationParams trackingConfigurationParams;
        public Preferences.PlayAreaSettings playAreaSettings;

        public final boolean getOpenglKhrDebugEnabled() {
            return this.openglKhrDebugEnabled_;
        }

        public DeveloperPrefs() {
            this.clear();
        }

        public final DeveloperPrefs clear() {
            this.bitField0_ = 0;
            this.performanceMonitoringEnabled_ = false;
            this.sensorLoggingEnabled_ = false;
            this.dEPRECATEDMotophoPatchEnabled_ = false;
            this.developerLoggingEnabled_ = false;
            this.forceUndistortedRendering_ = false;
            this.performanceHudEnabled_ = false;
            this.dEPRECATEDGvrPlatformLibraryEnabled_ = false;
            this.dEPRECATEDHeadTrackingServiceEnabled_ = false;
            this.captureEnabled_ = false;
            this.safetyCylinderParams = null;
            this.frameTrackerEnabled_ = false;
            this.motophoPatchMode_ = Preferences.DeveloperPrefs.MotophoPatchMode.NONE == null ? null : Integer.valueOf(Preferences.DeveloperPrefs.MotophoPatchMode.NONE.getNumber());
            this.performanceLoggingActivated_ = false;
            this.openglKhrDebugEnabled_ = false;
            this.trackingConfigurationParams = null;
            this.playAreaSettings = null;
            this.unknownFieldData = null;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public final DeveloperPrefs clone() {
            DeveloperPrefs developerPrefs;
            try {
                developerPrefs = (DeveloperPrefs)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError((Object)cloneNotSupportedException);
            }
            if (this.safetyCylinderParams != null) {
                developerPrefs.safetyCylinderParams = this.safetyCylinderParams.clone();
            }
            if (this.trackingConfigurationParams != null) {
                developerPrefs.trackingConfigurationParams = this.trackingConfigurationParams.clone();
            }
            if (this.playAreaSettings != null) {
                developerPrefs.playAreaSettings = this.playAreaSettings;
            }
            return developerPrefs;
        }

        @Override
        public final void writeTo(hm hm2) throws IOException {
            if ((this.bitField0_ & 1) != 0) {
                hm2.a(1, this.performanceMonitoringEnabled_);
            }
            if ((this.bitField0_ & 2) != 0) {
                hm2.a(2, this.sensorLoggingEnabled_);
            }
            if ((this.bitField0_ & 4) != 0) {
                hm2.a(3, this.dEPRECATEDMotophoPatchEnabled_);
            }
            if ((this.bitField0_ & 8) != 0) {
                hm2.a(4, this.developerLoggingEnabled_);
            }
            if ((this.bitField0_ & 0x10) != 0) {
                hm2.a(5, this.forceUndistortedRendering_);
            }
            if ((this.bitField0_ & 0x20) != 0) {
                hm2.a(6, this.performanceHudEnabled_);
            }
            if ((this.bitField0_ & 0x40) != 0) {
                hm2.a(7, this.dEPRECATEDGvrPlatformLibraryEnabled_);
            }
            if ((this.bitField0_ & 0x80) != 0) {
                hm2.a(8, this.dEPRECATEDHeadTrackingServiceEnabled_);
            }
            if ((this.bitField0_ & 0x100) != 0) {
                hm2.a(9, this.captureEnabled_);
            }
            if (this.safetyCylinderParams != null) {
                hm2.a(10, this.safetyCylinderParams);
            }
            if ((this.bitField0_ & 0x200) != 0) {
                hm2.a(11, this.frameTrackerEnabled_);
            }
            if ((this.bitField0_ & 0x400) != 0 && this.motophoPatchMode_ != null) {
                hm2.a(12, this.motophoPatchMode_);
            }
            if ((this.bitField0_ & 0x800) != 0) {
                hm2.a(13, this.performanceLoggingActivated_);
            }
            if ((this.bitField0_ & 0x1000) != 0) {
                hm2.a(14, this.openglKhrDebugEnabled_);
            }
            if (this.trackingConfigurationParams != null) {
                hm2.a(15, this.trackingConfigurationParams);
            }
            if (this.playAreaSettings != null) {
                hm2.a(16, this.playAreaSettings);
            }
            super.writeTo(hm2);
        }

        @Override
        protected final int computeSerializedSize() {
            int n2;
            boolean bl2;
            int n3 = super.computeSerializedSize();
            if ((this.bitField0_ & 1) != 0) {
                bl2 = this.performanceMonitoringEnabled_;
                n2 = 1;
                n3 += hm.b(1) + 1;
            }
            if ((this.bitField0_ & 2) != 0) {
                bl2 = this.sensorLoggingEnabled_;
                n2 = 2;
                n3 += hm.b(2) + 1;
            }
            if ((this.bitField0_ & 4) != 0) {
                bl2 = this.dEPRECATEDMotophoPatchEnabled_;
                n2 = 3;
                n3 += hm.b(3) + 1;
            }
            if ((this.bitField0_ & 8) != 0) {
                bl2 = this.developerLoggingEnabled_;
                n2 = 4;
                n3 += hm.b(4) + 1;
            }
            if ((this.bitField0_ & 0x10) != 0) {
                bl2 = this.forceUndistortedRendering_;
                n2 = 5;
                n3 += hm.b(5) + 1;
            }
            if ((this.bitField0_ & 0x20) != 0) {
                bl2 = this.performanceHudEnabled_;
                n2 = 6;
                n3 += hm.b(6) + 1;
            }
            if ((this.bitField0_ & 0x40) != 0) {
                bl2 = this.dEPRECATEDGvrPlatformLibraryEnabled_;
                n2 = 7;
                n3 += hm.b(7) + 1;
            }
            if ((this.bitField0_ & 0x80) != 0) {
                bl2 = this.dEPRECATEDHeadTrackingServiceEnabled_;
                n2 = 8;
                n3 += hm.b(8) + 1;
            }
            if ((this.bitField0_ & 0x100) != 0) {
                bl2 = this.captureEnabled_;
                n2 = 9;
                n3 += hm.b(9) + 1;
            }
            if (this.safetyCylinderParams != null) {
                n3 += hm.b(10, this.safetyCylinderParams);
            }
            if ((this.bitField0_ & 0x200) != 0) {
                bl2 = this.frameTrackerEnabled_;
                n2 = 11;
                n3 += hm.b(11) + 1;
            }
            if ((this.bitField0_ & 0x400) != 0 && this.motophoPatchMode_ != null) {
                n3 += hm.b(12, this.motophoPatchMode_);
            }
            if ((this.bitField0_ & 0x800) != 0) {
                bl2 = this.performanceLoggingActivated_;
                n2 = 13;
                n3 += hm.b(13) + 1;
            }
            if ((this.bitField0_ & 0x1000) != 0) {
                bl2 = this.openglKhrDebugEnabled_;
                n2 = 14;
                n3 += hm.b(14) + 1;
            }
            if (this.trackingConfigurationParams != null) {
                n3 += hm.b(15, this.trackingConfigurationParams);
            }
            if (this.playAreaSettings != null) {
                n3 += dp.c(16, this.playAreaSettings);
            }
            return n3;
        }

        @Override
        public final DeveloperPrefs mergeFrom(hl hl2) throws IOException {
            block22: while (true) {
                int n2 = hl2.a();
                switch (n2) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (super.storeUnknownField(hl2, n2)) continue block22;
                        return this;
                    }
                    case 8: {
                        this.performanceMonitoringEnabled_ = hl2.c();
                        this.bitField0_ |= 1;
                        continue block22;
                    }
                    case 16: {
                        this.sensorLoggingEnabled_ = hl2.c();
                        this.bitField0_ |= 2;
                        continue block22;
                    }
                    case 24: {
                        this.dEPRECATEDMotophoPatchEnabled_ = hl2.c();
                        this.bitField0_ |= 4;
                        continue block22;
                    }
                    case 32: {
                        this.developerLoggingEnabled_ = hl2.c();
                        this.bitField0_ |= 8;
                        continue block22;
                    }
                    case 40: {
                        this.forceUndistortedRendering_ = hl2.c();
                        this.bitField0_ |= 0x10;
                        continue block22;
                    }
                    case 48: {
                        this.performanceHudEnabled_ = hl2.c();
                        this.bitField0_ |= 0x20;
                        continue block22;
                    }
                    case 56: {
                        this.dEPRECATEDGvrPlatformLibraryEnabled_ = hl2.c();
                        this.bitField0_ |= 0x40;
                        continue block22;
                    }
                    case 64: {
                        this.dEPRECATEDHeadTrackingServiceEnabled_ = hl2.c();
                        this.bitField0_ |= 0x80;
                        continue block22;
                    }
                    case 72: {
                        this.captureEnabled_ = hl2.c();
                        this.bitField0_ |= 0x100;
                        continue block22;
                    }
                    case 82: {
                        if (this.safetyCylinderParams == null) {
                            this.safetyCylinderParams = new SafetyCylinderParams();
                        }
                        hl2.a(this.safetyCylinderParams);
                        continue block22;
                    }
                    case 88: {
                        this.frameTrackerEnabled_ = hl2.c();
                        this.bitField0_ |= 0x200;
                        continue block22;
                    }
                    case 96: {
                        this.bitField0_ |= 0x400;
                        int n3 = hl2.i();
                        int n4 = hl2.b();
                        switch (n4) {
                            case 0: 
                            case 1: 
                            case 2: {
                                this.motophoPatchMode_ = n4;
                                this.bitField0_ |= 0x400;
                                continue block22;
                            }
                        }
                        hl2.e(n3);
                        this.storeUnknownField(hl2, n2);
                        continue block22;
                    }
                    case 104: {
                        this.performanceLoggingActivated_ = hl2.c();
                        this.bitField0_ |= 0x800;
                        continue block22;
                    }
                    case 112: {
                        this.openglKhrDebugEnabled_ = hl2.c();
                        this.bitField0_ |= 0x1000;
                        continue block22;
                    }
                    case 122: {
                        if (this.trackingConfigurationParams == null) {
                            this.trackingConfigurationParams = new TrackingConfigurationParams();
                        }
                        hl2.a(this.trackingConfigurationParams);
                        continue block22;
                    }
                    case 130: 
                }
                Preferences.PlayAreaSettings playAreaSettings = hl2.a(Preferences.PlayAreaSettings.parser());
                this.playAreaSettings = this.playAreaSettings == null ? playAreaSettings : (Preferences.PlayAreaSettings)((Preferences.PlayAreaSettings.Builder)((Preferences.PlayAreaSettings.Builder)this.playAreaSettings.toBuilder()).mergeFrom(playAreaSettings)).build();
            }
        }
    }

    public static final class UserPrefs
    extends ho<UserPrefs>
    implements Cloneable {
        private int bitField0_;
        private int controllerHandedness_;
        public DeveloperPrefs developerPrefs;

        public static int checkHandednessOrThrow(int n2) {
            if (n2 >= 0 && n2 <= 1) {
                return n2;
            }
            throw new IllegalArgumentException(new StringBuilder(42).append(n2).append(" is not a valid enum Handedness").toString());
        }

        public final int getControllerHandedness() {
            return this.controllerHandedness_;
        }

        public final UserPrefs setControllerHandedness(int n2) {
            this.controllerHandedness_ = n2;
            this.bitField0_ |= 1;
            return this;
        }

        public UserPrefs() {
            this.clear();
        }

        public final UserPrefs clear() {
            this.bitField0_ = 0;
            this.controllerHandedness_ = 0;
            this.developerPrefs = null;
            this.unknownFieldData = null;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public final UserPrefs clone() {
            UserPrefs userPrefs;
            try {
                userPrefs = (UserPrefs)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError((Object)cloneNotSupportedException);
            }
            if (this.developerPrefs != null) {
                userPrefs.developerPrefs = this.developerPrefs.clone();
            }
            return userPrefs;
        }

        @Override
        public final void writeTo(hm hm2) throws IOException {
            if ((this.bitField0_ & 1) != 0) {
                hm2.a(1, this.controllerHandedness_);
            }
            if (this.developerPrefs != null) {
                hm2.a(2, this.developerPrefs);
            }
            super.writeTo(hm2);
        }

        @Override
        protected final int computeSerializedSize() {
            int n2 = super.computeSerializedSize();
            if ((this.bitField0_ & 1) != 0) {
                n2 += hm.b(1, this.controllerHandedness_);
            }
            if (this.developerPrefs != null) {
                n2 += hm.b(2, this.developerPrefs);
            }
            return n2;
        }

        @Override
        public final UserPrefs mergeFrom(hl hl2) throws IOException {
            block7: while (true) {
                int n2 = hl2.a();
                switch (n2) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (super.storeUnknownField(hl2, n2)) continue block7;
                        return this;
                    }
                    case 8: {
                        this.bitField0_ |= 1;
                        int n3 = hl2.i();
                        try {
                            this.controllerHandedness_ = UserPrefs.checkHandednessOrThrow(hl2.b());
                            this.bitField0_ |= 1;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            hl2.e(n3);
                            this.storeUnknownField(hl2, n2);
                        }
                        continue block7;
                    }
                    case 18: 
                }
                if (this.developerPrefs == null) {
                    this.developerPrefs = new DeveloperPrefs();
                }
                hl2.a(this.developerPrefs);
            }
        }
    }
}

