/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.controller;

import java.util.Locale;

public class Orientation {
    public float x;
    public float y;
    public float z;
    public float w;

    public Orientation() {
        this.set(0.0f, 0.0f, 0.0f, 1.0f);
    }

    public Orientation(float f2, float f3, float f4, float f5) {
        this.set(f2, f3, f4, f5);
    }

    public static Orientation fromAxisAngleDegrees(float f2, float f3, float f4, float f5) {
        return new Orientation((float)Math.sin((double)f2 * Math.toRadians(f5 / 2.0f)), (float)Math.sin((double)f3 * Math.toRadians(f5 / 2.0f)), (float)Math.sin((double)f4 * Math.toRadians(f5 / 2.0f)), (float)Math.cos(Math.toRadians(f5 / 2.0f)));
    }

    public void set(float f2, float f3, float f4, float f5) {
        this.x = f2;
        this.y = f3;
        this.z = f4;
        this.w = f5;
    }

    public void set(float[] fArray) {
        this.set(fArray[0], fArray[1], fArray[2], fArray[3]);
    }

    void set(Orientation orientation) {
        this.set(orientation.x, orientation.y, orientation.z, orientation.w);
    }

    public String toString() {
        return String.format(Locale.US, "%5.2fi %5.2fj %5.2fk %5.2f", Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z), Float.valueOf(this.w));
    }

    float[] toAxisAngle(float[] fArray) {
        float f2;
        float f3 = (float)Math.sqrt(1.0f - this.w * this.w);
        if (f2 > 0.0f) {
            fArray[0] = this.x / f3;
            fArray[1] = this.y / f3;
            fArray[2] = this.z / f3;
            fArray[3] = (float)Math.toDegrees(2.0 * Math.acos(this.w));
        } else {
            fArray[0] = 1.0f;
            fArray[1] = 0.0f;
            fArray[2] = 0.0f;
            fArray[3] = 0.0f;
        }
        return fArray;
    }

    public String toAxisAngleString() {
        float[] fArray = this.toAxisAngle(new float[4]);
        return String.format(Locale.US, "(%5.2f, %5.2f, %5.2f), %3.0f\u00b0", Float.valueOf(fArray[0]), Float.valueOf(fArray[1]), Float.valueOf(fArray[2]), Float.valueOf(fArray[3]));
    }

    void multiply(Orientation orientation) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        float f5 = this.w;
        this.x = orientation.w * f2 + orientation.x * f5 + orientation.z * f3 - orientation.y * f4;
        this.y = orientation.w * f3 + orientation.y * f5 + orientation.x * f4 - orientation.z * f2;
        this.z = orientation.w * f4 + orientation.z * f5 + orientation.y * f2 - orientation.x * f3;
        this.w = orientation.w * f5 - orientation.x * f2 - orientation.y * f3 - orientation.z * f4;
    }

    public float[] toYawPitchRollRadians(float[] fArray) {
        if (fArray == null) {
            fArray = new float[3];
        }
        this.toForwardVector(fArray);
        float f2 = fArray[0];
        float f3 = fArray[1];
        float f4 = fArray[2];
        if (Math.abs(f3) < 0.9999f) {
            fArray[0] = (float)Math.atan2(-f2, -f4);
            fArray[1] = (float)Math.asin(f3);
            fArray[2] = (float)Math.atan2(2.0f * this.w * this.z + 2.0f * this.x * this.y, 1.0f - 2.0f * this.x * this.x - 2.0f * this.z * this.z);
        } else {
            fArray[0] = (float)((double)Math.copySign(2.0f, f3) * Math.atan2(this.z, this.w));
            fArray[1] = (float)Math.copySign(1.5707963267948966, (double)f3);
            fArray[2] = 0.0f;
        }
        return fArray;
    }

    public float[] toForwardVector(float[] fArray) {
        fArray[0] = -2.0f * (this.x * this.z + this.w * this.y);
        fArray[1] = 2.0f * (this.w * this.x - this.y * this.z);
        fArray[2] = -this.w * this.w + this.x * this.x + this.y * this.y - this.z * this.z;
        return fArray;
    }

    public float[] toYawPitchRollDegrees(float[] fArray) {
        float[] fArray2 = this.toYawPitchRollRadians(fArray);
        for (int i2 = 0; i2 < 3; ++i2) {
            fArray2[i2] = (float)Math.toDegrees(fArray2[i2]);
        }
        return fArray2;
    }

    public float[] toRotationMatrix(float[] fArray) {
        fArray[0] = 1.0f - 2.0f * this.y * this.y - 2.0f * this.z * this.z;
        fArray[1] = 2.0f * this.x * this.y + 2.0f * this.z * this.w;
        fArray[2] = 2.0f * this.x * this.z - 2.0f * this.y * this.w;
        fArray[3] = 0.0f;
        fArray[4] = 2.0f * this.x * this.y - 2.0f * this.z * this.w;
        fArray[5] = 1.0f - 2.0f * this.x * this.x - 2.0f * this.z * this.z;
        fArray[6] = 2.0f * this.y * this.z + 2.0f * this.x * this.w;
        fArray[7] = 0.0f;
        fArray[8] = 2.0f * this.x * this.z + 2.0f * this.y * this.w;
        fArray[9] = 2.0f * this.y * this.z - 2.0f * this.x * this.w;
        fArray[10] = 1.0f - 2.0f * this.x * this.x - 2.0f * this.y * this.y;
        fArray[11] = 0.0f;
        fArray[12] = 0.0f;
        fArray[13] = 0.0f;
        fArray[14] = 0.0f;
        fArray[15] = 1.0f;
        return fArray;
    }
}

