/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.base.sensors.internal;

import com.google.vr.sdk.base.sensors.internal.Vector3d;

public class Matrix3x3d {
    public double[] m = new double[9];

    public Matrix3x3d() {
    }

    public Matrix3x3d(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        this.m[0] = d2;
        this.m[1] = d3;
        this.m[2] = d4;
        this.m[3] = d5;
        this.m[4] = d6;
        this.m[5] = d7;
        this.m[6] = d8;
        this.m[7] = d9;
        this.m[8] = d10;
    }

    public Matrix3x3d(Matrix3x3d matrix3x3d) {
        this.m[0] = matrix3x3d.m[0];
        this.m[1] = matrix3x3d.m[1];
        this.m[2] = matrix3x3d.m[2];
        this.m[3] = matrix3x3d.m[3];
        this.m[4] = matrix3x3d.m[4];
        this.m[5] = matrix3x3d.m[5];
        this.m[6] = matrix3x3d.m[6];
        this.m[7] = matrix3x3d.m[7];
        this.m[8] = matrix3x3d.m[8];
    }

    public void set(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        this.m[0] = d2;
        this.m[1] = d3;
        this.m[2] = d4;
        this.m[3] = d5;
        this.m[4] = d6;
        this.m[5] = d7;
        this.m[6] = d8;
        this.m[7] = d9;
        this.m[8] = d10;
    }

    public void set(Matrix3x3d matrix3x3d) {
        this.m[0] = matrix3x3d.m[0];
        this.m[1] = matrix3x3d.m[1];
        this.m[2] = matrix3x3d.m[2];
        this.m[3] = matrix3x3d.m[3];
        this.m[4] = matrix3x3d.m[4];
        this.m[5] = matrix3x3d.m[5];
        this.m[6] = matrix3x3d.m[6];
        this.m[7] = matrix3x3d.m[7];
        this.m[8] = matrix3x3d.m[8];
    }

    public void setZero() {
        this.m[8] = 0.0;
        this.m[7] = 0.0;
        this.m[6] = 0.0;
        this.m[5] = 0.0;
        this.m[4] = 0.0;
        this.m[3] = 0.0;
        this.m[2] = 0.0;
        this.m[1] = 0.0;
        this.m[0] = 0.0;
    }

    public void setIdentity() {
        this.m[7] = 0.0;
        this.m[6] = 0.0;
        this.m[5] = 0.0;
        this.m[3] = 0.0;
        this.m[2] = 0.0;
        this.m[1] = 0.0;
        this.m[8] = 1.0;
        this.m[4] = 1.0;
        this.m[0] = 1.0;
    }

    public void setSameDiagonal(double d2) {
        this.m[4] = this.m[8] = d2;
        this.m[0] = this.m[8];
    }

    public double get(int n2, int n3) {
        return this.m[3 * n2 + n3];
    }

    public void set(int n2, int n3, double d2) {
        this.m[3 * n2 + n3] = d2;
    }

    public void getColumn(int n2, Vector3d vector3d) {
        vector3d.x = this.m[n2];
        vector3d.y = this.m[n2 + 3];
        vector3d.z = this.m[n2 + 6];
    }

    public void setColumn(int n2, Vector3d vector3d) {
        this.m[n2] = vector3d.x;
        this.m[n2 + 3] = vector3d.y;
        this.m[n2 + 6] = vector3d.z;
    }

    public void scale(double d2) {
        this.m[0] = this.m[0] * d2;
        this.m[1] = this.m[1] * d2;
        this.m[2] = this.m[2] * d2;
        this.m[3] = this.m[3] * d2;
        this.m[4] = this.m[4] * d2;
        this.m[5] = this.m[5] * d2;
        this.m[6] = this.m[6] * d2;
        this.m[7] = this.m[7] * d2;
        this.m[8] = this.m[8] * d2;
    }

    public void plusEquals(Matrix3x3d matrix3x3d) {
        this.m[0] = this.m[0] + matrix3x3d.m[0];
        this.m[1] = this.m[1] + matrix3x3d.m[1];
        this.m[2] = this.m[2] + matrix3x3d.m[2];
        this.m[3] = this.m[3] + matrix3x3d.m[3];
        this.m[4] = this.m[4] + matrix3x3d.m[4];
        this.m[5] = this.m[5] + matrix3x3d.m[5];
        this.m[6] = this.m[6] + matrix3x3d.m[6];
        this.m[7] = this.m[7] + matrix3x3d.m[7];
        this.m[8] = this.m[8] + matrix3x3d.m[8];
    }

    public void minusEquals(Matrix3x3d matrix3x3d) {
        this.m[0] = this.m[0] - matrix3x3d.m[0];
        this.m[1] = this.m[1] - matrix3x3d.m[1];
        this.m[2] = this.m[2] - matrix3x3d.m[2];
        this.m[3] = this.m[3] - matrix3x3d.m[3];
        this.m[4] = this.m[4] - matrix3x3d.m[4];
        this.m[5] = this.m[5] - matrix3x3d.m[5];
        this.m[6] = this.m[6] - matrix3x3d.m[6];
        this.m[7] = this.m[7] - matrix3x3d.m[7];
        this.m[8] = this.m[8] - matrix3x3d.m[8];
    }

    public void transpose() {
        double d2 = this.m[1];
        this.m[1] = this.m[3];
        this.m[3] = d2;
        d2 = this.m[2];
        this.m[2] = this.m[6];
        this.m[6] = d2;
        d2 = this.m[5];
        this.m[5] = this.m[7];
        this.m[7] = d2;
    }

    public void transpose(Matrix3x3d matrix3x3d) {
        double d2 = this.m[1];
        double d3 = this.m[2];
        double d4 = this.m[5];
        matrix3x3d.m[0] = this.m[0];
        matrix3x3d.m[1] = this.m[3];
        matrix3x3d.m[2] = this.m[6];
        matrix3x3d.m[3] = d2;
        matrix3x3d.m[4] = this.m[4];
        matrix3x3d.m[5] = this.m[7];
        matrix3x3d.m[6] = d3;
        matrix3x3d.m[7] = d4;
        matrix3x3d.m[8] = this.m[8];
    }

    public static void add(Matrix3x3d matrix3x3d, Matrix3x3d matrix3x3d2, Matrix3x3d matrix3x3d3) {
        matrix3x3d3.m[0] = matrix3x3d.m[0] + matrix3x3d2.m[0];
        matrix3x3d3.m[1] = matrix3x3d.m[1] + matrix3x3d2.m[1];
        matrix3x3d3.m[2] = matrix3x3d.m[2] + matrix3x3d2.m[2];
        matrix3x3d3.m[3] = matrix3x3d.m[3] + matrix3x3d2.m[3];
        matrix3x3d3.m[4] = matrix3x3d.m[4] + matrix3x3d2.m[4];
        matrix3x3d3.m[5] = matrix3x3d.m[5] + matrix3x3d2.m[5];
        matrix3x3d3.m[6] = matrix3x3d.m[6] + matrix3x3d2.m[6];
        matrix3x3d3.m[7] = matrix3x3d.m[7] + matrix3x3d2.m[7];
        matrix3x3d3.m[8] = matrix3x3d.m[8] + matrix3x3d2.m[8];
    }

    public static void mult(Matrix3x3d matrix3x3d, Matrix3x3d matrix3x3d2, Matrix3x3d matrix3x3d3) {
        matrix3x3d3.set(matrix3x3d.m[0] * matrix3x3d2.m[0] + matrix3x3d.m[1] * matrix3x3d2.m[3] + matrix3x3d.m[2] * matrix3x3d2.m[6], matrix3x3d.m[0] * matrix3x3d2.m[1] + matrix3x3d.m[1] * matrix3x3d2.m[4] + matrix3x3d.m[2] * matrix3x3d2.m[7], matrix3x3d.m[0] * matrix3x3d2.m[2] + matrix3x3d.m[1] * matrix3x3d2.m[5] + matrix3x3d.m[2] * matrix3x3d2.m[8], matrix3x3d.m[3] * matrix3x3d2.m[0] + matrix3x3d.m[4] * matrix3x3d2.m[3] + matrix3x3d.m[5] * matrix3x3d2.m[6], matrix3x3d.m[3] * matrix3x3d2.m[1] + matrix3x3d.m[4] * matrix3x3d2.m[4] + matrix3x3d.m[5] * matrix3x3d2.m[7], matrix3x3d.m[3] * matrix3x3d2.m[2] + matrix3x3d.m[4] * matrix3x3d2.m[5] + matrix3x3d.m[5] * matrix3x3d2.m[8], matrix3x3d.m[6] * matrix3x3d2.m[0] + matrix3x3d.m[7] * matrix3x3d2.m[3] + matrix3x3d.m[8] * matrix3x3d2.m[6], matrix3x3d.m[6] * matrix3x3d2.m[1] + matrix3x3d.m[7] * matrix3x3d2.m[4] + matrix3x3d.m[8] * matrix3x3d2.m[7], matrix3x3d.m[6] * matrix3x3d2.m[2] + matrix3x3d.m[7] * matrix3x3d2.m[5] + matrix3x3d.m[8] * matrix3x3d2.m[8]);
    }

    public static void mult(Matrix3x3d matrix3x3d, Vector3d vector3d, Vector3d vector3d2) {
        double d2 = matrix3x3d.m[0] * vector3d.x + matrix3x3d.m[1] * vector3d.y + matrix3x3d.m[2] * vector3d.z;
        double d3 = matrix3x3d.m[3] * vector3d.x + matrix3x3d.m[4] * vector3d.y + matrix3x3d.m[5] * vector3d.z;
        double d4 = matrix3x3d.m[6] * vector3d.x + matrix3x3d.m[7] * vector3d.y + matrix3x3d.m[8] * vector3d.z;
        vector3d2.x = d2;
        vector3d2.y = d3;
        vector3d2.z = d4;
    }

    public double determinant() {
        return this.get(0, 0) * (this.get(1, 1) * this.get(2, 2) - this.get(2, 1) * this.get(1, 2)) - this.get(0, 1) * (this.get(1, 0) * this.get(2, 2) - this.get(1, 2) * this.get(2, 0)) + this.get(0, 2) * (this.get(1, 0) * this.get(2, 1) - this.get(1, 1) * this.get(2, 0));
    }

    public boolean invert(Matrix3x3d matrix3x3d) {
        double d2 = this.determinant();
        if (d2 == 0.0) {
            return false;
        }
        double d3 = 1.0 / d2;
        matrix3x3d.set((this.m[4] * this.m[8] - this.m[7] * this.m[5]) * d3, -(this.m[1] * this.m[8] - this.m[2] * this.m[7]) * d3, (this.m[1] * this.m[5] - this.m[2] * this.m[4]) * d3, -(this.m[3] * this.m[8] - this.m[5] * this.m[6]) * d3, (this.m[0] * this.m[8] - this.m[2] * this.m[6]) * d3, -(this.m[0] * this.m[5] - this.m[3] * this.m[2]) * d3, (this.m[3] * this.m[7] - this.m[6] * this.m[4]) * d3, -(this.m[0] * this.m[7] - this.m[6] * this.m[1]) * d3, (this.m[0] * this.m[4] - this.m[3] * this.m[1]) * d3);
        return true;
    }

    public double maxNorm() {
        double d2 = Math.abs(this.m[0]);
        for (int i2 = 1; i2 < this.m.length; ++i2) {
            d2 = Math.max(d2, Math.abs(this.m[i2]));
        }
        return d2;
    }
}

