/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.base.sensors.internal;

import com.google.vr.sdk.base.sensors.internal.Vector3d;
import java.util.concurrent.TimeUnit;

public class LowPassFilter {
    private static final double NANOS_TO_SECONDS = 1.0 / (double)TimeUnit.NANOSECONDS.convert(1L, TimeUnit.SECONDS);
    private final double timeConstantSecs;
    private final Vector3d filteredData = new Vector3d();
    private long lastTimestampNs;
    private int numSamples;
    private final Vector3d temp = new Vector3d();

    public LowPassFilter(double d2) {
        this.timeConstantSecs = 1.0 / (d2 * (Math.PI * 2));
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public void addSample(Vector3d vector3d, long l2) {
        this.addWeightedSample(vector3d, l2, 1.0);
    }

    public void addWeightedSample(Vector3d vector3d, long l2, double d2) {
        ++this.numSamples;
        if (this.numSamples == 1) {
            this.filteredData.set(vector3d);
            this.lastTimestampNs = l2;
            return;
        }
        double d3 = d2 * (double)(l2 - this.lastTimestampNs) * NANOS_TO_SECONDS;
        double d4 = d3 / (this.timeConstantSecs + d3);
        this.filteredData.scale(1.0 - d4);
        this.temp.set(vector3d);
        this.temp.scale(d4);
        Vector3d.add(this.temp, this.filteredData, this.filteredData);
        this.lastTimestampNs = l2;
    }

    public Vector3d getFilteredData() {
        return this.filteredData;
    }
}

