/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.base;

import android.annotation.TargetApi;
import android.content.Context;
import com.google.vr.cardboard.VrParamsProvider;
import com.google.vr.cardboard.VrParamsProviderFactory;
import com.google.vr.ndk.base.DaydreamApi;
import com.google.vr.ndk.base.DaydreamUtils;
import com.google.vr.sdk.base.GvrViewerParams;
import com.google.vr.sdk.proto.nano.CardboardDevice;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=24)
public class HeadsetSelector {
    private static final String TAG = "HeadsetSelector";
    private static final HeadsetInfo DEFAULT_HEADSET_INFO = new HeadsetInfo(GvrViewerParams.cardboardV2ViewerParams().toProtobuf());

    public HeadsetSelector() {
    }

    public static List<HeadsetInfo> getRecentHeadsetInfos(Context context) {
        ArrayList<HeadsetInfo> arrayList = new ArrayList<HeadsetInfo>();
        CardboardDevice.DeviceParamsList deviceParamsList = DaydreamApi.getRecentHeadsets(context);
        if (deviceParamsList != null && deviceParamsList.params.length > 0) {
            CardboardDevice.DeviceParams[] deviceParamsArray = deviceParamsList.params;
            int n2 = deviceParamsList.params.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                CardboardDevice.DeviceParams deviceParams = deviceParamsArray[i2];
                arrayList.add(new HeadsetInfo(deviceParams));
            }
        }
        if (arrayList.isEmpty() || arrayList.size() == 1 && !((HeadsetInfo)arrayList.get(0)).isCardboardViewer()) {
            arrayList.add(DEFAULT_HEADSET_INFO);
        }
        return arrayList;
    }

    public static HeadsetInfo getCurrentHeadsetInfo(Context context) {
        HeadsetInfo headsetInfo = DEFAULT_HEADSET_INFO;
        try (VrParamsProvider vrParamsProvider = VrParamsProviderFactory.create(context);){
            CardboardDevice.DeviceParams deviceParams = vrParamsProvider.readDeviceParams();
            if (deviceParams != null) {
                headsetInfo = new HeadsetInfo(deviceParams);
            }
        }
        return headsetInfo;
    }

    public static boolean selectHeadset(Context context, HeadsetInfo headsetInfo) {
        if (headsetInfo == null) {
            return false;
        }
        try (VrParamsProvider vrParamsProvider = VrParamsProviderFactory.create(context);){
            CardboardDevice.DeviceParamsList deviceParamsList = vrParamsProvider.readRecentHeadsets();
            if (deviceParamsList != null && deviceParamsList.params.length > 0) {
                CardboardDevice.DeviceParams[] deviceParamsArray = deviceParamsList.params;
                int n2 = deviceParamsList.params.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    CardboardDevice.DeviceParams deviceParams = deviceParamsArray[i2];
                    if (!headsetInfo.equalsDeviceParam(deviceParams)) continue;
                    boolean bl2 = vrParamsProvider.writeDeviceParams(deviceParams);
                    return bl2;
                }
            }
            boolean bl3 = headsetInfo.equals(DEFAULT_HEADSET_INFO) && vrParamsProvider.writeDeviceParams(DEFAULT_HEADSET_INFO.deviceParam);
            return bl3;
        }
    }

    private static String getHeadsetParamsKey(CardboardDevice.DeviceParams deviceParams) {
        String string2 = deviceParams.getVendor();
        String string3 = deviceParams.getModel();
        return new StringBuilder(1 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append("_").append(string3).toString();
    }

    public static final class HeadsetInfo {
        private final CardboardDevice.DeviceParams deviceParam;
        private final String uniqueKey;
        private final String displayName;
        private final boolean cardboardViewer;

        private HeadsetInfo(CardboardDevice.DeviceParams deviceParams) {
            this(deviceParams, DaydreamUtils.getDeviceParamsDisplayedName(deviceParams), !DaydreamUtils.isDaydreamViewer(deviceParams));
        }

        private HeadsetInfo(CardboardDevice.DeviceParams deviceParams, String string2, boolean bl2) {
            this.deviceParam = deviceParams;
            this.uniqueKey = HeadsetSelector.getHeadsetParamsKey(deviceParams);
            this.displayName = string2;
            this.cardboardViewer = bl2;
        }

        public static HeadsetInfo newInstance(String string2, String string3, String string4, boolean bl2) {
            CardboardDevice.DeviceParams deviceParams = new CardboardDevice.DeviceParams();
            deviceParams.setVendor(string2);
            deviceParams.setModel(string3);
            return new HeadsetInfo(deviceParams, string4, bl2);
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final boolean isCardboardViewer() {
            return this.cardboardViewer;
        }

        private final boolean equalsDeviceParam(CardboardDevice.DeviceParams deviceParams) {
            return this.uniqueKey.equalsIgnoreCase(HeadsetSelector.getHeadsetParamsKey(deviceParams));
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof HeadsetInfo)) {
                return false;
            }
            HeadsetInfo headsetInfo = (HeadsetInfo)object;
            return this.uniqueKey.equalsIgnoreCase(headsetInfo.uniqueKey);
        }

        public final int hashCode() {
            return this.uniqueKey.hashCode();
        }
    }
}

