/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.base;

import android.content.Context;
import android.opengl.GLSurfaceView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.FrameLayout;
import com.google.vr.cardboard.ContextUtils;
import com.google.vr.cardboard.UsedByNative;
import com.google.vr.ndk.base.GvrApi;
import com.google.vr.ndk.base.GvrSurfaceView;
import com.google.vr.sdk.base.CardboardViewApi;
import com.google.vr.sdk.base.Eye;
import com.google.vr.sdk.base.GvrViewerParams;
import com.google.vr.sdk.base.HeadMountedDisplay;
import com.google.vr.sdk.base.HeadTransform;
import com.google.vr.sdk.base.ImplementationSelector;
import com.google.vr.sdk.base.ScreenParams;
import com.google.vr.sdk.base.Viewport;
import javax.microedition.khronos.egl.EGLConfig;

public class GvrView
extends FrameLayout {
    private CardboardViewApi cardboardViewApi;

    public GvrView(Context context) {
        super(context);
        this.init(context);
    }

    public GvrView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context);
    }

    public void setRenderer(Renderer renderer) {
        if (renderer == null) {
            throw new IllegalArgumentException("Renderer must not be null");
        }
        this.cardboardViewApi.setRenderer(renderer);
    }

    public void setRenderer(StereoRenderer stereoRenderer) {
        if (stereoRenderer == null) {
            throw new IllegalArgumentException("StereoRenderer must not be null");
        }
        this.cardboardViewApi.setRenderer(stereoRenderer);
    }

    public void getCurrentEyeParams(HeadTransform headTransform, Eye eye, Eye eye2, Eye eye3, Eye eye4, Eye eye5) {
        this.cardboardViewApi.getCurrentEyeParams(headTransform, eye, eye2, eye3, eye4, eye5);
    }

    public void setStereoModeEnabled(boolean bl2) {
        this.cardboardViewApi.setStereoModeEnabled(bl2);
    }

    public boolean getStereoModeEnabled() {
        return this.cardboardViewApi.getStereoModeEnabled();
    }

    public boolean setAsyncReprojectionEnabled(boolean bl2) {
        return this.cardboardViewApi.setAsyncReprojectionEnabled(bl2);
    }

    public boolean getAsyncReprojectionEnabled() {
        return this.cardboardViewApi.getAsyncReprojectionEnabled();
    }

    public void setOnCloseButtonListener(Runnable runnable) {
        this.cardboardViewApi.setOnCloseButtonListener(runnable);
    }

    public void onBackPressed() {
        this.cardboardViewApi.onBackPressed();
    }

    public void setTransitionViewEnabled(boolean bl2) {
        this.cardboardViewApi.setTransitionViewEnabled(bl2);
    }

    public void setOnTransitionViewDoneListener(Runnable runnable) {
        this.cardboardViewApi.setOnTransitionViewDoneListener(runnable);
    }

    public HeadMountedDisplay getHeadMountedDisplay() {
        return this.cardboardViewApi.getHeadMountedDisplay();
    }

    public void setNeckModelEnabled(boolean bl2) {
        this.cardboardViewApi.setNeckModelEnabled(bl2);
    }

    public float getNeckModelFactor() {
        return this.cardboardViewApi.getNeckModelFactor();
    }

    public void setNeckModelFactor(float f2) {
        this.cardboardViewApi.setNeckModelFactor(f2);
    }

    @Deprecated
    public void resetHeadTracker() {
        this.cardboardViewApi.resetHeadTracker();
    }

    public void recenterHeadTracker() {
        this.cardboardViewApi.recenterHeadTracker();
    }

    public void updateGvrViewerParams(GvrViewerParams gvrViewerParams) {
        this.cardboardViewApi.updateGvrViewerParams(gvrViewerParams);
    }

    public GvrViewerParams getGvrViewerParams() {
        return this.cardboardViewApi.getGvrViewerParams();
    }

    public void updateScreenParams(ScreenParams screenParams) {
        this.cardboardViewApi.updateScreenParams(screenParams);
    }

    public ScreenParams getScreenParams() {
        return this.cardboardViewApi.getScreenParams();
    }

    public float getInterpupillaryDistance() {
        return this.cardboardViewApi.getInterpupillaryDistance();
    }

    public void setDistortionCorrectionEnabled(boolean bl2) {
        this.cardboardViewApi.setDistortionCorrectionEnabled(bl2);
    }

    public boolean getDistortionCorrectionEnabled() {
        return this.cardboardViewApi.getDistortionCorrectionEnabled();
    }

    public void setRenderTargetScale(float f2) {
        this.cardboardViewApi.setDistortionCorrectionScale(f2);
    }

    public void setMultisampling(int n2) {
        this.cardboardViewApi.setMultisampling(n2);
    }

    public void setDepthStencilFormat(int n2) {
        this.cardboardViewApi.setDepthStencilFormat(n2);
    }

    public void onResume() {
        this.cardboardViewApi.onResume();
    }

    public void onPause() {
        this.cardboardViewApi.onPause();
    }

    public void shutdown() {
        this.cardboardViewApi.shutdown();
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.cardboardViewApi.onTouchEvent(motionEvent)) {
            return true;
        }
        return super.onTouchEvent(motionEvent);
    }

    public void setOnCardboardBackListener(Runnable runnable) {
        this.cardboardViewApi.setOnCardboardBackListener(runnable);
    }

    public void setOnCardboardTriggerListener(Runnable runnable) {
        this.cardboardViewApi.setOnCardboardTriggerListener(runnable);
    }

    public void enableCardboardTriggerEmulation() {
        this.cardboardViewApi.enableCardboardTriggerEmulation();
    }

    public void queueEvent(Runnable runnable) {
        this.cardboardViewApi.getGvrSurfaceView().queueEvent(runnable);
    }

    public void setEGLConfigChooser(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.cardboardViewApi.getGvrSurfaceView().setEGLConfigChooser(n2, n3, n4, n5, n6, n7);
    }

    public void setEGLWindowSurfaceFactory(GLSurfaceView.EGLWindowSurfaceFactory eGLWindowSurfaceFactory) {
        this.cardboardViewApi.getGvrSurfaceView().setEGLWindowSurfaceFactory(eGLWindowSurfaceFactory);
    }

    public void setEGLContextClientVersion(int n2) {
        this.cardboardViewApi.getGvrSurfaceView().setEGLContextClientVersion(n2);
    }

    public GvrApi getGvrApi() {
        return this.cardboardViewApi.getGvrApi();
    }

    public CharSequence getAccessibilityClassName() {
        return GvrView.class.getName();
    }

    private void init(Context context) {
        if (this.isInEditMode()) {
            return;
        }
        if (!ContextUtils.canGetActivity(context)) {
            throw new IllegalArgumentException("An Activity Context is required for VR functionality.");
        }
        this.cardboardViewApi = ImplementationSelector.createCardboardViewApi(context);
        this.addView(this.cardboardViewApi.getRootView(), 0);
        GvrSurfaceView gvrSurfaceView = this.cardboardViewApi.getGvrSurfaceView();
        gvrSurfaceView.setEGLContextClientVersion(2);
        gvrSurfaceView.setPreserveEGLContextOnPause(true);
    }

    public static interface StereoRenderer {
        @UsedByNative
        public void onNewFrame(HeadTransform var1);

        @UsedByNative
        public void onDrawEye(Eye var1);

        @UsedByNative
        public void onFinishFrame(Viewport var1);

        public void onSurfaceChanged(int var1, int var2);

        public void onSurfaceCreated(EGLConfig var1);

        public void onRendererShutdown();
    }

    public static interface Renderer {
        @UsedByNative
        public void onDrawFrame(HeadTransform var1, Eye var2, Eye var3);

        @UsedByNative
        public void onFinishFrame(Viewport var1);

        public void onSurfaceChanged(int var1, int var2);

        public void onSurfaceCreated(EGLConfig var1);

        public void onRendererShutdown();
    }
}

