/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.base;

import android.app.Activity;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import com.google.vr.cardboard.AndroidNCompat;
import com.google.vr.cardboard.FullscreenMode;
import com.google.vr.sdk.base.GvrView;
import com.google.vr.sdk.base.GvrViewerParams;
import com.google.vrtoolkit.cardboard.ScreenOnFlagHelper;

public class GvrActivity
extends Activity {
    private FullscreenMode fullscreenMode;
    private final ScreenOnFlagHelper screenOnFlagHelper = new ScreenOnFlagHelper(this);
    private GvrView cardboardView;
    private boolean androidVrModeEnabled;

    public GvrActivity() {
    }

    public void setGvrView(GvrView gvrView) {
        this.setGvrView(gvrView, true);
    }

    public void setGvrView(GvrView gvrView, boolean bl2) {
        if (this.cardboardView == gvrView) {
            return;
        }
        if (this.cardboardView != null) {
            this.cardboardView.setOnCardboardTriggerListener(null);
        }
        this.cardboardView = gvrView;
        boolean bl3 = gvrView != null;
        boolean bl4 = this.androidVrModeEnabled = AndroidNCompat.setVrModeEnabled(this, bl3, bl2 ? 1 : 0) && bl3;
        if (gvrView == null) {
            return;
        }
        gvrView.setOnCardboardTriggerListener(new Runnable(){

            @Override
            public void run() {
                GvrActivity.this.onCardboardTrigger();
            }
        });
    }

    public GvrView getGvrView() {
        return this.cardboardView;
    }

    public void onCardboardTrigger() {
    }

    protected void updateGvrViewerParams(GvrViewerParams gvrViewerParams) {
        if (this.cardboardView != null) {
            this.cardboardView.updateGvrViewerParams(gvrViewerParams);
        }
    }

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.requestWindowFeature(1);
        this.fullscreenMode = new FullscreenMode(this.getWindow());
    }

    protected void onResume() {
        super.onResume();
        if (this.cardboardView != null) {
            this.cardboardView.onResume();
        }
        this.fullscreenMode.goFullscreen();
        this.screenOnFlagHelper.start();
    }

    protected void onPause() {
        super.onPause();
        if (this.cardboardView != null) {
            this.cardboardView.onPause();
        }
        this.screenOnFlagHelper.stop();
    }

    protected void onDestroy() {
        if (this.cardboardView != null) {
            this.cardboardView.setOnCardboardTriggerListener(null);
            this.cardboardView.shutdown();
            this.cardboardView = null;
        }
        super.onDestroy();
    }

    public void setContentView(View view) {
        if (view instanceof GvrView) {
            this.setGvrView((GvrView)view);
        }
        super.setContentView(view);
    }

    public void setContentView(View view, ViewGroup.LayoutParams layoutParams) {
        if (view instanceof GvrView) {
            this.setGvrView((GvrView)view);
        }
        super.setContentView(view, layoutParams);
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.cardboardView.onBackPressed();
    }

    public boolean onKeyDown(int n2, KeyEvent keyEvent) {
        return this.shouldSuppressKey(n2) || super.onKeyDown(n2, keyEvent);
    }

    public boolean onKeyUp(int n2, KeyEvent keyEvent) {
        return this.shouldSuppressKey(n2) || super.onKeyUp(n2, keyEvent);
    }

    public void onWindowFocusChanged(boolean bl2) {
        super.onWindowFocusChanged(bl2);
        this.fullscreenMode.onWindowFocusChanged(bl2);
    }

    public void setScreenAlwaysOn(boolean bl2) {
        this.screenOnFlagHelper.setScreenAlwaysOn(bl2);
    }

    private boolean shouldSuppressKey(int n2) {
        if (this.androidVrModeEnabled) {
            return n2 == 24 || n2 == 25;
        }
        return false;
    }
}

