/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.base;

import android.content.Context;
import android.opengl.EGL14;
import android.opengl.EGLDisplay;
import android.opengl.GLSurfaceView;
import android.os.Trace;
import android.util.Log;
import android.view.Display;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowManager;
import com.google.vr.cardboard.CardboardGLSurfaceView;
import com.google.vr.cardboard.ThreadUtils;
import com.google.vr.cardboard.UsedByNative;
import com.google.vr.ndk.base.BufferSpec;
import com.google.vr.ndk.base.GvrApi;
import com.google.vr.ndk.base.GvrLayout;
import com.google.vr.ndk.base.GvrSurfaceView;
import com.google.vr.ndk.base.GvrUiLayout;
import com.google.vr.sdk.base.CardboardViewApi;
import com.google.vr.sdk.base.Eye;
import com.google.vr.sdk.base.GvrView;
import com.google.vr.sdk.base.GvrViewerParams;
import com.google.vr.sdk.base.HeadMountedDisplay;
import com.google.vr.sdk.base.HeadMountedDisplayManager;
import com.google.vr.sdk.base.HeadTransform;
import com.google.vr.sdk.base.ScreenParams;
import java.lang.reflect.Field;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.opengles.GL10;

@UsedByNative
public class CardboardViewNativeImpl
implements CardboardGLSurfaceView.DetachListener,
CardboardViewApi {
    private static final String TAG = CardboardViewNativeImpl.class.getSimpleName();
    private final RendererHelper rendererHelper;
    private final HeadMountedDisplayManager hmdManager;
    private CountDownLatch shutdownLatch;
    private int cardboardTriggerCount = 0;
    private volatile Runnable cardboardTriggerListener;
    private volatile Runnable cardboardBackListener;
    private Runnable transitionDoneListener;
    private final CardboardGLSurfaceView glSurfaceView;
    private final GvrLayout gvrLayout;
    private final GvrUiLayout uiLayout;
    private final GvrApi gvrApi;
    private final Context context;
    private boolean stereoMode = true;
    private volatile boolean distortionCorrectionEnabled = true;
    private long nativeCardboardView;

    public CardboardViewNativeImpl(Context context) {
        String string2;
        this.context = context;
        this.hmdManager = new HeadMountedDisplayManager(context);
        try {
            String string3 = String.valueOf(this.getClass().getPackage().getName()).concat(".NativeProxy");
            Class<?> clazz = Class.forName(string3);
            Field field = clazz.getDeclaredField("PROXY_LIBRARY");
            string2 = (String)field.get(null);
        }
        catch (Exception exception) {
            Log.d((String)TAG, (String)"NativeProxy not found");
            string2 = "gvr";
        }
        String string4 = String.valueOf(string2);
        Log.d((String)TAG, (String)(string4.length() != 0 ? "Loading native library ".concat(string4) : new String("Loading native library ")));
        System.loadLibrary(string2);
        Log.d((String)TAG, (String)"Native library loaded");
        CardboardViewNativeImpl.nativeSetApplicationState(this.getClass().getClassLoader(), context.getApplicationContext());
        this.glSurfaceView = new CardboardGLSurfaceView(context, this);
        this.gvrLayout = new GvrLayout(context);
        this.gvrLayout.setPresentationView((View)this.glSurfaceView);
        this.rendererHelper = new RendererHelper();
        this.uiLayout = this.gvrLayout.getUiLayout();
        this.gvrApi = this.gvrLayout.getGvrApi();
        this.nativeCardboardView = this.nativeInit(this.gvrApi.getNativeGvrContext());
    }

    protected void finalize() throws Throwable {
        try {
            if (this.nativeCardboardView != 0L) {
                Log.w((String)TAG, (String)"GvrView.shutdown() should be called to ensure resource cleanup");
                this.nativeDestroy(this.nativeCardboardView);
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void onSurfaceViewDetachedFromWindow() {
        if (this.shutdownLatch == null) {
            this.shutdownLatch = new CountDownLatch(1);
            this.rendererHelper.shutdown();
            try {
                this.shutdownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                String string2 = String.valueOf(interruptedException.toString());
                Log.e((String)TAG, (String)(string2.length() != 0 ? "Interrupted during shutdown: ".concat(string2) : new String("Interrupted during shutdown: ")));
            }
            this.shutdownLatch = null;
        }
    }

    @Override
    public void setRenderer(GvrView.Renderer renderer) {
        this.rendererHelper.setRenderer(renderer);
        this.glSurfaceView.setRenderer(this.rendererHelper);
    }

    @Override
    public void setRenderer(GvrView.StereoRenderer stereoRenderer) {
        this.rendererHelper.setRenderer(stereoRenderer);
        this.glSurfaceView.setRenderer(this.rendererHelper);
    }

    @Override
    public void getCurrentEyeParams(HeadTransform headTransform, Eye eye, Eye eye2, Eye eye3, Eye eye4, Eye eye5) {
        this.rendererHelper.getCurrentEyeParams(headTransform, eye, eye2, eye3, eye4, eye5);
    }

    @Override
    public void setStereoModeEnabled(boolean bl2) {
        this.stereoMode = bl2;
        this.rendererHelper.setStereoModeEnabled(bl2);
    }

    @Override
    public boolean getStereoModeEnabled() {
        return this.stereoMode;
    }

    @Override
    public boolean setAsyncReprojectionEnabled(boolean bl2) {
        return this.gvrLayout.setAsyncReprojectionEnabled(bl2);
    }

    @Override
    public boolean getAsyncReprojectionEnabled() {
        return this.gvrLayout.getGvrApi().getAsyncReprojectionEnabled();
    }

    @Override
    public void setOnCloseButtonListener(Runnable runnable) {
        this.uiLayout.setCloseButtonListener(runnable);
    }

    @Override
    public void onBackPressed() {
        this.gvrLayout.onBackPressed();
    }

    @Override
    public void setTransitionViewEnabled(boolean bl2) {
        this.uiLayout.setTransitionViewEnabled(bl2);
    }

    @Override
    public void setOnTransitionViewDoneListener(Runnable runnable) {
        this.uiLayout.setTransitionViewListener(runnable);
    }

    @Override
    public HeadMountedDisplay getHeadMountedDisplay() {
        return this.hmdManager.getHeadMountedDisplay();
    }

    @Override
    public void setNeckModelEnabled(boolean bl2) {
        this.nativeSetNeckModelEnabled(this.nativeCardboardView, bl2);
    }

    @Override
    public float getNeckModelFactor() {
        return this.nativeGetNeckModelFactor(this.nativeCardboardView);
    }

    @Override
    public void setNeckModelFactor(float f2) {
        this.nativeSetNeckModelFactor(this.nativeCardboardView, f2);
    }

    @Override
    public void resetHeadTracker() {
        this.gvrApi.resetTracking();
    }

    @Override
    public void recenterHeadTracker() {
        this.gvrApi.recenterTracking();
    }

    @Override
    public void updateGvrViewerParams(GvrViewerParams gvrViewerParams) {
        if (this.hmdManager.updateGvrViewerParams(gvrViewerParams)) {
            this.setGvrViewerParams(this.getGvrViewerParams());
        }
    }

    @Override
    public GvrViewerParams getGvrViewerParams() {
        return this.hmdManager.getHeadMountedDisplay().getGvrViewerParams();
    }

    @Override
    public void updateScreenParams(ScreenParams screenParams) {
        if (this.hmdManager.updateScreenParams(screenParams)) {
            this.setScreenParams(this.getScreenParams());
        }
    }

    @Override
    public ScreenParams getScreenParams() {
        return this.hmdManager.getHeadMountedDisplay().getScreenParams();
    }

    @Override
    public float getInterpupillaryDistance() {
        return this.getGvrViewerParams().getInterLensDistance();
    }

    @Override
    public void setDistortionCorrectionEnabled(final boolean bl2) {
        this.checkNativeCardboardView();
        this.distortionCorrectionEnabled = bl2;
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                CardboardViewNativeImpl.this.nativeSetDistortionCorrectionEnabled(CardboardViewNativeImpl.this.nativeCardboardView, bl2);
            }
        });
    }

    @Override
    public boolean getDistortionCorrectionEnabled() {
        return this.distortionCorrectionEnabled;
    }

    @Override
    public void setDistortionCorrectionScale(final float f2) {
        this.checkNativeCardboardView();
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                CardboardViewNativeImpl.this.nativeSetDistortionCorrectionScale(CardboardViewNativeImpl.this.nativeCardboardView, f2);
            }
        });
    }

    @Override
    public void setMultisampling(final int n2) {
        this.checkNativeCardboardView();
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                CardboardViewNativeImpl.this.nativeSetMultisampling(CardboardViewNativeImpl.this.nativeCardboardView, n2);
            }
        });
    }

    @Override
    public void setDepthStencilFormat(final int n2) {
        this.checkNativeCardboardView();
        if (!BufferSpec.isValidDepthStencilFormat(n2)) {
            throw new IllegalArgumentException("Invalid depth-stencil format.");
        }
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                CardboardViewNativeImpl.this.nativeSetDepthStencilFormat(CardboardViewNativeImpl.this.nativeCardboardView, n2);
            }
        });
    }

    @Override
    public void onResume() {
        this.checkNativeCardboardView();
        this.gvrLayout.onResume();
        this.glSurfaceView.onResume();
        this.hmdManager.onResume();
        this.setScreenParams(this.getScreenParams());
        this.setGvrViewerParams(this.getGvrViewerParams());
        this.gvrApi.resumeTracking();
    }

    @Override
    public void onPause() {
        this.checkNativeCardboardView();
        this.gvrApi.pauseTracking();
        this.hmdManager.onPause();
        this.glSurfaceView.onPause();
        this.gvrLayout.onPause();
    }

    @Override
    public void shutdown() {
        if (this.nativeCardboardView != 0L) {
            this.hmdManager.close();
            this.gvrLayout.shutdown();
            this.nativeDestroy(this.nativeCardboardView);
            this.nativeCardboardView = 0L;
        }
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (motionEvent.getActionMasked() == 0 && this.cardboardTriggerListener != null) {
            this.onCardboardTrigger();
            return true;
        }
        return false;
    }

    @Override
    public void setOnCardboardTriggerListener(Runnable runnable) {
        this.cardboardTriggerListener = runnable;
    }

    @Override
    public void enableCardboardTriggerEmulation() {
        this.gvrLayout.enableCardboardTriggerEmulation(new Runnable(){

            @Override
            public void run() {
                CardboardViewNativeImpl.this.onCardboardTrigger();
            }
        });
    }

    @Override
    public void setOnCardboardBackListener(Runnable runnable) {
        this.cardboardBackListener = runnable;
    }

    @Override
    public View getRootView() {
        return this.gvrLayout;
    }

    @Override
    public GvrSurfaceView getGvrSurfaceView() {
        return this.glSurfaceView;
    }

    @Override
    public GvrApi getGvrApi() {
        return this.gvrApi;
    }

    private void runOnCardboardBackListener() {
        Runnable runnable = this.cardboardBackListener;
        if (runnable != null) {
            ThreadUtils.runOnUiThread(runnable);
        }
    }

    @UsedByNative
    private void onCardboardTrigger() {
        Runnable runnable = this.cardboardTriggerListener;
        if (runnable != null) {
            ThreadUtils.runOnUiThread(runnable);
        }
    }

    @UsedByNative
    private void onCardboardBack() {
        this.runOnCardboardBackListener();
    }

    private void queueEvent(Runnable runnable) {
        this.glSurfaceView.queueEvent(runnable);
    }

    private void setGvrViewerParams(final GvrViewerParams gvrViewerParams) {
        GvrViewerParams gvrViewerParams2 = new GvrViewerParams(gvrViewerParams);
        this.uiLayout.setViewerName(gvrViewerParams2.getModel());
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                CardboardViewNativeImpl.this.nativeSetGvrViewerParams(CardboardViewNativeImpl.this.nativeCardboardView, gvrViewerParams.toByteArray());
            }
        });
    }

    private void setScreenParams(ScreenParams screenParams) {
        final ScreenParams screenParams2 = new ScreenParams(screenParams);
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                CardboardViewNativeImpl.this.rendererHelper.setScreenParams(screenParams2);
                CardboardViewNativeImpl.this.nativeSetScreenParams(CardboardViewNativeImpl.this.nativeCardboardView, screenParams2.getWidth(), screenParams2.getHeight(), screenParams2.getWidthMeters() / (float)screenParams2.getWidth(), screenParams2.getHeightMeters() / (float)screenParams2.getHeight(), screenParams2.getBorderSizeMeters());
            }
        });
    }

    private void checkNativeCardboardView() {
        if (this.nativeCardboardView == 0L) {
            throw new IllegalStateException("GvrView has already been shut down.");
        }
    }

    private static Display getDefaultDisplay(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        return windowManager.getDefaultDisplay();
    }

    private static native long nativeSetApplicationState(ClassLoader var0, Context var1);

    private native long nativeInit(long var1);

    private native void nativeDestroy(long var1);

    private native void nativeSetRenderer(long var1, GvrView.Renderer var3);

    private native void nativeSetStereoRenderer(long var1, GvrView.StereoRenderer var3);

    private native void nativeOnSurfaceCreated(long var1);

    private native void nativeOnSurfaceChanged(long var1, int var3, int var4);

    private native void nativeOnDrawFrame(long var1);

    private native void nativeGetCurrentEyeParams(long var1, HeadTransform var3, Eye var4, Eye var5, Eye var6, Eye var7, Eye var8);

    private native void nativeSetNeckModelEnabled(long var1, boolean var3);

    private native float nativeGetNeckModelFactor(long var1);

    private native void nativeSetNeckModelFactor(long var1, float var3);

    private native void nativeSetGvrViewerParams(long var1, byte[] var3);

    private native void nativeSetScreenParams(long var1, int var3, int var4, float var5, float var6, float var7);

    private native void nativeSetStereoModeEnabled(long var1, boolean var3);

    private native void nativeSetDistortionCorrectionEnabled(long var1, boolean var3);

    private native void nativeSetDistortionCorrectionScale(long var1, float var3);

    private native void nativeSetMultisampling(long var1, int var3);

    private native void nativeSetDepthStencilFormat(long var1, int var3);

    private native void nativeUndistortTexture(long var1, int var3);

    private native void nativeLogEvent(long var1, int var3);

    class RendererHelper
    implements GLSurfaceView.Renderer {
        private GvrView.Renderer renderer;
        private GvrView.StereoRenderer stereoRenderer;
        private ScreenParams screenParams;
        private boolean stereoMode;
        private boolean surfaceCreated;
        private boolean invalidSurfaceSizeWarningShown;
        private EGLDisplay eglDisplay;

        public RendererHelper() {
            this.screenParams = new ScreenParams(CardboardViewNativeImpl.this.getScreenParams());
            this.stereoMode = CardboardViewNativeImpl.this.stereoMode;
        }

        public void setRenderer(GvrView.Renderer renderer) {
            this.renderer = renderer;
            CardboardViewNativeImpl.this.nativeSetRenderer(CardboardViewNativeImpl.this.nativeCardboardView, renderer);
        }

        public void setRenderer(GvrView.StereoRenderer stereoRenderer) {
            this.stereoRenderer = stereoRenderer;
            CardboardViewNativeImpl.this.nativeSetStereoRenderer(CardboardViewNativeImpl.this.nativeCardboardView, stereoRenderer);
        }

        public void setScreenParams(ScreenParams screenParams) {
            this.screenParams = screenParams;
        }

        public void shutdown() {
            CardboardViewNativeImpl.this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    if ((RendererHelper.this.renderer != null || RendererHelper.this.stereoRenderer != null) && RendererHelper.this.surfaceCreated) {
                        RendererHelper.this.surfaceCreated = false;
                        RendererHelper.this.callOnRendererShutdown();
                    }
                    CardboardViewNativeImpl.this.shutdownLatch.countDown();
                }
            });
        }

        public void setStereoModeEnabled(final boolean bl2) {
            CardboardViewNativeImpl.this.checkNativeCardboardView();
            CardboardViewNativeImpl.this.gvrLayout.setStereoModeEnabled(bl2);
            CardboardViewNativeImpl.this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    if (RendererHelper.this.stereoMode == bl2) {
                        return;
                    }
                    RendererHelper.this.stereoMode = bl2;
                    CardboardViewNativeImpl.this.nativeSetStereoModeEnabled(CardboardViewNativeImpl.this.nativeCardboardView, bl2);
                    if (!EGL10.EGL_NO_SURFACE.equals(((EGL10)EGLContext.getEGL()).eglGetCurrentSurface(12377))) {
                        RendererHelper.this.onSurfaceChanged(null, RendererHelper.this.screenParams.getWidth(), RendererHelper.this.screenParams.getHeight());
                    }
                }
            });
        }

        public void getCurrentEyeParams(final HeadTransform headTransform, final Eye eye, final Eye eye2, final Eye eye3, final Eye eye4, final Eye eye5) {
            CardboardViewNativeImpl.this.checkNativeCardboardView();
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            CardboardViewNativeImpl.this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    CardboardViewNativeImpl.this.nativeGetCurrentEyeParams(CardboardViewNativeImpl.this.nativeCardboardView, headTransform, eye, eye2, eye3, eye4, eye5);
                    countDownLatch.countDown();
                }
            });
            try {
                countDownLatch.await();
                return;
            }
            catch (InterruptedException interruptedException) {
                String string2 = String.valueOf(interruptedException.toString());
                Log.e((String)TAG, (String)(string2.length() != 0 ? "Interrupted while reading frame params: ".concat(string2) : new String("Interrupted while reading frame params: ")));
                return;
            }
        }

        public void onDrawFrame(GL10 gL10) {
            if (this.renderer == null && this.stereoRenderer == null || !this.surfaceCreated) {
                return;
            }
            Trace.beginSection((String)"Render");
            CardboardViewNativeImpl.this.nativeOnDrawFrame(CardboardViewNativeImpl.this.nativeCardboardView);
            Trace.endSection();
            EGL14.eglSwapInterval((EGLDisplay)this.eglDisplay, (int)1);
        }

        public void onSurfaceChanged(GL10 gL10, int n2, int n3) {
            if (this.renderer == null && this.stereoRenderer == null || !this.surfaceCreated) {
                return;
            }
            if (this.stereoMode && (n2 != this.screenParams.getWidth() || n3 != this.screenParams.getHeight())) {
                if (!this.invalidSurfaceSizeWarningShown) {
                    int n4 = this.screenParams.getWidth();
                    int n5 = this.screenParams.getHeight();
                    Log.e((String)TAG, (String)new StringBuilder(134).append("Surface size ").append(n2).append("x").append(n3).append(" does not match the expected screen size ").append(n4).append("x").append(n5).append(". Stereo rendering might feel off.").toString());
                }
                this.invalidSurfaceSizeWarningShown = true;
            } else {
                this.invalidSurfaceSizeWarningShown = false;
            }
            CardboardViewNativeImpl.this.nativeOnSurfaceChanged(CardboardViewNativeImpl.this.nativeCardboardView, n2, n3);
            this.callOnSurfaceChanged(n2, n3);
        }

        private void callOnSurfaceCreated(EGLConfig eGLConfig) {
            CardboardViewNativeImpl.this.nativeOnSurfaceCreated(CardboardViewNativeImpl.this.nativeCardboardView);
            if (this.renderer != null) {
                this.renderer.onSurfaceCreated(eGLConfig);
                return;
            }
            if (this.stereoRenderer != null) {
                this.stereoRenderer.onSurfaceCreated(eGLConfig);
            }
        }

        public void onSurfaceCreated(GL10 gL10, EGLConfig eGLConfig) {
            if (this.renderer == null && this.stereoRenderer == null) {
                return;
            }
            this.surfaceCreated = true;
            this.eglDisplay = EGL14.eglGetCurrentDisplay();
            this.callOnSurfaceCreated(eGLConfig);
        }

        private void callOnSurfaceChanged(int n2, int n3) {
            if (this.renderer != null) {
                this.renderer.onSurfaceChanged(n2, n3);
                return;
            }
            if (this.stereoRenderer != null) {
                if (this.stereoMode) {
                    this.stereoRenderer.onSurfaceChanged(n2 / 2, n3);
                    return;
                }
                this.stereoRenderer.onSurfaceChanged(n2, n3);
            }
        }

        private void callOnRendererShutdown() {
            if (this.renderer != null) {
                this.renderer.onRendererShutdown();
                return;
            }
            if (this.stereoRenderer != null) {
                this.stereoRenderer.onRendererShutdown();
            }
        }
    }
}

