/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.ndk.base;

import android.graphics.Point;
import android.util.Log;
import com.google.vr.ndk.base.Frame;
import com.google.vr.ndk.base.GvrApi;

public class SwapChain {
    private static final String TAG = SwapChain.class.getSimpleName();
    private long nativeSwapChain;
    private final Frame[] frames;
    private int currentFrame;

    SwapChain(long l2) {
        this.nativeSwapChain = l2;
        this.frames = new Frame[2];
        this.frames[0] = new Frame();
        this.frames[1] = new Frame();
        this.currentFrame = 0;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.nativeSwapChain != 0L) {
                Log.w((String)TAG, (String)"SwapChain.shutdown() should be called to ensure resource cleanup");
                this.shutdown();
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    public Frame acquireFrame() {
        if (this.frames[0].getNativeFrame() != 0L || this.frames[1].getNativeFrame() != 0L) {
            throw new RuntimeException("Previous frame not submitted");
        }
        this.currentFrame = (this.currentFrame + 1) % 2;
        long l2 = GvrApi.nativeSwapChainAcquireFrame(this.nativeSwapChain);
        if (l2 == 0L) {
            return null;
        }
        this.frames[this.currentFrame].setNativeFrame(l2);
        return this.frames[this.currentFrame];
    }

    public int getBufferCount() {
        return GvrApi.nativeSwapChainGetBufferCount(this.nativeSwapChain);
    }

    public void getBufferSize(int n2, Point point) {
        GvrApi.nativeSwapChainGetBufferSize(this.nativeSwapChain, n2, point);
    }

    public void resizeBuffer(int n2, Point point) {
        GvrApi.nativeSwapChainResizeBuffer(this.nativeSwapChain, n2, point.x, point.y);
    }

    public void shutdown() {
        if (this.nativeSwapChain != 0L) {
            GvrApi.nativeSwapChainDestroy(this.nativeSwapChain);
            this.nativeSwapChain = 0L;
        }
    }
}

