/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.ndk.base;

import android.content.Context;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.RectF;
import android.os.Build;
import android.os.Handler;
import android.os.StrictMode;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.Surface;
import com.google.common.logging.nano.Vr;
import com.google.vr.cardboard.DisplaySynchronizer;
import com.google.vr.cardboard.DisplayUtils;
import com.google.vr.cardboard.EglReadyListener;
import com.google.vr.cardboard.UsedByNative;
import com.google.vr.cardboard.VrParamsProvider;
import com.google.vr.cardboard.VrParamsProviderFactory;
import com.google.vr.cardboard.annotations.UsedByReflection;
import com.google.vr.ndk.base.BufferSpec;
import com.google.vr.ndk.base.BufferViewport;
import com.google.vr.ndk.base.BufferViewportList;
import com.google.vr.ndk.base.DefaultNativeLibraryLoader;
import com.google.vr.ndk.base.Event;
import com.google.vr.ndk.base.ExternalSurface;
import com.google.vr.ndk.base.GvrLayout;
import com.google.vr.ndk.base.Properties;
import com.google.vr.ndk.base.SdkConfigurationReader;
import com.google.vr.ndk.base.SwapChain;
import com.google.vr.ndk.base.UserPrefs;
import com.google.vr.sdk.deps.hu;
import com.google.vr.sdk.proto.nano.CardboardDevice;
import com.google.vr.sdk.proto.nano.Display;
import com.google.vr.sdk.proto.nano.Preferences;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

@UsedByReflection
public class GvrApi {
    private static final String TAG = "GvrApi";
    private static final boolean IS_ROBOLECTRIC_BUILD = "robolectric".equals(Build.FINGERPRINT);
    private static PoseTracker sPoseTrackerForTesting;
    private long nativeGvrContext;
    private final boolean ownsNativeGvrContext;
    private final Context context;
    private final VrParamsProvider vrParamsProvider;
    private final DisplaySynchronizer displaySynchronizer;
    private ArrayList<WeakReference<SwapChain>> swapChainRefs;
    private UserPrefs userPrefs;
    private Properties properties;

    public static void setPoseTrackerForTesting(PoseTracker poseTracker) {
        sPoseTrackerForTesting = poseTracker;
    }

    public static void setDynamicLibraryLoadingEnabled(boolean bl2) {
        GvrApi.nativeSetDynamicLibraryLoadingEnabled(bl2);
    }

    public static boolean usingDynamicLibrary(Context context) {
        GvrApi.setApplicationState(context);
        return GvrApi.nativeUsingDynamicLibrary();
    }

    public static boolean usingShimLibrary() {
        return GvrApi.nativeUsingShimLibrary();
    }

    public GvrApi(Context context, DisplaySynchronizer displaySynchronizer) {
        this.context = context;
        this.displaySynchronizer = displaySynchronizer;
        long l2 = displaySynchronizer == null ? 0L : displaySynchronizer.getNativeDisplaySynchronizer();
        this.vrParamsProvider = VrParamsProviderFactory.create(context);
        this.vrParamsProvider.readDisplayParams();
        this.swapChainRefs = new ArrayList();
        this.ownsNativeGvrContext = true;
        if (!IS_ROBOLECTRIC_BUILD) {
            StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
            try {
                this.nativeGvrContext = this.nativeCreate(this.getClass().getClassLoader(), context.getApplicationContext(), l2, sPoseTrackerForTesting);
            }
            finally {
                StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
            }
            if (this.nativeGvrContext == 0L) {
                throw new IllegalStateException("Native GVR context creation failed, implementation unavailable.");
            }
        }
    }

    GvrApi(Context context, long l2) {
        if (l2 == 0L) {
            throw new IllegalArgumentException("Invalid wrapped native GVR context.");
        }
        this.context = context;
        this.ownsNativeGvrContext = false;
        this.nativeGvrContext = l2;
        this.vrParamsProvider = VrParamsProviderFactory.create(context);
        this.displaySynchronizer = null;
        this.swapChainRefs = new ArrayList();
        GvrApi.setApplicationState(context);
    }

    void requestContextSharing(EglReadyListener eglReadyListener) {
        this.nativeRequestContextSharing(this.nativeGvrContext, eglReadyListener);
    }

    static DisplaySynchronizer createDefaultDisplaySynchronizer(Context context) {
        return new DisplaySynchronizer(context, DisplayUtils.getDefaultDisplay(context));
    }

    protected void finalize() throws Throwable {
        try {
            if (this.nativeGvrContext != 0L) {
                Log.w((String)TAG, (String)"GvrApi.shutdown() should be called to ensure resource cleanup");
                this.shutdown();
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    Vr.VREvent.SdkConfigurationParams getSdkConfigurationParams() {
        return SdkConfigurationReader.getParams(this.context);
    }

    void pause() {
        this.nativePause(this.nativeGvrContext);
    }

    void resume() {
        this.nativeResume(this.nativeGvrContext);
    }

    public void shutdown() {
        ArrayList<WeakReference<SwapChain>> arrayList = this.swapChainRefs;
        int n2 = arrayList.size();
        Object var1_4 = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            WeakReference<SwapChain> weakReference = arrayList.get(i2);
            WeakReference<SwapChain> weakReference2 = weakReference;
            SwapChain swapChain = (SwapChain)weakReference.get();
            if (swapChain == null) continue;
            swapChain.shutdown();
        }
        if (this.nativeGvrContext != 0L) {
            this.vrParamsProvider.close();
            if (this.ownsNativeGvrContext) {
                this.nativeReleaseGvrContext(this.nativeGvrContext);
            }
            this.nativeGvrContext = 0L;
        }
    }

    @UsedByReflection
    public long getNativeGvrContext() {
        return this.nativeGvrContext;
    }

    public int getError() {
        return this.nativeGetError(this.nativeGvrContext);
    }

    public int clearError() {
        return this.nativeClearError(this.nativeGvrContext);
    }

    public static String getErrorString(int n2) {
        return GvrApi.nativeGetErrorString(n2);
    }

    public UserPrefs getUserPrefs() {
        if (this.userPrefs == null) {
            this.userPrefs = new UserPrefs(this.nativeGetUserPrefs(this.nativeGvrContext));
        }
        return this.userPrefs;
    }

    boolean isOpenGLKHRDebugEnabled() {
        Preferences.UserPrefs userPrefs = this.vrParamsProvider.readUserPrefs();
        if (userPrefs == null) {
            return false;
        }
        Preferences.DeveloperPrefs developerPrefs = userPrefs.developerPrefs;
        return developerPrefs != null && developerPrefs.getOpenglKhrDebugEnabled();
    }

    void dumpDebugData() {
        this.nativeDumpDebugData(this.nativeGvrContext);
    }

    public void initializeGl() {
        this.nativeInitializeGl(this.nativeGvrContext);
    }

    public void onSurfaceCreatedReprojectionThread() {
        this.nativeOnSurfaceCreatedReprojectionThread(this.nativeGvrContext);
    }

    public void onSurfaceChangedReprojectionThread() {
        this.nativeOnSurfaceChangedReprojectionThread(this.nativeGvrContext);
    }

    public BufferSpec createBufferSpec() {
        return new BufferSpec(GvrApi.nativeBufferSpecCreate(this.nativeGvrContext));
    }

    public ExternalSurface createExternalSurface(GvrLayout.ExternalSurfaceListener externalSurfaceListener, Handler handler) {
        return new ExternalSurface(this, externalSurfaceListener, handler);
    }

    public SwapChain createSwapChain(BufferSpec[] bufferSpecArray) {
        long[] lArray = new long[bufferSpecArray.length];
        for (int i2 = 0; i2 < bufferSpecArray.length; ++i2) {
            lArray[i2] = bufferSpecArray[i2].nativeBufferSpec;
        }
        SwapChain swapChain = new SwapChain(GvrApi.nativeSwapChainCreate(this.nativeGvrContext, lArray));
        this.swapChainRefs.add(new WeakReference<SwapChain>(swapChain));
        return swapChain;
    }

    public BufferViewportList createBufferViewportList() {
        return new BufferViewportList(this.nativeBufferViewportListCreate(this.nativeGvrContext));
    }

    public BufferViewport createBufferViewport() {
        return new BufferViewport(GvrApi.nativeBufferViewportCreate(this.nativeGvrContext));
    }

    public void getRecommendedBufferViewports(BufferViewportList bufferViewportList) {
        this.nativeGetRecommendedBufferViewports(this.nativeGvrContext, bufferViewportList.nativeBufferViewportList);
    }

    public void getScreenBufferViewports(BufferViewportList bufferViewportList) {
        this.nativeGetScreenBufferViewports(this.nativeGvrContext, bufferViewportList.nativeBufferViewportList);
    }

    public void getMaximumEffectiveRenderTargetSize(Point point) {
        this.nativeGetMaximumEffectiveRenderTargetSize(this.nativeGvrContext, point);
    }

    public void getScreenTargetSize(Point point) {
        this.nativeGetScreenTargetSize(this.nativeGvrContext, point);
    }

    @Deprecated
    public void distortToScreen(int n2, BufferViewportList bufferViewportList, float[] fArray, long l2) {
        if (fArray == null) {
            throw new IllegalArgumentException("Head transform must not be null.");
        }
        this.nativeDistortToScreen(this.nativeGvrContext, n2, bufferViewportList.nativeBufferViewportList, fArray, l2);
    }

    public Point renderReprojectionThread() {
        return this.nativeRenderReprojectionThread(this.nativeGvrContext);
    }

    public void onPauseReprojectionThread() {
        this.nativeOnPauseReprojectionThread(this.nativeGvrContext);
    }

    public void setDefaultFramebufferActive() {
        this.nativeSetDefaultFramebufferActive(this.nativeGvrContext);
    }

    @Deprecated
    public void getHeadSpaceFromStartSpaceRotation(float[] fArray, long l2) {
        if (fArray == null || fArray.length != 16) {
            throw new IllegalArgumentException("Invalid head rotation argument, must be a float[16].");
        }
        this.nativeGetHeadSpaceFromStartSpaceRotation(this.nativeGvrContext, fArray, l2);
    }

    public void getHeadSpaceFromStartSpaceTransform(float[] fArray, long l2) {
        if (fArray == null || fArray.length != 16) {
            throw new IllegalArgumentException("Invalid head transform argument, must be a float[16].");
        }
        this.nativeGetHeadSpaceFromStartSpaceTransform(this.nativeGvrContext, fArray, l2);
    }

    void setIgnoreManualTrackerPauseResume(boolean bl2) {
        this.nativeSetIgnoreManualPauseResumeTracker(this.nativeGvrContext, bl2);
    }

    public void pauseTracking() {
        this.nativePauseTracking(this.nativeGvrContext);
    }

    public void resumeTracking() {
        this.nativeResumeTracking(this.nativeGvrContext);
    }

    public byte[] pauseTrackingGetState() {
        return this.nativePauseTrackingGetState(this.nativeGvrContext);
    }

    public void resumeTrackingSetState(byte[] byArray) {
        this.nativeResumeTrackingSetState(this.nativeGvrContext, byArray);
    }

    public void resetTracking() {
        this.nativeResetTracking(this.nativeGvrContext);
    }

    public void recenterTracking() {
        this.nativeRecenterTracking(this.nativeGvrContext);
    }

    public void reconnectSensors() {
        this.nativeReconnectSensors(this.nativeGvrContext);
    }

    void setIdleListener(IdleListener idleListener) {
        this.nativeSetIdleListener(this.nativeGvrContext, idleListener);
    }

    public boolean setDefaultViewerProfile(String string2) {
        return this.nativeSetDefaultViewerProfile(this.nativeGvrContext, string2);
    }

    public void refreshViewerProfile() {
        CardboardDevice.DeviceParams deviceParams = this.vrParamsProvider.readDeviceParams();
        if (deviceParams != null) {
            this.setViewerParams(hu.toByteArray(deviceParams));
        }
    }

    public String getViewerVendor() {
        return this.nativeGetViewerVendor(this.nativeGvrContext);
    }

    public String getViewerModel() {
        return this.nativeGetViewerModel(this.nativeGvrContext);
    }

    public int getViewerType() {
        return this.nativeGetViewerType(this.nativeGvrContext);
    }

    @Deprecated
    public float[] getEyeFromHeadMatrix(int n2) {
        float[] fArray = new float[16];
        this.getEyeFromHeadMatrix(n2, fArray);
        return fArray;
    }

    public void getEyeFromHeadMatrix(int n2, float[] fArray) {
        this.nativeGetEyeFromHeadMatrix(this.nativeGvrContext, n2, fArray);
    }

    public int[] getWindowBounds() {
        int[] nArray = this.nativeGetWindowBounds(this.nativeGvrContext);
        if (nArray.length != 4) {
            throw new AssertionError((Object)"Implementation error: invalid window bounds.");
        }
        return nArray;
    }

    public float[] computeDistortedPoint(int n2, float[] fArray) {
        float[] fArray2 = this.nativeComputeDistortedPoint(this.nativeGvrContext, n2, fArray);
        if (fArray2.length != 6) {
            throw new AssertionError((Object)"Implementation error: invalid UV coordinates output.");
        }
        return fArray2;
    }

    boolean setAsyncReprojectionEnabled(boolean bl2) {
        return this.nativeSetAsyncReprojectionEnabled(this.nativeGvrContext, bl2);
    }

    public boolean getAsyncReprojectionEnabled() {
        return this.nativeGetAsyncReprojectionEnabled(this.nativeGvrContext);
    }

    public void setSurfaceSize(int n2, int n3) {
        if (n2 == 0 != (n3 == 0)) {
            throw new IllegalArgumentException("Custom surface dimensions should both either be zero or non-zero");
        }
        this.nativeSetSurfaceSize(this.nativeGvrContext, n2, n3);
    }

    public boolean isFeatureSupported(int n2) {
        return this.nativeIsFeatureSupported(this.nativeGvrContext, n2);
    }

    public void setLensOffset(float f2, float f3, float f4) {
        this.nativeSetLensOffset(this.nativeGvrContext, f2, f3, f4);
    }

    public boolean pollEvent(Event event) {
        return this.nativePollEvent(this.nativeGvrContext, event.nativeEvent);
    }

    public Properties getCurrentProperties() {
        if (this.properties == null) {
            this.properties = new Properties(this.nativeGetCurrentProperties(this.nativeGvrContext));
        }
        return this.properties;
    }

    DisplayMetrics computeCurrentDisplayMetrics(Display.DisplayParams displayParams) {
        Display display = this.displaySynchronizer == null ? DisplayUtils.getDefaultDisplay(this.context) : this.displaySynchronizer.getDisplay();
        return DisplayUtils.getDisplayMetricsLandscapeWithOverride(display, displayParams);
    }

    public float getBorderSizeMeters() {
        return this.nativeGetBorderSizeMeters(this.nativeGvrContext);
    }

    private boolean setViewerParams(byte[] byArray) {
        return this.nativeSetViewerParams(this.nativeGvrContext, byArray);
    }

    public boolean usingVrDisplayService() {
        return this.nativeUsingVrDisplayService(this.nativeGvrContext);
    }

    private static void setApplicationState(Context context) {
        if (!IS_ROBOLECTRIC_BUILD) {
            GvrApi.nativeSetApplicationState(GvrApi.class.getClassLoader(), context.getApplicationContext());
        }
    }

    private native long nativeBufferViewportListCreate(long var1);

    static native void nativeBufferViewportListDestroy(long var0);

    static native int nativeBufferViewportListGetSize(long var0);

    static native void nativeBufferViewportListGetItem(long var0, int var2, long var3);

    static native void nativeBufferViewportListSetItem(long var0, int var2, long var3);

    static native long nativeBufferViewportCreate(long var0);

    static native void nativeBufferViewportDestroy(long var0);

    static native void nativeBufferViewportGetSourceUv(long var0, RectF var2);

    static native void nativeBufferViewportSetSourceUv(long var0, float var2, float var3, float var4, float var5);

    static native void nativeBufferViewportGetSourceFov(long var0, RectF var2);

    static native void nativeBufferViewportSetSourceFov(long var0, float var2, float var3, float var4, float var5);

    static native void nativeBufferViewportGetTransform(long var0, float[] var2);

    static native void nativeBufferViewportSetTransform(long var0, float[] var2);

    static native boolean nativeBufferViewportEqual(long var0, long var2);

    static native int nativeBufferViewportGetTargetEye(long var0);

    static native void nativeBufferViewportSetTargetEye(long var0, int var2);

    static native int nativeBufferViewportGetSourceBufferIndex(long var0);

    static native void nativeBufferViewportSetSourceBufferIndex(long var0, int var2);

    static native int nativeBufferViewportGetExternalSurfaceId(long var0);

    static native void nativeBufferViewportSetExternalSurfaceId(long var0, int var2);

    static native void nativeBufferViewportSetExternalSurface(long var0, long var2);

    static native int nativeBufferViewportGetReprojection(long var0);

    static native void nativeBufferViewportSetReprojection(long var0, int var2);

    static native void nativeBufferViewportSetSourceLayer(long var0, int var2);

    static native float nativeBufferViewportGetOpacity(long var0);

    static native void nativeBufferViewportSetOpacity(long var0, float var2);

    static native void nativeBufferViewportGetVignetteFraction(long var0, PointF var2);

    static native void nativeBufferViewportSetVignetteFraction(long var0, float var2, float var3);

    static native void nativeBufferViewportSetEyeFromWorldMatrix(long var0, float[] var2);

    static native void nativeBufferViewportUnsetEyeFromWorldMatrix(long var0);

    static native long nativeBufferSpecCreate(long var0);

    static native void nativeBufferSpecDestroy(long var0);

    static native void nativeBufferSpecGetSize(long var0, Point var2);

    static native void nativeBufferSpecSetSize(long var0, int var2, int var3);

    static native void nativeBufferSpecSetColorFormat(long var0, int var2);

    static native void nativeBufferSpecSetDepthStencilFormat(long var0, int var2);

    static native void nativeBufferSpecSetMultiviewLayers(long var0, int var2);

    static native int nativeBufferSpecGetSamples(long var0);

    static native void nativeBufferSpecSetSamples(long var0, int var2);

    static native long nativeExternalSurfaceCreate(long var0);

    static native long nativeExternalSurfaceCreateWithListeners(long var0, Runnable var2, Runnable var3, Handler var4);

    static native void nativeExternalSurfaceDestroy(long var0);

    static native int nativeExternalSurfaceGetId(long var0);

    static native Surface nativeExternalSurfaceGetSurface(long var0);

    static native long nativeSwapChainCreate(long var0, long[] var2);

    static native void nativeSwapChainDestroy(long var0);

    static native int nativeSwapChainGetBufferCount(long var0);

    static native void nativeSwapChainGetBufferSize(long var0, int var2, Point var3);

    static native void nativeSwapChainResizeBuffer(long var0, int var2, int var3, int var4);

    static native long nativeSwapChainAcquireFrame(long var0);

    static native void nativeFrameBindBuffer(long var0, int var2);

    static native void nativeFrameUnbind(long var0);

    static native int nativeFrameGetFramebufferObject(long var0, int var2);

    static native void nativeFrameGetBufferSize(long var0, int var2, Point var3);

    static native void nativeFrameSubmit(long var0, long var2, float[] var4);

    private static native boolean nativeUsingDynamicLibrary();

    private static native boolean nativeUsingShimLibrary();

    private static native void nativeSetApplicationState(ClassLoader var0, Context var1);

    private static native void nativeSetDynamicLibraryLoadingEnabled(boolean var0);

    private native long nativeCreate(ClassLoader var1, Context var2, long var3, PoseTracker var5);

    private native void nativeRequestContextSharing(long var1, EglReadyListener var3);

    private native int nativeGetError(long var1);

    private native int nativeClearError(long var1);

    private static native String nativeGetErrorString(int var0);

    private native long nativeGetUserPrefs(long var1);

    static native int nativeUserPrefsGetControllerHandedness(long var0);

    static native boolean nativeUserPrefsGetPerformanceMonitoringEnabled(long var0);

    static native boolean nativeUserPrefsGetPerformanceHudEnabled(long var0);

    static native byte[] nativeAnalyticsCreateSample(long var0, byte[] var2);

    private native void nativePause(long var1);

    private native void nativeResume(long var1);

    private native void nativeReleaseGvrContext(long var1);

    private native void nativeInitializeGl(long var1);

    private native void nativeOnSurfaceCreatedReprojectionThread(long var1);

    private native void nativeOnSurfaceChangedReprojectionThread(long var1);

    private native void nativeGetRecommendedBufferViewports(long var1, long var3);

    private native void nativeGetScreenBufferViewports(long var1, long var3);

    private native void nativeGetMaximumEffectiveRenderTargetSize(long var1, Point var3);

    private native void nativeGetScreenTargetSize(long var1, Point var3);

    private native void nativeDistortToScreen(long var1, int var3, long var4, float[] var6, long var7);

    private native void nativeSetDefaultFramebufferActive(long var1);

    private native Point nativeRenderReprojectionThread(long var1);

    private native void nativeOnPauseReprojectionThread(long var1);

    private native void nativeGetHeadSpaceFromStartSpaceRotation(long var1, float[] var3, long var4);

    private native void nativeGetHeadSpaceFromStartSpaceTransform(long var1, float[] var3, long var4);

    private native void nativeSetIgnoreManualPauseResumeTracker(long var1, boolean var3);

    private native void nativePauseTracking(long var1);

    private native byte[] nativePauseTrackingGetState(long var1);

    private native void nativeResumeTracking(long var1);

    private native void nativeResumeTrackingSetState(long var1, byte[] var3);

    private native void nativeResetTracking(long var1);

    private native void nativeRecenterTracking(long var1);

    private native void nativeGetEyeFromHeadMatrix(long var1, int var3, float[] var4);

    private native int[] nativeGetWindowBounds(long var1);

    private native float[] nativeComputeDistortedPoint(long var1, int var3, float[] var4);

    private native boolean nativeSetDefaultViewerProfile(long var1, String var3);

    private native String nativeGetViewerVendor(long var1);

    private native String nativeGetViewerModel(long var1);

    private native int nativeGetViewerType(long var1);

    private native boolean nativeSetAsyncReprojectionEnabled(long var1, boolean var3);

    private native boolean nativeGetAsyncReprojectionEnabled(long var1);

    private native boolean nativeIsFeatureSupported(long var1, int var3);

    private native void nativeReconnectSensors(long var1);

    private native void nativeSetIdleListener(long var1, IdleListener var3);

    private native boolean nativeSetViewerParams(long var1, byte[] var3);

    private native float nativeGetBorderSizeMeters(long var1);

    private native void nativeSetSurfaceSize(long var1, int var3, int var4);

    private native void nativeSetLensOffset(long var1, float var3, float var4, float var5);

    private native void nativeDumpDebugData(long var1);

    private native boolean nativeUsingVrDisplayService(long var1);

    private native boolean nativePollEvent(long var1, long var3);

    static native long nativeCreateEvent();

    static native void nativeDestroyEvent(long var0);

    static native long nativeGetEventTimestamp(long var0);

    static native int nativeGetEventType(long var0);

    static native long nativeGetEventFlags(long var0);

    static native int nativeGetRecenterEventType(long var0);

    static native long nativeGetRecenterEventFlags(long var0);

    static native void nativeGetRecenterEventStartSpaceFromTrackingSpaceTransform(long var0, float[] var2);

    static native long nativeCreateValue();

    static native void nativeDestroyValue(long var0);

    private native long nativeGetCurrentProperties(long var1);

    static native boolean nativeGetProperty(long var0, int var2, long var3);

    static native long nativeValueGetFlags(long var0);

    static native float nativeValueAsFloat(long var0);

    static native int nativeValueAsInt(long var0);

    static native long nativeValueAsFlags(long var0);

    static native void nativeValueAsMat4f(long var0, float[] var2);

    static {
        DefaultNativeLibraryLoader.maybeLoadDefaultLibrary();
    }

    public static abstract class ViewerType {
        public static final int CARDBOARD = 0;
        public static final int DAYDREAM = 1;
        static final int DEFAULT = 0;

        public ViewerType() {
        }
    }

    @UsedByNative
    static interface IdleListener {
        @UsedByNative
        public void onIdleChanged(boolean var1);
    }

    public static abstract class Error {
        public static final int NONE = 0;
        public static final int CONTROLLER_CREATE_FAILED = 2;
        public static final int NO_FRAME_AVAILABLE = 3;

        public Error() {
        }
    }

    @UsedByNative
    public static interface PoseTracker {
        @UsedByNative
        public void getHeadPoseInStartSpace(float[] var1, long var2);
    }

    public static abstract class Feature {
        public static final int ASYNC_REPROJECTION = 0;
        public static final int MULTIVIEW = 1;
        public static final int EXTERNAL_SURFACE = 2;
        public static final int HEAD_POSE_6DOF = 3;
        public static final int HARDWARE_BUFFERS = 4;

        public Feature() {
        }
    }
}

