/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.ndk.base;

import android.graphics.Point;
import android.util.Log;
import com.google.vr.ndk.base.BufferViewportList;
import com.google.vr.ndk.base.GvrApi;

public class Frame {
    private static final String TAG = Frame.class.getSimpleName();
    private long nativeFrame = 0L;

    Frame() {
    }

    protected void finalize() throws Throwable {
        try {
            if (this.nativeFrame != 0L) {
                Log.w((String)TAG, (String)"Frame finalized before it was submitted");
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    public void bindBuffer(int n2) {
        this.checkAccess();
        GvrApi.nativeFrameBindBuffer(this.nativeFrame, n2);
    }

    public void unbind() {
        this.checkAccess();
        GvrApi.nativeFrameUnbind(this.nativeFrame);
    }

    public int getFramebufferObject(int n2) {
        this.checkAccess();
        return GvrApi.nativeFrameGetFramebufferObject(this.nativeFrame, n2);
    }

    public void getBufferSize(int n2, Point point) {
        this.checkAccess();
        GvrApi.nativeFrameGetBufferSize(this.nativeFrame, n2, point);
    }

    public void submit(BufferViewportList bufferViewportList, float[] fArray) {
        this.checkAccess();
        GvrApi.nativeFrameSubmit(this.nativeFrame, bufferViewportList.nativeBufferViewportList, fArray);
        this.nativeFrame = 0L;
    }

    void setNativeFrame(long l2) {
        this.nativeFrame = l2;
    }

    long getNativeFrame() {
        return this.nativeFrame;
    }

    private void checkAccess() {
        if (this.nativeFrame == 0L) {
            throw new RuntimeException("Frame was reused after submission");
        }
    }
}

