/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.ndk.base;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.view.View;
import android.view.animation.AnimationUtils;

class FadeOverlayView
extends View {
    private static final String TAG = "FadeOverlayView";
    private static final boolean DEBUG = false;
    private static final int MSG_AUTO_FADE = 77337733;
    static final int DEFAULT_BACKGROUND_COLOR = -16777216;
    static final long AUTO_FADE_DURATION_MILLIS = 350L;
    static final long AUTO_FADE_START_DELAY_MILLIS = 1000L;
    static final int AUTO_FADE_QUICK_START_DELAY_MILLIS = 200;
    private int fadeType = 0;
    private long fadeStartTimeMillis;
    private float fadeStartOpacity;
    private long fadeDurationMillis;
    private boolean flushAutoFadeOnVisible;
    private boolean visible;
    private final boolean autoFadeEnabled;
    private final Runnable fadeUpdateRunnable = new Runnable(){

        @Override
        public void run() {
            FadeOverlayView.this.updateFade();
        }
    };
    private final Handler autoFadeHandler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message message) {
            if (message.what == 77337733) {
                FadeOverlayView.this.startFade(1, 350L, -16777216);
                return;
            }
            super.handleMessage(message);
        }
    };

    public FadeOverlayView(Context context, boolean bl2) {
        super(context);
        this.setBackgroundColor(-16777216);
        this.autoFadeEnabled = bl2;
    }

    public void startFade(int n2, long l2, int n3) {
        if (!this.isEnabled()) {
            Log.w((String)TAG, (String)"Ignoring fade request while disabled.");
            return;
        }
        if (!this.visible) {
            Log.w((String)TAG, (String)"Ignoring fade request while invisible.");
            return;
        }
        this.setBackgroundColor(n3);
        this.removeFadeCallbacks();
        this.fadeType = n2;
        this.fadeDurationMillis = l2;
        this.fadeStartTimeMillis = AnimationUtils.currentAnimationTimeMillis();
        this.fadeStartOpacity = this.getAlpha();
        this.updateFade();
    }

    public void onInvisible() {
        if (!this.visible) {
            return;
        }
        this.visible = false;
        if (this.isEnabled() && this.autoFadeEnabled) {
            this.removeFadeCallbacks();
            this.fadeType = 2;
            this.endFade();
        }
    }

    public void onVisible() {
        if (this.visible && this.getAlpha() == 0.0f) {
            return;
        }
        this.visible = true;
        if (this.isEnabled() && this.autoFadeEnabled) {
            this.removeFadeCallbacks();
            this.autoFadeHandler.sendEmptyMessageDelayed(77337733, this.flushAutoFadeOnVisible ? 200L : 1000L);
            return;
        }
        this.fadeType = 1;
        this.endFade();
    }

    public void flushAutoFade() {
        if (!this.autoFadeEnabled) {
            return;
        }
        if (this.autoFadeHandler.hasMessages(77337733)) {
            this.autoFadeHandler.removeMessages(77337733);
            this.autoFadeHandler.sendEmptyMessageDelayed(77337733, 200L);
            return;
        }
        if (!this.visible) {
            this.flushAutoFadeOnVisible = true;
        }
    }

    public void setEnabled(boolean bl2) {
        if (this.isEnabled() == bl2) {
            return;
        }
        super.setEnabled(bl2);
        if (!bl2) {
            this.removeFadeCallbacks();
            this.fadeType = 1;
            this.endFade();
        }
    }

    int getFadeType() {
        return this.fadeType;
    }

    boolean isVisible() {
        return this.visible;
    }

    private void removeFadeCallbacks() {
        this.autoFadeHandler.removeMessages(77337733);
        this.removeCallbacks(this.fadeUpdateRunnable);
    }

    private void endFade() {
        if (this.fadeType == 0) {
            return;
        }
        this.setVisibility(this.fadeType == 2 ? 0 : 8);
        this.setAlpha(this.fadeType == 2 ? 1.0f : 0.0f);
        this.removeCallbacks(this.fadeUpdateRunnable);
        this.fadeType = 0;
        this.flushAutoFadeOnVisible = false;
    }

    private void updateFade() {
        long l2 = AnimationUtils.currentAnimationTimeMillis() - this.fadeStartTimeMillis;
        float f2 = (float)l2 / (float)this.fadeDurationMillis;
        if (this.fadeType == 1) {
            f2 = -f2;
        }
        float f3 = Math.min(Math.max(this.fadeStartOpacity + f2, 0.0f), 1.0f);
        this.setAlpha(f3);
        if (l2 < this.fadeDurationMillis && this.getVisibility() != 0) {
            this.setVisibility(0);
        }
        if (l2 >= this.fadeDurationMillis || this.fadeType == 1 && f3 <= 0.0f || this.fadeType == 2 && f3 >= 1.0f) {
            this.endFade();
            return;
        }
        this.postOnAnimation(this.fadeUpdateRunnable);
    }
}

