/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.ndk.base;

import android.util.Log;

public class DaydreamCompatibility {
    private static final String TAG = "DaydreamCompatibility";
    private final int supportedHeadsets;
    public static final int SUPPORTS_DAYDREAM = 1;
    public static final int SUPPORTS_CARDBOARD = 2;
    public static final int SUPPORTS_CONTROLLERLESS_DAYDREAM = 4;
    public static final int DAYDREAM_NOT_SUPPORTED = 1;
    public static final int DAYDREAM_OPTIONAL = 2;
    public static final int DAYDREAM_REQUIRED = 3;

    public DaydreamCompatibility(int n2) {
        this.supportedHeadsets = n2;
    }

    public DaydreamCompatibility() {
        this(0);
    }

    public int getSupportedHeadsets() {
        return this.supportedHeadsets;
    }

    public boolean supportsDaydream() {
        return (this.supportedHeadsets & 5) != 0;
    }

    public boolean supportsControllerlessDaydream() {
        return (this.supportedHeadsets & 4) != 0;
    }

    public boolean requiresDaydream() {
        return this.supportsDaydream() && !this.supportsCardboard();
    }

    public int toDeprecated() {
        if (this.requiresDaydream()) {
            return 3;
        }
        if (this.supportsDaydream()) {
            return 2;
        }
        return 1;
    }

    public static DaydreamCompatibility fromDeprecated(int n2) {
        int n3 = 0;
        switch (n2) {
            case 3: {
                n3 = 1;
                break;
            }
            case 2: {
                n3 = 3;
                break;
            }
            case 1: {
                break;
            }
            default: {
                Log.e((String)TAG, (String)new StringBuilder(47).append("Invalid deprecated daydream compat: ").append(n2).toString());
            }
        }
        return new DaydreamCompatibility(n3);
    }

    private boolean supportsCardboard() {
        return (this.supportedHeadsets & 2) != 0;
    }
}

