/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.ndk.base;

import android.util.Log;
import com.google.vr.ndk.base.BufferViewport;
import com.google.vr.ndk.base.GvrApi;

public class BufferViewportList {
    private static final String TAG = BufferViewportList.class.getSimpleName();
    long nativeBufferViewportList;

    BufferViewportList(long l2) {
        this.nativeBufferViewportList = l2;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.nativeBufferViewportList != 0L) {
                Log.w((String)TAG, (String)"BufferViewportList.shutdown() should be called to ensure resource cleanup");
                this.shutdown();
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    public void shutdown() {
        if (this.nativeBufferViewportList != 0L) {
            GvrApi.nativeBufferViewportListDestroy(this.nativeBufferViewportList);
            this.nativeBufferViewportList = 0L;
        }
    }

    public void get(int n2, BufferViewport bufferViewport) {
        GvrApi.nativeBufferViewportListGetItem(this.nativeBufferViewportList, n2, bufferViewport.nativeBufferViewport);
    }

    public void set(int n2, BufferViewport bufferViewport) {
        GvrApi.nativeBufferViewportListSetItem(this.nativeBufferViewportList, n2, bufferViewport.nativeBufferViewport);
    }

    public int size() {
        return GvrApi.nativeBufferViewportListGetSize(this.nativeBufferViewportList);
    }
}

