/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.cardboard;

import android.content.Context;
import android.content.res.Resources;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import com.google.vr.cardboard.AndroidPCompat;
import com.google.vr.cardboard.DisplayUtils;
import com.google.vr.cardboard.UsedByNative;
import com.google.vr.cardboard.VrParamsProvider;
import com.google.vr.cardboard.VrParamsProviderFactory;
import com.google.vr.ndk.base.SdkConfigurationReader;
import com.google.vr.sdk.deps.hu;
import com.google.vr.sdk.proto.nano.CardboardDevice;
import com.google.vr.sdk.proto.nano.Display;
import com.google.vr.sdk.proto.nano.Preferences;

@UsedByNative
public class VrParamsProviderJni {
    public VrParamsProviderJni() {
    }

    @UsedByNative
    private static byte[] readDeviceParams(Context context) {
        VrParamsProvider vrParamsProvider = VrParamsProviderFactory.create(context);
        CardboardDevice.DeviceParams deviceParams = vrParamsProvider.readDeviceParams();
        vrParamsProvider.close();
        if (deviceParams == null) {
            return null;
        }
        return hu.toByteArray(deviceParams);
    }

    @UsedByNative
    private static byte[] readSdkConfigurationParams(Context context) {
        return hu.toByteArray(SdkConfigurationReader.getParams(context));
    }

    @UsedByNative
    private static boolean writeDeviceParams(Context context, byte[] byArray) {
        try (VrParamsProvider vrParamsProvider = VrParamsProviderFactory.create(context);){
            CardboardDevice.DeviceParams deviceParams = byArray != null ? hu.mergeFrom(new CardboardDevice.DeviceParams(), byArray) : null;
            boolean bl2 = vrParamsProvider.writeDeviceParams(deviceParams);
            return bl2;
        }
    }

    @UsedByNative
    private static void readDisplayParams(Context context, long l2) {
        if (context == null) {
            Log.w((String)"VrParamsProviderJni", (String)"Missing context for phone params lookup. Results may be invalid.");
            VrParamsProviderJni.updateNativeDisplayParamsPointer(l2, Resources.getSystem().getDisplayMetrics(), DisplayUtils.getBorderSizeMeters(null), 0);
            return;
        }
        VrParamsProvider vrParamsProvider = VrParamsProviderFactory.create(context);
        Display.DisplayParams displayParams = vrParamsProvider.readDisplayParams();
        vrParamsProvider.close();
        Display display = DisplayUtils.getDefaultDisplay(context);
        AndroidPCompat androidPCompat = new AndroidPCompat();
        VrParamsProviderJni.updateNativeDisplayParamsPointer(l2, DisplayUtils.getDisplayMetricsLandscapeWithOverride(display, displayParams), DisplayUtils.getBorderSizeMeters(displayParams), DisplayUtils.getCutoutMarginLandscapePixels(context, display, androidPCompat));
    }

    @UsedByNative
    private static byte[] readUserPrefs(Context context) {
        VrParamsProvider vrParamsProvider = VrParamsProviderFactory.create(context);
        Preferences.UserPrefs userPrefs = vrParamsProvider.readUserPrefs();
        vrParamsProvider.close();
        if (userPrefs == null) {
            return null;
        }
        return hu.toByteArray(userPrefs);
    }

    private static void updateNativeDisplayParamsPointer(long l2, DisplayMetrics displayMetrics, float f2, int n2) {
        VrParamsProviderJni.nativeUpdateNativeDisplayParamsPointer(l2, displayMetrics.widthPixels, displayMetrics.heightPixels, displayMetrics.xdpi, displayMetrics.ydpi, f2, n2);
    }

    private static native void nativeUpdateNativeDisplayParamsPointer(long var0, int var2, int var3, float var4, float var5, float var6, int var7);
}

