/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.cardboard;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.widget.Toast;
import com.google.vr.cardboard.ContextUtils;
import com.google.vr.cardboard.PackageUtils;
import com.google.vr.cardboard.R;
import com.google.vr.cardboard.StoragePermissionUtils;
import com.google.vr.cardboard.VrParamsProviderFactory;
import java.util.ArrayList;
import java.util.List;

public class UiUtils {
    public static StoragePermissionUtils permissionUtils = new StoragePermissionUtils();
    public static AlertDialog.Builder dialogBuilderForTesting;

    public static void launchOrInstallCardboard(Context context) {
        PackageManager packageManager = context.getPackageManager();
        Intent intent = new Intent();
        intent.setAction("com.google.vrtoolkit.cardboard.CONFIGURE");
        List list = packageManager.queryIntentActivities(intent, 0);
        ArrayList<Intent> arrayList = new ArrayList<Intent>();
        Integer n2 = null;
        for (ResolveInfo resolveInfo : list) {
            String string2 = resolveInfo.activityInfo.packageName;
            if (!PackageUtils.isGooglePackage(string2)) continue;
            int n3 = resolveInfo.priority;
            if (PackageUtils.isSystemPackage(context, string2)) {
                ++n3;
            }
            if (n2 == null) {
                n2 = n3;
            } else if (n3 > n2) {
                n2 = n3;
                arrayList.clear();
            } else if (n3 < n2) continue;
            Intent intent2 = new Intent(intent);
            intent2.setClassName(string2, resolveInfo.activityInfo.name);
            arrayList.add(intent2);
        }
        if (!VrParamsProviderFactory.isContentProviderAvailable(context)) {
            permissionUtils.requestStoragePermission(context);
        }
        if (arrayList.isEmpty()) {
            UiUtils.showInstallDialog(context);
            return;
        }
        Intent intent3 = arrayList.size() == 1 ? (Intent)arrayList.get(0) : intent;
        context.startActivity(intent3);
    }

    public static AlertDialog showDaydreamHelpCenterDialog(final Context context, int n2, int n3, final Runnable runnable) {
        DialogInterface.OnClickListener onClickListener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n2) {
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)"https://support.google.com/daydream?p=daydream_help_menu"));
                try {
                    context.startActivity(intent);
                    return;
                }
                catch (ActivityNotFoundException activityNotFoundException) {
                    Toast.makeText((Context)context, (int)R.string.no_browser_text, (int)1).show();
                    dialogInterface.cancel();
                    return;
                }
            }
        };
        AlertDialog.Builder builder = UiUtils.createAlertDialogBuilder(context);
        builder.setTitle(n2).setMessage(n3).setCancelable(false).setPositiveButton(R.string.dialog_button_open_help_center, onClickListener).setNegativeButton(R.string.dialog_button_got_it, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n2) {
                dialogInterface.cancel();
            }
        });
        if (runnable != null) {
            builder.setOnCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialogInterface) {
                    runnable.run();
                }
            });
        }
        AlertDialog alertDialog = builder.create();
        alertDialog.setCanceledOnTouchOutside(false);
        return UiUtils.showImmersiveDialog(context, alertDialog);
    }

    private static void showInstallDialog(final Context context) {
        DialogInterface.OnClickListener onClickListener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n2) {
                try {
                    context.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)"https://google.com/cardboard/cfg")));
                    return;
                }
                catch (ActivityNotFoundException activityNotFoundException) {
                    Toast.makeText((Context)context, (int)R.string.no_browser_text, (int)1).show();
                    return;
                }
            }
        };
        AlertDialog.Builder builder = UiUtils.createAlertDialogBuilder(context);
        builder.setTitle(R.string.dialog_title).setMessage(R.string.dialog_message_no_cardboard).setPositiveButton(R.string.go_to_playstore_button, onClickListener).setNegativeButton(R.string.cancel_button, null);
        UiUtils.showImmersiveDialog(context, builder.create());
    }

    private static AlertDialog showImmersiveDialog(Context context, AlertDialog alertDialog) {
        alertDialog.getWindow().setFlags(8, 8);
        alertDialog.show();
        Activity activity = ContextUtils.getActivity(context);
        if (activity != null) {
            alertDialog.getWindow().getDecorView().setSystemUiVisibility(activity.getWindow().getDecorView().getSystemUiVisibility());
        }
        alertDialog.getWindow().clearFlags(8);
        return alertDialog;
    }

    private static AlertDialog.Builder createAlertDialogBuilder(Context context) {
        if (dialogBuilderForTesting != null) {
            return dialogBuilderForTesting;
        }
        return new AlertDialog.Builder(context, R.style.GvrDialogTheme);
    }
}

