/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.cardboard;

import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.Size;
import android.view.Display;
import com.google.vr.cardboard.DisplayUtils;
import com.google.vr.sdk.proto.nano.Display;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PpiOverrides {
    private static final String TAG = PpiOverrides.class.getSimpleName();
    private static ArrayList<Size> supportedDisplaySizes = null;
    private static final List<PpiOverride> PPI_OVERRIDES = Arrays.asList(new PpiOverride("Micromax", null, "4560MMX", null, 217.0f, 217.0f), new PpiOverride("HTC", "endeavoru", "HTC One X", null, 312.0f, 312.0f), new PpiOverride("samsung", null, "SM-G920P", null, 575.0f, 575.0f), new PpiOverride("samsung", null, "SM-G930", null, 581.0f, 580.0f), new PpiOverride("samsung", null, "SM-G9300", null, 581.0f, 580.0f), new PpiOverride("samsung", null, "SM-G930A", null, 581.0f, 580.0f), new PpiOverride("samsung", null, "SM-G930F", null, 581.0f, 580.0f), new PpiOverride("samsung", null, "SM-G930P", null, 581.0f, 580.0f), new PpiOverride("samsung", null, "SM-G930R4", null, 581.0f, 580.0f), new PpiOverride("samsung", null, "SM-G930T", null, 581.0f, 580.0f), new PpiOverride("samsung", null, "SM-G930V", null, 581.0f, 580.0f), new PpiOverride("samsung", null, "SM-G930W8", null, 581.0f, 580.0f), new PpiOverride("samsung", null, "SM-N915FY", null, 541.0f, 541.0f), new PpiOverride("samsung", null, "SM-N915A", null, 541.0f, 541.0f), new PpiOverride("samsung", null, "SM-N915T", null, 541.0f, 541.0f), new PpiOverride("samsung", null, "SM-N915K", null, 541.0f, 541.0f), new PpiOverride("samsung", null, "SM-N915T", null, 541.0f, 541.0f), new PpiOverride("samsung", null, "SM-N915G", null, 541.0f, 541.0f), new PpiOverride("samsung", null, "SM-N915D", null, 541.0f, 541.0f), new PpiOverride("BLU", "BLU", "Studio 5.0 HD LTE", "qcom", 294.0f, 294.0f), new PpiOverride("OnePlus", "A0001", "A0001", "bacon", 401.0f, 401.0f), new PpiOverride("THL", "THL", "thl 5000", "mt6592", 441.0f, 441.0f), new PpiOverride("Google", "sailfish", "Pixel", "sailfish", Float.valueOf(441.74f), Float.valueOf(441.74f), Float.valueOf(0.004f)), new PpiOverride("Google", "marlin", "Pixel XL", "marlin", Float.valueOf(537.57f), Float.valueOf(537.57f), Float.valueOf(0.004f)), new PpiOverride("Google", "walleye", null, "walleye", Float.valueOf(441.74f), Float.valueOf(441.74f), Float.valueOf(0.004f)), new PpiOverride("Google", "taimen", null, "taimen", null, null, Float.valueOf(0.0046f)), new PpiOverride("Google", "21c8b5470a64adbb25bc84316cbc449361d86839", null, null, Float.valueOf(522.63f), Float.valueOf(522.63f), Float.valueOf(0.0038f)), new PpiOverride("Google", "6e2c7e24b7c7eae9fc94882c9f31befa00594872", null, null, null, null, Float.valueOf(0.0038f)), new PpiOverride("LGE", "joan", null, "joan", null, null, Float.valueOf(0.0038f)), new PpiOverride("LGE", "e44046539bb5b584279553ca6eacca937c8e16cf", null, null, null, null, Float.valueOf(0.0038f)), new PpiOverride("Lenovo", "vega", null, "vega", 537.388f, 537.882f));

    private PpiOverrides() {
    }

    public static boolean getPpiOverride(List<PpiOverride> list, String string2, String string3, String string4, String string5, Display.DisplayParams displayParams) {
        String string6 = PpiOverrides.hashString(string3);
        for (PpiOverride ppiOverride : list) {
            if (!ppiOverride.isMatching(string2, string3, string4, string5) && !ppiOverride.isMatching(string2, string6, string4, string5)) continue;
            Log.d((String)TAG, (String)String.format("Found override: {MANUFACTURER=%s, DEVICE=%s, MODEL=%s, HARDWARE=%s} : x_ppi=%f, y_ppi=%f, bottom_bezel_height=%f)", ppiOverride.manufacturer, ppiOverride.device, ppiOverride.model, ppiOverride.hardware, ppiOverride.xPpi, ppiOverride.yPpi, ppiOverride.bottomBezelHeight));
            if (ppiOverride.xPpi != null) {
                displayParams.setXPpi(ppiOverride.xPpi.floatValue());
            }
            if (ppiOverride.yPpi != null) {
                displayParams.setYPpi(ppiOverride.yPpi.floatValue());
            }
            if (ppiOverride.bottomBezelHeight != null) {
                displayParams.setBottomBezelHeight(ppiOverride.bottomBezelHeight.floatValue());
            }
            return true;
        }
        return false;
    }

    public static Display.DisplayParams getPpiOverride(Context context) {
        Display.DisplayParams displayParams = new Display.DisplayParams();
        if (PpiOverrides.getPpiOverride(PPI_OVERRIDES, Build.MANUFACTURER, Build.DEVICE, Build.MODEL, Build.HARDWARE, displayParams)) {
            if ("samsung".equals(Build.MANUFACTURER) && Build.VERSION.SDK_INT >= 23) {
                Display display = DisplayUtils.getDefaultDisplay(context);
                DisplayMetrics displayMetrics = DisplayUtils.getDisplayMetricsLandscape(display);
                int n2 = displayMetrics.widthPixels;
                ArrayList<Size> arrayList = PpiOverrides.getSupportedDisplaySizes(display);
                if (arrayList != null) {
                    ArrayList<Size> arrayList2 = arrayList;
                    int n3 = arrayList2.size();
                    Object var6_9 = null;
                    for (int i2 = 0; i2 < n3; ++i2) {
                        Size size = arrayList2.get(i2);
                        Size size2 = size;
                        n2 = Math.max(n2, Math.max(size2.getWidth(), size2.getHeight()));
                    }
                    if (displayMetrics.widthPixels != n2) {
                        float f2 = (float)displayMetrics.widthPixels / (float)n2;
                        Log.i((String)TAG, (String)new StringBuilder(61).append("Non-native screen resolution; scaling DPI by: ").append(f2).toString());
                        displayParams.setXPpi(displayParams.getXPpi() * f2);
                        displayParams.setYPpi(displayParams.getYPpi() * f2);
                    }
                }
            }
            return displayParams;
        }
        return null;
    }

    private static ArrayList<Size> getSupportedDisplaySizes(Display display) {
        if (display == null) {
            return null;
        }
        if (supportedDisplaySizes != null) {
            return supportedDisplaySizes;
        }
        supportedDisplaySizes = new ArrayList();
        Display.Mode[] modeArray = display.getSupportedModes();
        if (modeArray != null) {
            Display.Mode[] modeArray2 = modeArray;
            int n2 = modeArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Display.Mode mode = modeArray2[i2];
                supportedDisplaySizes.add(new Size(mode.getPhysicalWidth(), mode.getPhysicalHeight()));
            }
        }
        return supportedDisplaySizes;
    }

    private static String hashString(String string2) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            byte[] byArray = messageDigest.digest(string2.getBytes());
            StringBuilder stringBuilder = new StringBuilder(2 * byArray.length);
            byte[] byArray2 = byArray;
            int n2 = byArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                byte by2 = byArray2[i2];
                stringBuilder.append(String.format("%02x", by2));
            }
            return stringBuilder.toString();
        }
        catch (GeneralSecurityException generalSecurityException) {
            Log.e((String)TAG, (String)"SHA-256 is missing");
            return string2;
        }
    }

    public static class PpiOverride {
        String manufacturer;
        String device;
        String model;
        String hardware;
        Float xPpi;
        Float yPpi;
        Float bottomBezelHeight;

        public PpiOverride(String string2, String string3, String string4, String string5, Float f2, Float f3, Float f4) {
            this.manufacturer = string2;
            this.device = string3;
            this.model = string4;
            this.hardware = string5;
            this.xPpi = f2;
            this.yPpi = f3;
            this.bottomBezelHeight = f4;
        }

        public PpiOverride(String string2, String string3, String string4, String string5, float f2, float f3) {
            this(string2, string3, string4, string5, Float.valueOf(f2), Float.valueOf(f3), null);
        }

        boolean isMatching(String string2, String string3, String string4, String string5) {
            return !(this.manufacturer != null && !this.manufacturer.equals(string2) || this.device != null && !this.device.equals(string3) || this.model != null && !this.model.equals(string4) || this.hardware != null && !this.hardware.equals(string5));
        }
    }
}

