/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.cardboard;

import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Choreographer;
import android.view.Display;
import com.google.vr.cardboard.DisplayUtils;
import com.google.vr.cardboard.FrameMonitor;
import java.util.concurrent.TimeUnit;

public class DisplaySynchronizer
implements Choreographer.FrameCallback {
    public static final long DISPLAY_ROTATION_REFRESH_INTERVAL_NANOS = TimeUnit.SECONDS.toNanos(1L);
    private volatile long nativeDisplaySynchronizer;
    private FrameMonitor frameMonitor;
    private volatile Display display;
    private DisplayMetrics displayMetrics;
    private volatile int displayRotationDegrees = -1;
    private long lastDisplayRotationUpdateTimeNanos = 0L;

    public DisplaySynchronizer(Context context, Display display) {
        this.nativeDisplaySynchronizer = this.nativeCreate(this.getClass().getClassLoader(), context.getApplicationContext());
        if (this.nativeDisplaySynchronizer == 0L) {
            throw new IllegalStateException("Native DisplaySynchronizer creation failed, implementation unavailable.");
        }
        this.setDisplay(display);
        this.frameMonitor = new FrameMonitor(this);
        this.frameMonitor.init();
    }

    public void disableFrameMonitor() {
        if (this.frameMonitor != null) {
            this.frameMonitor.shutdown();
            this.frameMonitor = null;
        }
    }

    public void setDisplay(Display display) {
        float f2;
        this.checkNativeDisplaySynchronizer();
        this.display = display;
        this.invalidateDisplayProperties();
        float f3 = display.getRefreshRate();
        long l2 = f2 >= 30.0f ? (long)((float)TimeUnit.SECONDS.toNanos(1L) / f3) : 0L;
        long l3 = 0L;
        if (Build.VERSION.SDK_INT >= 21) {
            l3 = display.getAppVsyncOffsetNanos();
        }
        this.nativeReset(this.nativeDisplaySynchronizer, l2, l3);
    }

    public Display getDisplay() {
        return this.display;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.nativeDisplaySynchronizer != 0L) {
                Log.w((String)"DisplaySynchronizer", (String)"DisplaySynchronizer.shutdown() should be called to ensure resource cleanup");
                this.nativeDestroy(this.nativeDisplaySynchronizer);
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    public void onPause() {
        if (this.frameMonitor != null) {
            this.frameMonitor.onPause();
        }
    }

    public void onResume() {
        this.invalidateDisplayProperties();
        if (this.frameMonitor != null) {
            this.frameMonitor.onResume();
        }
    }

    public void onConfigurationChanged() {
        this.invalidateDisplayProperties();
    }

    public void shutdown() {
        if (this.nativeDisplaySynchronizer != 0L) {
            this.onPause();
            if (this.frameMonitor != null) {
                this.frameMonitor.shutdown();
            }
            this.nativeDestroy(this.nativeDisplaySynchronizer);
            this.nativeDisplaySynchronizer = 0L;
        }
    }

    public long getNativeDisplaySynchronizer() {
        this.checkNativeDisplaySynchronizer();
        return this.nativeDisplaySynchronizer;
    }

    public void doFrame(long l2) {
        this.checkNativeDisplaySynchronizer();
        if (this.displayRotationDegrees == -1 || l2 - this.lastDisplayRotationUpdateTimeNanos > DISPLAY_ROTATION_REFRESH_INTERVAL_NANOS) {
            switch (this.display.getRotation()) {
                case 0: {
                    this.displayRotationDegrees = 0;
                    break;
                }
                case 1: {
                    this.displayRotationDegrees = 90;
                    break;
                }
                case 2: {
                    this.displayRotationDegrees = 180;
                    break;
                }
                case 3: {
                    this.displayRotationDegrees = 270;
                    break;
                }
                default: {
                    Log.e((String)"DisplaySynchronizer", (String)"Unknown display rotation, defaulting to 0");
                    this.displayRotationDegrees = 0;
                }
            }
            this.lastDisplayRotationUpdateTimeNanos = l2;
        }
        this.nativeUpdate(this.nativeDisplaySynchronizer, l2, this.displayRotationDegrees);
    }

    private void checkNativeDisplaySynchronizer() {
        if (this.nativeDisplaySynchronizer == 0L) {
            throw new IllegalStateException("DisplaySynchronizer has already been shut down.");
        }
    }

    private void invalidateDisplayProperties() {
        this.displayRotationDegrees = -1;
        DisplayMetrics displayMetrics = DisplayUtils.getDisplayMetricsLandscape(this.display);
        if (!displayMetrics.equals(this.displayMetrics)) {
            if (this.displayMetrics != null) {
                this.nativeOnMetricsChanged(this.nativeDisplaySynchronizer);
            }
            this.displayMetrics = displayMetrics;
        }
    }

    protected native long nativeCreate(ClassLoader var1, Context var2);

    protected native void nativeDestroy(long var1);

    protected native void nativeReset(long var1, long var3, long var5);

    protected native void nativeUpdate(long var1, long var3, int var5);

    protected native void nativeOnMetricsChanged(long var1);
}

