/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.cardboard;

import android.net.Uri;
import android.os.Environment;
import android.util.Base64;
import android.util.Log;
import com.google.vr.sdk.deps.ht;
import com.google.vr.sdk.deps.hu;
import com.google.vr.sdk.proto.nano.CardboardDevice;
import com.google.vr.sdk.proto.nano.Display;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ConfigUtils {
    private static final String TAG = ConfigUtils.class.getSimpleName();

    public ConfigUtils() {
    }

    public static CardboardDevice.DeviceParams readDeviceParamsFromExternalStorage() {
        CardboardDevice.DeviceParams deviceParams = ConfigUtils.readFromExternalStorage(CardboardDevice.DeviceParams.class, "current_device_params", 894990891, true);
        return deviceParams;
    }

    public static CardboardDevice.DeviceParams readDeviceParamsFromUri(Uri uri) {
        String string2 = uri.getQueryParameter("p");
        if (string2 == null) {
            Log.w((String)TAG, (String)"No Cardboard parameters in URI.");
            return null;
        }
        try {
            byte[] byArray = Base64.decode((String)string2, (int)11);
            CardboardDevice.DeviceParams deviceParams = hu.mergeFrom(new CardboardDevice.DeviceParams(), byArray);
            return deviceParams;
        }
        catch (Exception exception) {
            String string3 = String.valueOf(exception);
            Log.w((String)TAG, (String)new StringBuilder(46 + String.valueOf(string3).length()).append("Parsing cardboard parameters from URI failed: ").append(string3).toString());
            return null;
        }
    }

    public static Display.DisplayParams readDisplayParamsFromExternalStorage() {
        Display.DisplayParams displayParams = ConfigUtils.readFromExternalStorage(Display.DisplayParams.class, "phone_params", 779508118, false);
        return displayParams;
    }

    public static boolean writeDeviceParamsToExternalStorage(CardboardDevice.DeviceParams deviceParams) {
        boolean bl2 = ConfigUtils.writeToExternalStorage(deviceParams, "current_device_params", 894990891);
        if (!bl2) {
            Log.e((String)TAG, (String)"Could not write Cardboard parameters to external storage.");
        }
        return bl2;
    }

    public static boolean removeDeviceParamsFromExternalStorage() {
        boolean bl2 = false;
        try {
            File file = ConfigUtils.getConfigFile("current_device_params");
            bl2 = file.exists() ? file.delete() : true;
        }
        catch (IllegalStateException illegalStateException) {
            String string2 = String.valueOf(illegalStateException);
            Log.w((String)TAG, (String)new StringBuilder(34 + String.valueOf(string2).length()).append("Error clearing device parameters: ").append(string2).toString());
        }
        if (!bl2) {
            Log.e((String)TAG, (String)"Could not clear Cardboard parameters from external storage.");
        }
        return bl2;
    }

    private static File getConfigFile(String string2) throws IllegalStateException {
        File file = new File(Environment.getExternalStorageDirectory(), "Cardboard");
        if (!file.exists()) {
            file.mkdirs();
        } else if (!file.isDirectory()) {
            String string3 = String.valueOf(file);
            throw new IllegalStateException(new StringBuilder(61 + String.valueOf(string3).length()).append(string3).append(" already exists as a file, but is expected to be a directory.").toString());
        }
        return new File(file, string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T extends hu> T readFromExternalStorage(Class<T> clazz, String string2, int n2, boolean bl2) {
        try {
            T t2;
            InputStream inputStream = null;
            try {
                inputStream = new BufferedInputStream(new FileInputStream(ConfigUtils.getConfigFile(string2)));
                t2 = ConfigUtils.readFromInputStream(clazz, inputStream, n2);
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                inputStream.close();
                return t2;
            }
            catch (IOException iOException) {}
            return t2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (!bl2) return null;
            String string3 = String.valueOf(fileNotFoundException);
            Log.d((String)TAG, (String)new StringBuilder(39 + String.valueOf(string3).length()).append("Parameters file not found for reading: ").append(string3).toString());
            return null;
        }
        catch (IllegalStateException illegalStateException) {
            String string4 = String.valueOf(illegalStateException);
            Log.w((String)TAG, (String)new StringBuilder(26 + String.valueOf(string4).length()).append("Error reading parameters: ").append(string4).toString());
        }
        return null;
    }

    private static <T extends hu> T readFromInputStream(Class<T> clazz, InputStream inputStream, int n2) {
        if (inputStream == null) {
            return null;
        }
        try {
            ByteBuffer byteBuffer = ByteBuffer.allocate(8);
            if (inputStream.read(byteBuffer.array(), 0, byteBuffer.array().length) == -1) {
                Log.e((String)TAG, (String)"Error parsing param record: end of stream.");
                return null;
            }
            int n3 = byteBuffer.getInt();
            int n4 = byteBuffer.getInt();
            if (n3 != n2) {
                Log.e((String)TAG, (String)"Error parsing param record: incorrect sentinel.");
                return null;
            }
            byte[] byArray = new byte[n4];
            if (inputStream.read(byArray, 0, n4) == -1) {
                Log.e((String)TAG, (String)"Error parsing param record: end of stream.");
                return null;
            }
            return (T)hu.mergeFrom((hu)clazz.newInstance(), byArray);
        }
        catch (ht ht2) {
            String string2 = String.valueOf(ht2.toString());
            Log.w((String)TAG, (String)(string2.length() != 0 ? "Error parsing protocol buffer: ".concat(string2) : new String("Error parsing protocol buffer: ")));
        }
        catch (IOException iOException) {
            String string3 = String.valueOf(iOException.toString());
            Log.w((String)TAG, (String)(string3.length() != 0 ? "Error reading parameters: ".concat(string3) : new String("Error reading parameters: ")));
        }
        catch (InstantiationException instantiationException) {
            String string4 = String.valueOf(instantiationException.toString());
            Log.w((String)TAG, (String)(string4.length() != 0 ? "Error creating parameters: ".concat(string4) : new String("Error creating parameters: ")));
        }
        catch (IllegalAccessException illegalAccessException) {
            String string5 = String.valueOf(illegalAccessException.toString());
            Log.w((String)TAG, (String)(string5.length() != 0 ? "Error accessing parameter type: ".concat(string5) : new String("Error accessing parameter type: ")));
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean writeToExternalStorage(hu hu2, String string2, int n2) {
        boolean bl2 = false;
        OutputStream outputStream = null;
        outputStream = new BufferedOutputStream(new FileOutputStream(ConfigUtils.getConfigFile(string2)));
        bl2 = ConfigUtils.writeToOutputStream(hu2, outputStream, n2);
        try {
            outputStream.close();
            return bl2;
        }
        catch (IOException iOException) {}
        return bl2;
        catch (FileNotFoundException fileNotFoundException) {
            String string3 = String.valueOf(fileNotFoundException);
            Log.e((String)TAG, (String)new StringBuilder(39 + String.valueOf(string3).length()).append("Parameters file not found for writing: ").append(string3).toString());
            if (outputStream == null) return bl2;
            try {
                outputStream.close();
                return bl2;
            }
            catch (IOException iOException) {}
            return bl2;
        }
        catch (IllegalStateException illegalStateException) {
            String string4 = String.valueOf(illegalStateException);
            Log.w((String)TAG, (String)new StringBuilder(26 + String.valueOf(string4).length()).append("Error writing parameters: ").append(string4).toString());
            if (outputStream == null) return bl2;
            {
                catch (Throwable throwable) {
                    if (outputStream == null) throw throwable;
                    try {
                        outputStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                outputStream.close();
                return bl2;
            }
            catch (IOException iOException) {}
            return bl2;
        }
    }

    private static boolean writeToOutputStream(hu hu2, OutputStream outputStream, int n2) {
        try {
            byte[] byArray = hu.toByteArray(hu2);
            ByteBuffer byteBuffer = ByteBuffer.allocate(8);
            byteBuffer.putInt(n2);
            byteBuffer.putInt(byArray.length);
            outputStream.write(byteBuffer.array());
            outputStream.write(byArray);
            return true;
        }
        catch (IOException iOException) {
            String string2 = String.valueOf(iOException.toString());
            Log.w((String)TAG, (String)(string2.length() != 0 ? "Error writing parameters: ".concat(string2) : new String("Error writing parameters: ")));
            return false;
        }
    }
}

