/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.cardboard;

import android.os.Build;
import android.util.Log;
import android.view.Display;
import android.view.Window;
import android.view.WindowManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class AndroidPCompat {
    public AndroidPCompat() {
    }

    public static boolean isAtLeastP() {
        return Build.VERSION.SDK_INT >= 28;
    }

    public DisplayCutoutCompat getDisplayCutout(Display display) {
        if (!AndroidPCompat.isAtLeastP()) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName("android.view.DisplayInfo");
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            Object obj = constructor.newInstance(new Object[0]);
            Method method = Display.class.getDeclaredMethod("getDisplayInfo", clazz);
            method.invoke((Object)display, obj);
            Field field = clazz.getDeclaredField("displayCutout");
            field.setAccessible(true);
            Object object = field.get(obj);
            return DisplayCutoutCompat.create(object);
        }
        catch (Exception exception) {
            String string2 = String.valueOf(exception);
            Log.e((String)"AndroidPCompat", (String)new StringBuilder(44 + String.valueOf(string2).length()).append("Failed to fetch DisplayCutout from Display: ").append(string2).toString());
            return null;
        }
    }

    public boolean doesWindowExtendIntoCutoutArea(Window window) {
        if (!AndroidPCompat.isAtLeastP()) {
            return false;
        }
        try {
            WindowManager.LayoutParams layoutParams = window.getAttributes();
            Field field = WindowManager.LayoutParams.class.getField("layoutInDisplayCutoutMode");
            Field field2 = WindowManager.LayoutParams.class.getField("LAYOUT_IN_DISPLAY_CUTOUT_MODE_SHORT_EDGES");
            return field.get(layoutParams) == field2.get(null);
        }
        catch (Exception exception) {
            String string2 = String.valueOf(exception);
            Log.e((String)"AndroidPCompat", (String)new StringBuilder(56 + String.valueOf(string2).length()).append("Failed to determine if window extends into cutout area: ").append(string2).toString());
            return false;
        }
    }

    public static class DisplayCutoutCompat {
        private static final Class<?> DISPLAY_CUTOUT_CLASS = DisplayCutoutCompat.tryGetDisplayCutoutClass();
        private final Object displayCutout;

        static DisplayCutoutCompat create(Object object) {
            if (object == null) {
                return null;
            }
            if (DISPLAY_CUTOUT_CLASS == null) {
                return null;
            }
            return new DisplayCutoutCompat(object);
        }

        private DisplayCutoutCompat(Object object) {
            this.displayCutout = object;
        }

        public int getSafeInsetTop() {
            return this.tryGetInt("getSafeInsetTop");
        }

        public int getSafeInsetBottom() {
            return this.tryGetInt("getSafeInsetBottom");
        }

        public int getSafeInsetLeft() {
            return this.tryGetInt("getSafeInsetLeft");
        }

        public int getSafeInsetRight() {
            return this.tryGetInt("getSafeInsetRight");
        }

        private int tryGetInt(String string2) {
            try {
                Method method = DISPLAY_CUTOUT_CLASS.getDeclaredMethod(string2, new Class[0]);
                return (Integer)method.invoke(this.displayCutout, new Object[0]);
            }
            catch (Exception exception) {
                return 0;
            }
        }

        private static Class<?> tryGetDisplayCutoutClass() {
            if (AndroidPCompat.isAtLeastP()) {
                try {
                    return Class.forName("android.view.DisplayCutout");
                }
                catch (Exception exception) {
                    Log.e((String)"AndroidPCompat", (String)"Failed to obtain DisplayCutout API.");
                }
            }
            return null;
        }
    }
}

