/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.cardboard;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.PowerManager;
import android.provider.Settings;
import android.util.Log;
import android.view.Window;
import com.google.vr.cardboard.IsEmulator;
import com.google.vr.cardboard.R;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class AndroidNCompat {
    private static final String TAG = AndroidNCompat.class.getSimpleName();
    private static int sSdkLevelOverride = 0;

    public static boolean setVrModeEnabled(Activity activity, boolean bl2) {
        return AndroidNCompat.setVrModeEnabled(activity, bl2, 1);
    }

    public static boolean setVrModeEnabled(Activity activity, boolean bl2, int n2) {
        if (!AndroidNCompat.isVrModeSupported((Context)activity)) {
            if (AndroidNCompat.isAtLeastN()) {
                Log.d((String)TAG, (String)"VR mode is not supported on this N device.");
            }
            return false;
        }
        ComponentName componentName = new ComponentName("com.google.vr.vrcore", "com.google.vr.vrcore.common.VrCoreListenerService");
        try {
            activity.setVrModeEnabled(bl2, componentName);
            return true;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string2 = String.valueOf((Object)nameNotFoundException);
            Log.w((String)TAG, (String)new StringBuilder(25 + String.valueOf(string2).length()).append("No VR service component: ").append(string2).toString());
            if ((n2 & 1) != 0 && AndroidNCompat.isVrModeHighPerformanceSupported((Context)activity) && AndroidNCompat.handleVrCoreAbsence((Context)activity, AndroidNCompat.checkForVrCorePresence((Context)activity))) {
                Log.w((String)TAG, (String)"Failed to handle missing VrCore package.");
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            String string3 = String.valueOf(unsupportedOperationException);
            Log.w((String)TAG, (String)new StringBuilder(23 + String.valueOf(string3).length()).append("Failed to set VR mode: ").append(string3).toString());
        }
        return false;
    }

    public static boolean isVrModeSupported(Context context) {
        return AndroidNCompat.isAtLeastN() && context.getPackageManager().hasSystemFeature("android.software.vr.mode");
    }

    public static boolean setSustainedPerformanceMode(Activity activity, boolean bl2) {
        if (!AndroidNCompat.isAtLeastN()) {
            return false;
        }
        PowerManager powerManager = (PowerManager)activity.getSystemService("power");
        if (!powerManager.isSustainedPerformanceModeSupported()) {
            return false;
        }
        Window window = activity.getWindow();
        if (window == null) {
            Log.e((String)TAG, (String)"Activity does not have a window");
            return false;
        }
        window.setSustainedPerformanceMode(bl2);
        return true;
    }

    public static void setVrThread(int n2) {
        Method method;
        if (!AndroidNCompat.isAtLeastN()) {
            return;
        }
        try {
            method = ActivityManager.class.getMethod("setVrThread", Integer.TYPE);
        }
        catch (NoSuchMethodException | RuntimeException exception) {
            if (AndroidNCompat.isAtLeastNMR1()) {
                String string2 = String.valueOf(exception);
                Log.e((String)TAG, (String)new StringBuilder(38 + String.valueOf(string2).length()).append("Failed to acquire setVrThread method: ").append(string2).toString());
                return;
            }
            String string3 = String.valueOf(exception);
            Log.w((String)TAG, (String)new StringBuilder(38 + String.valueOf(string3).length()).append("Failed to acquire setVrThread method: ").append(string3).toString());
            return;
        }
        try {
            method.invoke(null, n2);
            return;
        }
        catch (IllegalAccessException | RuntimeException | InvocationTargetException exception) {
            String string4 = String.valueOf(exception);
            Log.e((String)TAG, (String)new StringBuilder(30 + String.valueOf(string4).length()).append("Failed to invoke setVrThread: ").append(string4).toString());
            return;
        }
    }

    private static boolean isAtLeastN() {
        return sSdkLevelOverride >= 24 || Build.VERSION.SDK_INT >= 24;
    }

    private static boolean isVrModeHighPerformanceSupported(Context context) {
        return AndroidNCompat.isAtLeastN() && context.getPackageManager().hasSystemFeature("android.hardware.vr.high_performance");
    }

    private static boolean isAtLeastNMR1() {
        return sSdkLevelOverride >= 25 || "NMR1".equals(Build.VERSION.CODENAME) || Build.VERSION.SDK_INT >= 25;
    }

    private static int checkForVrCorePresence(Context context) {
        ApplicationInfo applicationInfo2;
        List list = context.getPackageManager().getInstalledApplications(0);
        boolean bl2 = false;
        for (ApplicationInfo applicationInfo2 : list) {
            if (!applicationInfo2.packageName.equals("com.google.vr.vrcore")) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            return -1;
        }
        String string2 = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"enabled_vr_listeners");
        applicationInfo2 = new ComponentName("com.google.vr.vrcore", "com.google.vr.vrcore.common.VrCoreListenerService");
        if (string2 == null || !string2.contains(applicationInfo2.flattenToString())) {
            return -2;
        }
        return 0;
    }

    private static boolean handleVrCoreAbsence(final Context context, int n2) {
        if (IsEmulator.isEmulator()) {
            return true;
        }
        if (n2 == -1) {
            AndroidNCompat.showWarningDialog(context, R.string.dialog_vr_core_not_installed, R.string.go_to_playstore_button, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int n2) {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setData(Uri.parse((String)"market://details?id=com.google.vr.vrcore"));
                    intent.setPackage("com.android.vending");
                    try {
                        context.startActivity(intent);
                        return;
                    }
                    catch (ActivityNotFoundException activityNotFoundException) {
                        Log.e((String)TAG, (String)"Google Play Services is not installed, unable to download VrCore.");
                        return;
                    }
                }
            });
            return false;
        }
        if (n2 == -2) {
            AndroidNCompat.showWarningDialog(context, R.string.dialog_vr_core_not_enabled, R.string.go_to_vr_listeners_settings_button, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int n2) {
                    context.startActivity(new Intent("android.settings.VR_LISTENER_SETTINGS"));
                }
            });
            return false;
        }
        return true;
    }

    private static void showWarningDialog(Context context, int n2, int n3, DialogInterface.OnClickListener onClickListener) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context, R.style.GvrDialogTheme);
        builder.setMessage(n2).setTitle(R.string.dialog_title_warning).setPositiveButton(n3, onClickListener).setNegativeButton(R.string.cancel_button, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n2) {
            }
        });
        builder.create().show();
    }

    private AndroidNCompat() {
    }
}

