/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.base;

import android.net.Uri;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import android.util.Base64;
import android.util.Log;
import com.google.protobuf.nano.MessageNano;
import com.google.vr.cardboard.ConfigUtils;
import com.google.vr.sdk.base.Distortion;
import com.google.vr.sdk.base.FieldOfView;
import com.google.vr.sdk.base.ScreenParams;
import com.google.vr.sdk.proto.nano.CardboardDevice;

public class GvrViewerParams {
    private static final String TAG = "GvrViewerParams";
    private static final String HTTP_SCHEME = "http";
    private static final String URI_HOST_GOOGLE_SHORT = "g.co";
    private static final String URI_HOST_GOOGLE = "google.com";
    private static final String URI_PATH_CARDBOARD_HOME = "cardboard";
    private static final String URI_PATH_CARDBOARD_CONFIG = "cardboard/cfg";
    private static final String URI_SCHEME_LEGACY_CARDBOARD = "cardboard";
    private static final String URI_HOST_LEGACY_CARDBOARD = "v1.0.0";
    private static final Uri URI_ORIGINAL_CARDBOARD_NFC = new Uri.Builder().scheme("cardboard").authority("v1.0.0").build();
    private static final Uri URI_ORIGINAL_CARDBOARD_QR_CODE = new Uri.Builder().scheme("http").authority("g.co").appendEncodedPath("cardboard").build();
    private static final String DEFAULT_VENDOR = "Google, Inc.";
    private static final String DEFAULT_MODEL = "Default Cardboard";
    private static final String CARDBOARD_V2_2_VENDOR = "Google";
    private static final String CARDBOARD_V2_2_MODEL = "Cardboard";
    private static final float CARDBOARD_V2_2_INTER_LENS_DISTANCE = 0.064f;
    private static final VerticalAlignmentType CARDBOARD_V2_2_VERTICAL_ALIGNMENT = VerticalAlignmentType.BOTTOM;
    private static final float CARDBOARD_V2_2_VERTICAL_DISTANCE_TO_LENS_CENTER = 0.035f;
    private static final float CARDBOARD_V2_2_SCREEN_TO_LENS_DISTANCE = 0.039f;
    private static final String CARDBOARD_V1_VENDOR = "Google, Inc.";
    private static final String CARDBOARD_V1_MODEL = "Cardboard v1";
    private static final float CARDBOARD_V1_INTER_LENS_DISTANCE = 0.06f;
    private static final VerticalAlignmentType CARDBOARD_V1_VERTICAL_ALIGNMENT = VerticalAlignmentType.BOTTOM;
    private static final float CARDBOARD_V1_VERTICAL_DISTANCE_TO_LENS_CENTER = 0.035f;
    private static final float CARDBOARD_V1_SCREEN_TO_LENS_DISTANCE = 0.042f;
    private static final GvrViewerParams DEFAULT_PARAMS = new GvrViewerParams();
    private String vendor;
    private String model;
    private float interLensDistance;
    private VerticalAlignmentType verticalAlignment;
    private float verticalDistanceToLensCenter;
    private float screenToLensDistance;
    private FieldOfView leftEyeMaxFov;
    private boolean hasMagnet;
    private Distortion distortion;
    private CardboardDevice.DeviceParams originalDeviceProto;

    public GvrViewerParams() {
        this.setDefaultValues();
    }

    public GvrViewerParams(GvrViewerParams params) {
        this.copyFrom(params);
    }

    public GvrViewerParams(CardboardDevice.DeviceParams params) {
        this.setDefaultValues();
        if (params == null) {
            return;
        }
        this.originalDeviceProto = params.clone();
        this.vendor = params.getVendor();
        this.model = params.getModel();
        this.interLensDistance = params.getInterLensDistance();
        this.verticalAlignment = VerticalAlignmentType.fromProtoValue(params.getVerticalAlignment());
        this.verticalDistanceToLensCenter = params.getTrayToLensDistance();
        this.screenToLensDistance = params.getScreenToLensDistance();
        this.leftEyeMaxFov = FieldOfView.parseFromProtobuf(params.leftEyeFieldOfViewAngles);
        if (this.leftEyeMaxFov == null) {
            this.leftEyeMaxFov = new FieldOfView();
        }
        this.distortion = Distortion.parseFromProtobuf(params.distortionCoefficients);
        if (this.distortion == null) {
            this.distortion = new Distortion();
        }
        this.hasMagnet = params.getHasMagnet();
    }

    public static boolean isOriginalCardboardDeviceUri(Uri uri) {
        return URI_ORIGINAL_CARDBOARD_QR_CODE.equals((Object)uri) || URI_ORIGINAL_CARDBOARD_NFC.getScheme().equals(uri.getScheme()) && URI_ORIGINAL_CARDBOARD_NFC.getAuthority().equals(uri.getAuthority());
    }

    private static boolean isCardboardDeviceUri(Uri uri) {
        return HTTP_SCHEME.equals(uri.getScheme()) && URI_HOST_GOOGLE.equals(uri.getAuthority()) && "/cardboard/cfg".equals(uri.getPath());
    }

    public static boolean isGvrUri(Uri uri) {
        return GvrViewerParams.isOriginalCardboardDeviceUri(uri) || GvrViewerParams.isCardboardDeviceUri(uri);
    }

    public static GvrViewerParams createFromUri(Uri uri) {
        if (uri == null) {
            return null;
        }
        if (GvrViewerParams.isOriginalCardboardDeviceUri(uri)) {
            return GvrViewerParams.cardboardV1ViewerParams();
        }
        if (!GvrViewerParams.isCardboardDeviceUri(uri)) {
            Log.w((String)TAG, (String)String.format("URI \"%s\" not recognized as GVR viewer.", uri));
            return null;
        }
        return new GvrViewerParams(ConfigUtils.readDeviceParamsFromUri((Uri)uri));
    }

    public static GvrViewerParams cardboardV1ViewerParams() {
        GvrViewerParams deviceParams = new GvrViewerParams();
        deviceParams.vendor = "Google, Inc.";
        deviceParams.model = CARDBOARD_V1_MODEL;
        deviceParams.interLensDistance = 0.06f;
        deviceParams.verticalAlignment = CARDBOARD_V1_VERTICAL_ALIGNMENT;
        deviceParams.verticalDistanceToLensCenter = 0.035f;
        deviceParams.screenToLensDistance = 0.042f;
        deviceParams.leftEyeMaxFov = FieldOfView.cardboardV1FieldOfView();
        deviceParams.hasMagnet = true;
        deviceParams.distortion = Distortion.cardboardV1Distortion();
        return deviceParams;
    }

    public static GvrViewerParams cardboardV2ViewerParams() {
        GvrViewerParams deviceParams = new GvrViewerParams();
        deviceParams.setToCardboardV2ViewerParams();
        return deviceParams;
    }

    public static GvrViewerParams createFromNfcContents(NdefMessage tagContents) {
        if (tagContents == null) {
            Log.w((String)TAG, (String)"Could not get contents from NFC tag.");
            return null;
        }
        for (NdefRecord record : tagContents.getRecords()) {
            GvrViewerParams params = GvrViewerParams.createFromUri(record.toUri());
            if (params == null) continue;
            return params;
        }
        return null;
    }

    byte[] toByteArray() {
        return MessageNano.toByteArray((MessageNano)this.toProtobuf());
    }

    public CardboardDevice.DeviceParams toProtobuf() {
        CardboardDevice.DeviceParams params = this.originalDeviceProto != null ? this.originalDeviceProto.clone() : new CardboardDevice.DeviceParams();
        params.setVendor(this.vendor);
        params.setModel(this.model);
        params.setInterLensDistance(this.interLensDistance);
        params.setVerticalAlignment(this.verticalAlignment.toProtoValue());
        if (this.verticalAlignment == VerticalAlignmentType.CENTER) {
            params.setTrayToLensDistance(0.035f);
        } else {
            params.setTrayToLensDistance(this.verticalDistanceToLensCenter);
        }
        params.setScreenToLensDistance(this.screenToLensDistance);
        params.leftEyeFieldOfViewAngles = this.leftEyeMaxFov.toProtobuf();
        params.distortionCoefficients = this.distortion.toProtobuf();
        if (this.hasMagnet) {
            params.setHasMagnet(this.hasMagnet);
        }
        return params;
    }

    public Uri toUri() {
        byte[] paramsData = this.toByteArray();
        int paramsSize = paramsData.length;
        return new Uri.Builder().scheme(HTTP_SCHEME).authority(URI_HOST_GOOGLE).appendEncodedPath(URI_PATH_CARDBOARD_CONFIG).appendQueryParameter("p", Base64.encodeToString((byte[])paramsData, (int)0, (int)paramsSize, (int)11)).build();
    }

    public void setVendor(String vendor) {
        this.vendor = vendor != null ? vendor : "";
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setModel(String model) {
        this.model = model != null ? model : "";
    }

    public String getModel() {
        return this.model;
    }

    public void setInterLensDistance(float interLensDistance) {
        this.interLensDistance = interLensDistance;
    }

    public float getInterLensDistance() {
        return this.interLensDistance;
    }

    public VerticalAlignmentType getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignmentType verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public void setVerticalDistanceToLensCenter(float verticalDistanceToLensCenter) {
        this.verticalDistanceToLensCenter = verticalDistanceToLensCenter;
    }

    public float getVerticalDistanceToLensCenter() {
        return this.verticalDistanceToLensCenter;
    }

    float getYEyeOffsetMeters(ScreenParams screen) {
        switch (this.getVerticalAlignment()) {
            default: {
                return screen.getHeightMeters() / 2.0f;
            }
            case BOTTOM: {
                return this.getVerticalDistanceToLensCenter() - screen.getBorderSizeMeters();
            }
            case TOP: 
        }
        return screen.getHeightMeters() - (this.getVerticalDistanceToLensCenter() - screen.getBorderSizeMeters());
    }

    public void setScreenToLensDistance(float screenToLensDistance) {
        this.screenToLensDistance = screenToLensDistance;
    }

    public float getScreenToLensDistance() {
        return this.screenToLensDistance;
    }

    public Distortion getDistortion() {
        return this.distortion;
    }

    public FieldOfView getLeftEyeMaxFov() {
        return this.leftEyeMaxFov;
    }

    public boolean getHasMagnet() {
        return this.hasMagnet;
    }

    public void setHasMagnet(boolean magnet) {
        this.hasMagnet = magnet;
    }

    public boolean equals(Object other) {
        boolean fieldsHandledByThisClassAreEqual;
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof GvrViewerParams)) {
            return false;
        }
        GvrViewerParams o = (GvrViewerParams)other;
        boolean bl = fieldsHandledByThisClassAreEqual = this.vendor.equals(o.vendor) && this.model.equals(o.model) && this.interLensDistance == o.interLensDistance && this.verticalAlignment == o.verticalAlignment && (this.verticalAlignment == VerticalAlignmentType.CENTER || this.verticalDistanceToLensCenter == o.verticalDistanceToLensCenter) && this.screenToLensDistance == o.screenToLensDistance && this.leftEyeMaxFov.equals(o.leftEyeMaxFov) && this.distortion.equals(o.distortion) && this.hasMagnet == o.hasMagnet;
        if (!fieldsHandledByThisClassAreEqual) {
            return false;
        }
        return MessageNano.messageNanoEquals((MessageNano)this.originalDeviceProto, (MessageNano)o.originalDeviceProto);
    }

    public String toString() {
        String string = this.vendor;
        StringBuilder stringBuilder = new StringBuilder().append("{\n").append(new StringBuilder(12 + String.valueOf(string).length()).append("  vendor: ").append(string).append(",\n").toString());
        string = this.model;
        float f = this.interLensDistance;
        String string2 = String.valueOf((Object)this.verticalAlignment);
        float f2 = this.verticalDistanceToLensCenter;
        StringBuilder stringBuilder2 = stringBuilder.append(new StringBuilder(11 + String.valueOf(string).length()).append("  model: ").append(string).append(",\n").toString()).append(new StringBuilder(40).append("  inter_lens_distance: ").append(f).append(",\n").toString()).append(new StringBuilder(24 + String.valueOf(string2).length()).append("  vertical_alignment: ").append(string2).append(",\n").toString()).append(new StringBuilder(53).append("  vertical_distance_to_lens_center: ").append(f2).append(",\n").toString());
        f2 = this.screenToLensDistance;
        String string3 = this.leftEyeMaxFov.toString().replace("\n", "\n  ");
        StringBuilder stringBuilder3 = stringBuilder2.append(new StringBuilder(44).append("  screen_to_lens_distance: ").append(f2).append(",\n").toString()).append(new StringBuilder(22 + String.valueOf(string3).length()).append("  left_eye_max_fov: ").append(string3).append(",\n").toString());
        string3 = this.distortion.toString().replace("\n", "\n  ");
        boolean bl = this.hasMagnet;
        return stringBuilder3.append(new StringBuilder(16 + String.valueOf(string3).length()).append("  distortion: ").append(string3).append(",\n").toString()).append(new StringBuilder(17).append("  magnet: ").append(bl).append(",\n").toString()).append("}\n").toString();
    }

    public boolean isDefault() {
        return DEFAULT_PARAMS.equals(this);
    }

    private void setDefaultValues() {
        this.setToCardboardV2ViewerParams();
        this.vendor = "Google, Inc.";
        this.model = DEFAULT_MODEL;
    }

    private void setToCardboardV2ViewerParams() {
        this.vendor = CARDBOARD_V2_2_VENDOR;
        this.model = CARDBOARD_V2_2_MODEL;
        this.interLensDistance = 0.064f;
        this.verticalAlignment = CARDBOARD_V2_2_VERTICAL_ALIGNMENT;
        this.verticalDistanceToLensCenter = 0.035f;
        this.screenToLensDistance = 0.039f;
        this.leftEyeMaxFov = new FieldOfView();
        this.hasMagnet = false;
        this.distortion = new Distortion();
    }

    private void copyFrom(GvrViewerParams params) {
        this.vendor = params.vendor;
        this.model = params.model;
        this.interLensDistance = params.interLensDistance;
        this.verticalAlignment = params.verticalAlignment;
        this.verticalDistanceToLensCenter = params.verticalDistanceToLensCenter;
        this.screenToLensDistance = params.screenToLensDistance;
        this.leftEyeMaxFov = new FieldOfView(params.leftEyeMaxFov);
        this.hasMagnet = params.hasMagnet;
        this.distortion = new Distortion(params.distortion);
        this.originalDeviceProto = params.originalDeviceProto;
    }

    public static enum VerticalAlignmentType {
        BOTTOM(0),
        CENTER(1),
        TOP(2);

        private final int protoValue;

        private VerticalAlignmentType(int protoValue) {
            this.protoValue = protoValue;
        }

        int toProtoValue() {
            return this.protoValue;
        }

        static VerticalAlignmentType fromProtoValue(int protoValue) {
            for (VerticalAlignmentType type : VerticalAlignmentType.values()) {
                if (type.protoValue != protoValue) continue;
                return type;
            }
            Log.e((String)GvrViewerParams.TAG, (String)String.format("Unknown alignment type from proto: %d", protoValue));
            return BOTTOM;
        }
    }
}

