/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.base;

import java.util.Arrays;

public class Distortion {
    private static final float[] CARDBOARD_V2_2_COEFFICIENTS = new float[]{0.34f, 0.55f};
    private static final float[] CARDBOARD_V1_COEFFICIENTS = new float[]{0.441f, 0.156f};
    private float[] coefficients;

    public static Distortion cardboardV1Distortion() {
        Distortion params = new Distortion();
        params.coefficients = (float[])CARDBOARD_V1_COEFFICIENTS.clone();
        return params;
    }

    public Distortion() {
        this.coefficients = (float[])CARDBOARD_V2_2_COEFFICIENTS.clone();
    }

    public Distortion(Distortion other) {
        this.setCoefficients(other.coefficients);
    }

    public static Distortion parseFromProtobuf(float[] coefficients) {
        Distortion distortion = new Distortion();
        distortion.setCoefficients(coefficients);
        return distortion;
    }

    public float[] toProtobuf() {
        return (float[])this.coefficients.clone();
    }

    public void setCoefficients(float[] coefficients) {
        this.coefficients = coefficients != null ? (float[])coefficients.clone() : new float[]{};
    }

    public float[] getCoefficients() {
        return this.coefficients;
    }

    public float distortionFactor(float radius) {
        float result = 1.0f;
        float rFactor = 1.0f;
        float rSquared = radius * radius;
        for (float ki : this.coefficients) {
            result += ki * (rFactor *= rSquared);
        }
        return result;
    }

    public float distort(float radius) {
        return radius * this.distortionFactor(radius);
    }

    public float distortInverse(float radius) {
        float r0 = radius / 0.9f;
        float r1 = radius * 0.9f;
        float dr0 = radius - this.distort(r0);
        while ((double)Math.abs(r1 - r0) > 1.0E-4) {
            float dr1 = radius - this.distort(r1);
            float r2 = r1 - dr1 * ((r1 - r0) / (dr1 - dr0));
            r0 = r1;
            r1 = r2;
            dr0 = dr1;
        }
        return r1;
    }

    private static double[] solveLinear(double[][] a, double[] y) {
        int i;
        int n = a[0].length;
        for (int j = 0; j < n - 1; ++j) {
            int k = j + 1;
            while (k < n) {
                double p = a[k][j] / a[j][j];
                for (i = j + 1; i < n; ++i) {
                    double[] dArray = a[k];
                    int n2 = i;
                    dArray[n2] = dArray[n2] - p * a[j][i];
                }
                int n3 = k++;
                y[n3] = y[n3] - p * y[j];
            }
        }
        double[] x = new double[n];
        for (int j = n - 1; j >= 0; --j) {
            double v = y[j];
            for (i = j + 1; i < n; ++i) {
                v -= a[j][i] * x[i];
            }
            x[j] = v / a[j][j];
        }
        return x;
    }

    private static double[] solveLeastSquares(double[][] matA, double[] vecY) {
        int i;
        double sum;
        int j;
        int numSamples = matA.length;
        int numCoefficients = matA[0].length;
        double[][] matATA = new double[numCoefficients][numCoefficients];
        for (int k = 0; k < numCoefficients; ++k) {
            for (j = 0; j < numCoefficients; ++j) {
                sum = 0.0;
                for (i = 0; i < numSamples; ++i) {
                    sum += matA[i][j] * matA[i][k];
                }
                matATA[j][k] = sum;
            }
        }
        double[] vecATY = new double[numCoefficients];
        for (j = 0; j < numCoefficients; ++j) {
            sum = 0.0;
            for (i = 0; i < numSamples; ++i) {
                sum += matA[i][j] * vecY[i];
            }
            vecATY[j] = sum;
        }
        return Distortion.solveLinear(matATA, vecATY);
    }

    public Distortion getApproximateInverseDistortion(float maxRadius, int numCoefficients) {
        int numSamples = 100;
        double[][] matA = new double[100][numCoefficients];
        double[] vecY = new double[100];
        for (int i = 0; i < 100; ++i) {
            double rp;
            float r = maxRadius * (float)(i + 1) / 100.0f;
            double v = rp = (double)this.distort(r);
            for (int j = 0; j < numCoefficients; ++j) {
                matA[i][j] = v *= rp * rp;
            }
            vecY[i] = (double)r - rp;
        }
        double[] vecK = Distortion.solveLeastSquares(matA, vecY);
        float[] coefficients = new float[vecK.length];
        for (int i = 0; i < vecK.length; ++i) {
            coefficients[i] = (float)vecK[i];
        }
        Distortion inverse = new Distortion();
        inverse.setCoefficients(coefficients);
        return inverse;
    }

    @Deprecated
    public Distortion getApproximateInverseDistortion(float maxRadius) {
        return this.getApproximateInverseDistortion(maxRadius, 2);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof Distortion)) {
            return false;
        }
        Distortion o = (Distortion)other;
        return Arrays.equals(this.coefficients, o.coefficients);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append("{\n").append("  coefficients: [");
        for (int i = 0; i < this.coefficients.length; ++i) {
            builder.append(Float.toString(this.coefficients[i]));
            if (i >= this.coefficients.length - 1) continue;
            builder.append(", ");
        }
        builder.append("],\n}");
        return builder.toString();
    }
}

