/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.audio;

import android.util.Log;
import java.nio.ByteBuffer;

public class GvrAudioSurround {
    private static UnsatisfiedLinkError nativeLibraryLoadException;
    private long vrAudioSystemRef = 0L;
    private final int numFramesPerOutputBuffer;
    private final int numInputChannels;
    private static final String TAG = "GvrAudioSurround";
    private static final int NUM_STEREO_CHANNELS = 2;
    private static final int NUM_BYTES_PER_SAMPLE = 2;

    public GvrAudioSurround(int surroundFormat, int sampleRateHz, int numInputChannels, int numFramesPerOutputBuffer) {
        if (nativeLibraryLoadException != null) {
            throw nativeLibraryLoadException;
        }
        this.vrAudioSystemRef = this.nativeInitialize(surroundFormat, sampleRateHz, numInputChannels, numFramesPerOutputBuffer);
        this.numFramesPerOutputBuffer = numFramesPerOutputBuffer;
        this.numInputChannels = numInputChannels;
    }

    private native long nativeInitialize(int var1, int var2, int var3, int var4);

    protected void finalize() throws Throwable {
        try {
            if (this.vrAudioSystemRef != 0L) {
                Log.w((String)TAG, (String)"GvrAudioSurround not correctly released");
                this.release();
            }
        }
        finally {
            super.finalize();
        }
    }

    public void release() {
        this.nativeRelease(this.vrAudioSystemRef);
        this.vrAudioSystemRef = 0L;
    }

    private native void nativeRelease(long var1);

    public int getAvailableInputSize() {
        return this.nativeGetAvailableInputSize(this.vrAudioSystemRef);
    }

    private native int nativeGetAvailableInputSize(long var1);

    public int addInput(ByteBuffer inputBuffer, int offset, int size) {
        return this.nativeAddInput(this.vrAudioSystemRef, inputBuffer, offset, size);
    }

    private native int nativeAddInput(long var1, ByteBuffer var3, int var4, int var5);

    public int getAvailableOutputSize() {
        return this.nativeGetAvailableOutputSize(this.vrAudioSystemRef);
    }

    private native int nativeGetAvailableOutputSize(long var1);

    public int getOutput(ByteBuffer outputBuffer, int offset, int size) {
        return this.nativeGetOutput(this.vrAudioSystemRef, outputBuffer, offset, size);
    }

    private native int nativeGetOutput(long var1, ByteBuffer var3, int var4, int var5);

    public boolean triggerProcessing() {
        return this.nativeTriggerProcessing(this.vrAudioSystemRef);
    }

    private native boolean nativeTriggerProcessing(long var1);

    public void flush() {
        this.nativeFlush(this.vrAudioSystemRef);
    }

    private native void nativeFlush(long var1);

    public void updateNativeOrientation(float w, float x, float y, float z) {
        this.nativeSetOrientationQuaternion(this.vrAudioSystemRef, w, x, y, z);
    }

    private native void nativeSetOrientationQuaternion(long var1, float var3, float var4, float var5, float var6);

    static {
        try {
            nativeLibraryLoadException = null;
            System.loadLibrary("gvr_audio");
        }
        catch (UnsatisfiedLinkError exception) {
            nativeLibraryLoadException = exception;
        }
    }

    public static abstract class SurroundFormat {
        public static final int INVALID = 0;
        public static final int SURROUND_MONO = 1;
        public static final int SURROUND_STEREO = 2;
        public static final int SURROUND_FIVE_DOT_ONE = 3;
        public static final int FIRST_ORDER_AMBISONICS = 4;
        public static final int SECOND_ORDER_AMBISONICS = 5;
        public static final int THIRD_ORDER_AMBISONICS = 6;
        public static final int FIRST_ORDER_AMBISONICS_WITH_NON_DIEGETIC_STEREO = 7;
        public static final int SECOND_ORDER_AMBISONICS_WITH_NON_DIEGETIC_STEREO = 8;
        public static final int THIRD_ORDER_AMBISONICS_WITH_NON_DIEGETIC_STEREO = 9;
    }
}

