/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.audio;

import android.content.Context;

public class GvrAudioEngine {
    public static final int INVALID_ID = -1;
    private final long vrAudioSystemRef;

    public GvrAudioEngine(Context context, int renderingMode) {
        this.vrAudioSystemRef = this.nativeInitialize(this.getClass().getClassLoader(), context.getApplicationContext(), renderingMode);
    }

    private native long nativeInitialize(ClassLoader var1, Context var2, int var3);

    protected void finalize() throws Throwable {
        try {
            this.nativeRelease(this.vrAudioSystemRef);
        }
        finally {
            super.finalize();
        }
    }

    private native void nativeRelease(long var1);

    public void update() {
        this.nativeUpdate(this.vrAudioSystemRef);
    }

    private native void nativeUpdate(long var1);

    public void pause() {
        this.nativePause(this.vrAudioSystemRef);
    }

    private native void nativePause(long var1);

    public void resume() {
        this.nativeResume(this.vrAudioSystemRef);
    }

    private native void nativeResume(long var1);

    public boolean preloadSoundFile(String filename) {
        return this.nativePreloadSoundFile(this.vrAudioSystemRef, filename);
    }

    private native boolean nativePreloadSoundFile(long var1, String var3);

    public void unloadSoundFile(String filename) {
        this.nativeUnloadSoundFile(this.vrAudioSystemRef, filename);
    }

    private native void nativeUnloadSoundFile(long var1, String var3);

    public int createSoundObject(String filename) {
        return this.nativeCreateSoundObject(this.vrAudioSystemRef, filename);
    }

    private native int nativeCreateSoundObject(long var1, String var3);

    public int createSoundfield(String filename) {
        return this.nativeCreateSoundfield(this.vrAudioSystemRef, filename);
    }

    private native int nativeCreateSoundfield(long var1, String var3);

    public int createStereoSound(String filename) {
        return this.nativeCreateStereoSound(this.vrAudioSystemRef, filename);
    }

    private native int nativeCreateStereoSound(long var1, String var3);

    public void playSound(int sourceId, boolean loopingEnabled) {
        this.nativePlaySound(this.vrAudioSystemRef, sourceId, loopingEnabled);
    }

    private native void nativePlaySound(long var1, int var3, boolean var4);

    public void pauseSound(int sourceId) {
        this.nativePauseSound(this.vrAudioSystemRef, sourceId);
    }

    private native void nativePauseSound(long var1, int var3);

    public void resumeSound(int sourceId) {
        this.nativeResumeSound(this.vrAudioSystemRef, sourceId);
    }

    private native void nativeResumeSound(long var1, int var3);

    public void stopSound(int sourceId) {
        this.nativeStopSound(this.vrAudioSystemRef, sourceId);
    }

    private native void nativeStopSound(long var1, int var3);

    public void setSoundObjectPosition(int soundObjectId, float x, float y, float z) {
        this.nativeSetSoundObjectPosition(this.vrAudioSystemRef, soundObjectId, x, y, z);
    }

    private native void nativeSetSoundObjectPosition(long var1, int var3, float var4, float var5, float var6);

    public void setSoundObjectDistanceRolloffModel(int soundObjectId, int rolloffModel, float minDistance, float maxDistance) {
        this.nativeSetSoundObjectDistanceRolloffModel(this.vrAudioSystemRef, soundObjectId, rolloffModel, minDistance, maxDistance);
    }

    private native void nativeSetSoundObjectDistanceRolloffModel(long var1, int var3, int var4, float var5, float var6);

    public void setSoundfieldRotation(int soundfieldId, float x, float y, float z, float w) {
        this.nativeSetSoundfieldRotation(this.vrAudioSystemRef, soundfieldId, x, y, z, w);
    }

    private native void nativeSetSoundfieldRotation(long var1, int var3, float var4, float var5, float var6, float var7);

    public void setSoundVolume(int sourceId, float volume) {
        this.nativeSetSoundVolume(this.vrAudioSystemRef, sourceId, volume);
    }

    private native void nativeSetSoundVolume(long var1, int var3, float var4);

    public boolean isSoundPlaying(int sourceId) {
        return this.nativeIsSoundPlaying(this.vrAudioSystemRef, sourceId);
    }

    private native boolean nativeIsSoundPlaying(long var1, int var3);

    public void setHeadPosition(float x, float y, float z) {
        this.nativeSetHeadPosition(this.vrAudioSystemRef, x, y, z);
    }

    private native void nativeSetHeadPosition(long var1, float var3, float var4, float var5);

    public void setHeadRotation(float x, float y, float z, float w) {
        this.nativeSetHeadRotation(this.vrAudioSystemRef, x, y, z, w);
    }

    private native void nativeSetHeadRotation(long var1, float var3, float var4, float var5, float var6);

    public void enableRoom(boolean enable) {
        this.nativeEnableRoom(this.vrAudioSystemRef, enable);
    }

    private native void nativeEnableRoom(long var1, boolean var3);

    public void setRoomProperties(float sizeX, float sizeY, float sizeZ, int wallMaterial, int ceilingMaterial, int floorMaterial) {
        this.nativeSetRoomProperties(this.vrAudioSystemRef, sizeX, sizeY, sizeZ, wallMaterial, ceilingMaterial, floorMaterial);
    }

    private native void nativeSetRoomProperties(long var1, float var3, float var4, float var5, int var6, int var7, int var8);

    public void setRoomReverbAdjustments(float gain, float timeAdjust, float brightnessAdjust) {
        this.nativeSetRoomReverbAdjustments(this.vrAudioSystemRef, gain, timeAdjust, brightnessAdjust);
    }

    private native void nativeSetRoomReverbAdjustments(long var1, float var3, float var4, float var5);

    public void enableSpeakerStereoMode(boolean enable) {
        this.nativeEnableStereoSpeakerMode(this.vrAudioSystemRef, enable);
    }

    private native void nativeEnableStereoSpeakerMode(long var1, boolean var3);

    static {
        System.loadLibrary("vraudio_engine");
    }

    public static abstract class DistanceRolloffModel {
        public static final int LOGARITHMIC = 0;
        public static final int LINEAR = 1;
        public static final int NONE = 2;
    }

    public static abstract class MaterialName {
        public static final int TRANSPARENT = 0;
        public static final int ACOUSTIC_CEILING_TILES = 1;
        public static final int BRICK_BARE = 2;
        public static final int BRICK_PAINTED = 3;
        public static final int CONCRETE_BLOCK_COARSE = 4;
        public static final int CONCRETE_BLOCK_PAINTED = 5;
        public static final int CURTAIN_HEAVY = 6;
        public static final int FIBER_GLASS_INSULATION = 7;
        public static final int GLASS_THIN = 8;
        public static final int GLASS_THICK = 9;
        public static final int GRASS = 10;
        public static final int LINOLEUM_ON_CONCRETE = 11;
        public static final int MARBLE = 12;
        public static final int METAL = 13;
        public static final int PARQUET_ON_CONCRETE = 14;
        public static final int PLASTER_ROUGH = 15;
        public static final int PLASTER_SMOOTH = 16;
        public static final int PLYWOOD_PANEL = 17;
        public static final int POLISHED_CONCRETE_OR_TILE = 18;
        public static final int SHEET_ROCK = 19;
        public static final int WATER_OR_ICE_SURFACE = 20;
        public static final int WOOD_CEILING = 21;
        public static final int WOOD_PANEL = 22;
    }

    public static abstract class RenderingMode {
        public static final int STEREO_PANNING = 0;
        public static final int BINAURAL_LOW_QUALITY = 1;
        public static final int BINAURAL_HIGH_QUALITY = 2;
    }
}

