/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Ordered;
import com.google.common.truth.Subject;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class IntStreamSubject
extends Subject {
    private final List<?> actualList;

    private IntStreamSubject(FailureMetadata failureMetadata, @Nullable IntStream stream) {
        super(failureMetadata, (Object)stream);
        this.actualList = stream == null ? null : (List)stream.boxed().collect(Collectors.toCollection(ArrayList::new));
    }

    protected String actualCustomStringRepresentation() {
        return String.valueOf(this.actualList);
    }

    public static Subject.Factory<IntStreamSubject, IntStream> intStreams() {
        return IntStreamSubject::new;
    }

    public void isEmpty() {
        this.check().that(this.actualList).isEmpty();
    }

    public void isNotEmpty() {
        this.check().that(this.actualList).isNotEmpty();
    }

    public void hasSize(int expectedSize) {
        this.check().that(this.actualList).hasSize(expectedSize);
    }

    public void contains(int element) {
        this.check().that(this.actualList).contains((Object)element);
    }

    public void doesNotContain(int element) {
        this.check().that(this.actualList).doesNotContain((Object)element);
    }

    public void containsNoDuplicates() {
        this.check().that(this.actualList).containsNoDuplicates();
    }

    public void containsAnyOf(int first, int second, int ... rest) {
        this.check().that(this.actualList).containsAnyOf((Object)first, (Object)second, IntStreamSubject.box(rest));
    }

    public void containsAnyIn(Iterable<?> expected) {
        this.check().that(this.actualList).containsAnyIn(expected);
    }

    @CanIgnoreReturnValue
    public Ordered containsAtLeast(int first, int second, int ... rest) {
        return this.check().that(this.actualList).containsAtLeast((Object)first, (Object)second, IntStreamSubject.box(rest));
    }

    @CanIgnoreReturnValue
    public Ordered containsAtLeastElementsIn(Iterable<?> expected) {
        return this.check().that(this.actualList).containsAtLeastElementsIn(expected);
    }

    @CanIgnoreReturnValue
    public Ordered containsExactly(int ... varargs) {
        return this.check().that(this.actualList).containsExactlyElementsIn(IntStreamSubject.box(varargs));
    }

    @CanIgnoreReturnValue
    public Ordered containsExactlyElementsIn(Iterable<?> expected) {
        return this.check().that(this.actualList).containsExactlyElementsIn(expected);
    }

    public void containsNoneOf(int first, int second, int ... rest) {
        this.check().that(this.actualList).containsNoneOf((Object)first, (Object)second, IntStreamSubject.box(rest));
    }

    public void containsNoneIn(Iterable<?> excluded) {
        this.check().that(this.actualList).containsNoneIn(excluded);
    }

    public void isInStrictOrder() {
        this.check().that(this.actualList).isInStrictOrder();
    }

    public void isInStrictOrder(Comparator<? super Integer> comparator) {
        this.check().that(this.actualList).isInStrictOrder(comparator);
    }

    public void isInOrder() {
        this.check().that(this.actualList).isInOrder();
    }

    public void isInOrder(Comparator<? super Integer> comparator) {
        this.check().that(this.actualList).isInOrder(comparator);
    }

    private static Object[] box(int[] rest) {
        return IntStream.of(rest).boxed().toArray(Integer[]::new);
    }
}

