/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.FunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.Flags;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.ProtoTypeTableUtilKt;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationContext;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolverUtilKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ProtoEnumFlags;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.SuspendFunctionTypeUtilKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.TypeDeserializer;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.TypeDeserializerKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedAnnotations;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedTypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.types.DefinitelyNotNullType;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SpecialTypesKt;
import kotlin.reflect.jvm.internal.impl.types.StarProjectionForAbsentTypeParameter;
import kotlin.reflect.jvm.internal.impl.types.StarProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeDeserializer {
    @NotNull
    private final DeserializationContext c;
    @Nullable
    private final TypeDeserializer parent;
    @NotNull
    private final String debugName;
    @NotNull
    private final String containerPresentableName;
    @NotNull
    private final Function1<Integer, ClassifierDescriptor> classifierDescriptors;
    @NotNull
    private final Function1<Integer, ClassifierDescriptor> typeAliasDescriptors;
    @NotNull
    private final Map<Integer, TypeParameterDescriptor> typeParameterDescriptors;

    public TypeDeserializer(@NotNull DeserializationContext c, @Nullable TypeDeserializer parent, @NotNull List<ProtoBuf.TypeParameter> typeParameterProtos, @NotNull String debugName, @NotNull String containerPresentableName) {
        Map map2;
        Intrinsics.checkNotNullParameter(c, "c");
        Intrinsics.checkNotNullParameter(typeParameterProtos, "typeParameterProtos");
        Intrinsics.checkNotNullParameter(debugName, "debugName");
        Intrinsics.checkNotNullParameter(containerPresentableName, "containerPresentableName");
        this.c = c;
        this.parent = parent;
        this.debugName = debugName;
        this.containerPresentableName = containerPresentableName;
        this.classifierDescriptors = this.c.getStorageManager().createMemoizedFunctionWithNullableValues((Function1)new Function1<Integer, ClassifierDescriptor>(this){
            final /* synthetic */ TypeDeserializer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final ClassifierDescriptor invoke(int fqNameIndex) {
                return TypeDeserializer.access$computeClassifierDescriptor(this.this$0, fqNameIndex);
            }
        });
        this.typeAliasDescriptors = this.c.getStorageManager().createMemoizedFunctionWithNullableValues((Function1)new Function1<Integer, ClassifierDescriptor>(this){
            final /* synthetic */ TypeDeserializer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final ClassifierDescriptor invoke(int fqNameIndex) {
                return TypeDeserializer.access$computeTypeAliasDescriptor(this.this$0, fqNameIndex);
            }
        });
        TypeDeserializer typeDeserializer = this;
        if (typeParameterProtos.isEmpty()) {
            map2 = MapsKt.emptyMap();
        } else {
            LinkedHashMap result2 = new LinkedHashMap();
            Iterator<ProtoBuf.TypeParameter> iterator2 = typeParameterProtos.iterator();
            int n = 0;
            TypeDeserializer typeDeserializer2 = typeDeserializer;
            while (iterator2.hasNext()) {
                int index = n++;
                ProtoBuf.TypeParameter proto = iterator2.next();
                ((Map)result2).put(proto.getId(), new DeserializedTypeParameterDescriptor(this.c, proto, index));
            }
            typeDeserializer = typeDeserializer2;
            map2 = result2;
        }
        typeDeserializer.typeParameterDescriptors = map2;
    }

    @NotNull
    public final List<TypeParameterDescriptor> getOwnTypeParameters() {
        return CollectionsKt.toList((Iterable)this.typeParameterDescriptors.values());
    }

    @NotNull
    public final KotlinType type(@NotNull ProtoBuf.Type proto) {
        Intrinsics.checkNotNullParameter(proto, "proto");
        if (proto.hasFlexibleTypeCapabilitiesId()) {
            String id = this.c.getNameResolver().getString(proto.getFlexibleTypeCapabilitiesId());
            SimpleType lowerBound = TypeDeserializer.simpleType$default(this, proto, false, 2, null);
            ProtoBuf.Type type2 = ProtoTypeTableUtilKt.flexibleUpperBound(proto, this.c.getTypeTable());
            Intrinsics.checkNotNull(type2);
            SimpleType upperBound = TypeDeserializer.simpleType$default(this, type2, false, 2, null);
            return this.c.getComponents().getFlexibleTypeDeserializer().create(proto, id, lowerBound, upperBound);
        }
        return this.simpleType(proto, true);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SimpleType simpleType(@NotNull ProtoBuf.Type proto, boolean expandTypeAliases) {
        SimpleType simpleType2;
        Object it;
        Object object;
        Object expandedType;
        void $this$mapIndexedTo$iv$iv;
        SimpleType localClassifierType;
        Intrinsics.checkNotNullParameter(proto, "proto");
        SimpleType simpleType3 = proto.hasClassName() ? this.computeLocalClassifierReplacementType(proto.getClassName()) : (localClassifierType = proto.hasTypeAliasName() ? this.computeLocalClassifierReplacementType(proto.getTypeAliasName()) : null);
        if (localClassifierType != null) {
            return localClassifierType;
        }
        TypeConstructor constructor = this.typeConstructor(proto);
        if (ErrorUtils.isError(constructor.getDeclarationDescriptor())) {
            SimpleType simpleType4 = ErrorUtils.createErrorTypeWithCustomConstructor(constructor.toString(), constructor);
            Intrinsics.checkNotNullExpressionValue(simpleType4, "createErrorTypeWithCusto\u2026.toString(), constructor)");
            return simpleType4;
        }
        DeserializedAnnotations annotations2 = new DeserializedAnnotations(this.c.getStorageManager(), (Function0<? extends List<? extends AnnotationDescriptor>>)new Function0<List<? extends AnnotationDescriptor>>(this, proto){
            final /* synthetic */ TypeDeserializer this$0;
            final /* synthetic */ ProtoBuf.Type $proto;
            {
                this.this$0 = $receiver;
                this.$proto = $proto;
                super(0);
            }

            @NotNull
            public final List<AnnotationDescriptor> invoke() {
                return TypeDeserializer.access$getC$p(this.this$0).getComponents().getAnnotationAndConstantLoader().loadTypeAnnotations(this.$proto, TypeDeserializer.access$getC$p(this.this$0).getNameResolver());
            }
        });
        Iterable $this$mapIndexed$iv = TypeDeserializer.simpleType$collectAllArguments(proto, this);
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void argumentProto;
            void index;
            int n = index$iv$iv;
            index$iv$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ProtoBuf.Type.Argument argument = (ProtoBuf.Type.Argument)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            List<TypeParameterDescriptor> list = constructor.getParameters();
            Intrinsics.checkNotNullExpressionValue(list, "constructor.parameters");
            TypeProjection typeProjection = this.typeArgument(CollectionsKt.getOrNull(list, (int)index), (ProtoBuf.Type.Argument)argumentProto);
            collection.add(typeProjection);
        }
        List arguments2 = CollectionsKt.toList((List)destination$iv$iv);
        ClassifierDescriptor declarationDescriptor = constructor.getDeclarationDescriptor();
        if (expandTypeAliases && declarationDescriptor instanceof TypeAliasDescriptor) {
            Object $this$simpleType_u24lambda_u2d1 = destination$iv$iv = KotlinTypeFactory.INSTANCE;
            boolean bl2 = false;
            object = ((SimpleType)expandedType).makeNullableAsSpecified(KotlinTypeKt.isNullable((KotlinType)(expandedType = KotlinTypeFactory.computeExpandedType((TypeAliasDescriptor)declarationDescriptor, arguments2))) || proto.getNullable()).replaceAnnotations(Annotations.Companion.create(CollectionsKt.plus((Iterable)annotations2, (Iterable)expandedType.getAnnotations())));
        } else {
            expandedType = Flags.SUSPEND_TYPE.get(proto.getFlags());
            Intrinsics.checkNotNullExpressionValue(expandedType, "SUSPEND_TYPE.get(proto.flags)");
            if (((Boolean)expandedType).booleanValue()) {
                object = this.createSuspendFunctionType(annotations2, constructor, arguments2, proto.getNullable());
            } else {
                it = expandedType = KotlinTypeFactory.simpleType$default(annotations2, constructor, arguments2, proto.getNullable(), null, 16, null);
                boolean bl = false;
                Object bl2 = Flags.DEFINITELY_NOT_NULL_TYPE.get(proto.getFlags());
                Intrinsics.checkNotNullExpressionValue(bl2, "DEFINITELY_NOT_NULL_TYPE.get(proto.flags)");
                if (((Boolean)bl2).booleanValue()) {
                    bl2 = DefinitelyNotNullType.Companion.makeDefinitelyNotNull$default(DefinitelyNotNullType.Companion, (UnwrappedType)it, false, 2, null);
                    if (bl2 == null) {
                        throw new IllegalStateException(("null DefinitelyNotNullType for '" + it + '\'').toString());
                    }
                    object = (SimpleType)bl2;
                } else {
                    object = it;
                }
            }
        }
        SimpleType simpleType5 = object;
        it = ProtoTypeTableUtilKt.abbreviatedType(proto, this.c.getTypeTable());
        if (it == null) {
            simpleType2 = simpleType5;
        } else {
            Object object2;
            Object it2 = object2 = it;
            boolean bl = false;
            simpleType2 = SpecialTypesKt.withAbbreviation(simpleType5, this.simpleType((ProtoBuf.Type)it2, false));
        }
        SimpleType computedType = simpleType2;
        if (proto.hasClassName()) {
            ClassId classId = NameResolverUtilKt.getClassId(this.c.getNameResolver(), proto.getClassName());
            return this.c.getComponents().getPlatformDependentTypeTransformer().transformPlatformType(classId, computedType);
        }
        return computedType;
    }

    public static /* synthetic */ SimpleType simpleType$default(TypeDeserializer typeDeserializer, ProtoBuf.Type type2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return typeDeserializer.simpleType(type2, bl);
    }

    private final TypeConstructor typeConstructor(ProtoBuf.Type proto) {
        Object object;
        Object object2;
        if (proto.hasClassName()) {
            object2 = this.classifierDescriptors.invoke(proto.getClassName());
            object = object2 == null ? (ClassifierDescriptor)TypeDeserializer.typeConstructor$notFoundClass(this, proto, proto.getClassName()) : object2;
        } else if (proto.hasTypeParameter()) {
            object2 = this.loadTypeParameter(proto.getTypeParameter());
            if (object2 == null) {
                TypeConstructor typeConstructor2 = ErrorUtils.createErrorTypeConstructor("Unknown type parameter " + proto.getTypeParameter() + ". Please try recompiling module containing \"" + this.containerPresentableName + '\"');
                Intrinsics.checkNotNullExpressionValue(typeConstructor2, "createErrorTypeConstruct\u2026\\\"\"\n                    )");
                return typeConstructor2;
            }
            object = object2;
        } else if (proto.hasTypeParameterName()) {
            Object v1;
            Object object3;
            String name;
            block11: {
                name = this.c.getNameResolver().getString(proto.getTypeParameterName());
                object3 = this.getOwnTypeParameters();
                Iterable iterable = object3;
                for (Object t2 : iterable) {
                    TypeParameterDescriptor it = (TypeParameterDescriptor)t2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getName().asString(), name)) continue;
                    v1 = t2;
                    break block11;
                }
                v1 = null;
            }
            TypeParameterDescriptor typeParameterDescriptor = v1;
            if (typeParameterDescriptor == null) {
                object3 = ErrorUtils.createErrorTypeConstructor("Deserialized type parameter " + name + " in " + this.c.getContainingDeclaration());
                Intrinsics.checkNotNullExpressionValue(object3, "createErrorTypeConstruct\u2026.containingDeclaration}\")");
                return object3;
            }
            object = typeParameterDescriptor;
        } else if (proto.hasTypeAliasName()) {
            object2 = this.typeAliasDescriptors.invoke(proto.getTypeAliasName());
            object = object2 == null ? (ClassifierDescriptor)TypeDeserializer.typeConstructor$notFoundClass(this, proto, proto.getTypeAliasName()) : object2;
        } else {
            TypeConstructor typeConstructor3 = ErrorUtils.createErrorTypeConstructor("Unknown type");
            Intrinsics.checkNotNullExpressionValue(typeConstructor3, "createErrorTypeConstructor(\"Unknown type\")");
            return typeConstructor3;
        }
        ClassifierDescriptor classifier2 = object;
        object2 = classifier2.getTypeConstructor();
        Intrinsics.checkNotNullExpressionValue(object2, "classifier.typeConstructor");
        return object2;
    }

    private final SimpleType createSuspendFunctionType(Annotations annotations2, TypeConstructor functionTypeConstructor, List<? extends TypeProjection> arguments2, boolean nullable) {
        SimpleType simpleType2;
        SimpleType result2;
        SimpleType simpleType3;
        int n = functionTypeConstructor.getParameters().size() - arguments2.size();
        switch (n) {
            case 0: {
                simpleType3 = this.createSuspendFunctionTypeForBasicCase(annotations2, functionTypeConstructor, arguments2, nullable);
                break;
            }
            case 1: {
                int arity = arguments2.size() - 1;
                if (arity >= 0) {
                    TypeConstructor typeConstructor2 = functionTypeConstructor.getBuiltIns().getSuspendFunction(arity).getTypeConstructor();
                    Intrinsics.checkNotNullExpressionValue(typeConstructor2, "functionTypeConstructor.\u2026on(arity).typeConstructor");
                    simpleType3 = KotlinTypeFactory.simpleType$default(annotations2, typeConstructor2, arguments2, nullable, null, 16, null);
                    break;
                }
                simpleType3 = null;
                break;
            }
            default: {
                simpleType3 = null;
            }
        }
        SimpleType simpleType4 = result2 = simpleType3;
        if (simpleType4 == null) {
            SimpleType simpleType5 = ErrorUtils.createErrorTypeWithArguments(Intrinsics.stringPlus("Bad suspend function in metadata with constructor: ", functionTypeConstructor), arguments2);
            Intrinsics.checkNotNullExpressionValue(simpleType5, "createErrorTypeWithArgum\u2026      arguments\n        )");
            simpleType2 = simpleType5;
        } else {
            simpleType2 = simpleType4;
        }
        return simpleType2;
    }

    private final SimpleType createSuspendFunctionTypeForBasicCase(Annotations annotations2, TypeConstructor functionTypeConstructor, List<? extends TypeProjection> arguments2, boolean nullable) {
        SimpleType functionType = KotlinTypeFactory.simpleType$default(annotations2, functionTypeConstructor, arguments2, nullable, null, 16, null);
        return !FunctionTypesKt.isFunctionType(functionType) ? null : this.transformRuntimeFunctionTypeToSuspendFunction(functionType);
    }

    private final SimpleType transformRuntimeFunctionTypeToSuspendFunction(KotlinType funType) {
        FqName continuationArgumentFqName;
        Object object = CollectionsKt.lastOrNull(FunctionTypesKt.getValueParameterTypesFromFunctionType(funType));
        if (object == null) {
            return null;
        }
        KotlinType kotlinType = object.getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "funType.getValueParamete\u2026ll()?.type ?: return null");
        KotlinType continuationArgumentType = kotlinType;
        object = continuationArgumentType.getConstructor().getDeclarationDescriptor();
        FqName fqName2 = continuationArgumentFqName = object == null ? null : DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)object);
        if (continuationArgumentType.getArguments().size() != 1 || !Intrinsics.areEqual(continuationArgumentFqName, StandardNames.CONTINUATION_INTERFACE_FQ_NAME) && !Intrinsics.areEqual(continuationArgumentFqName, TypeDeserializerKt.access$getEXPERIMENTAL_CONTINUATION_FQ_NAME$p())) {
            return (SimpleType)funType;
        }
        Annotated annotated = CollectionsKt.single(continuationArgumentType.getArguments()).getType();
        Intrinsics.checkNotNullExpressionValue(annotated, "continuationArgumentType.arguments.single().type");
        KotlinType suspendReturnType = annotated;
        DeclarationDescriptor $this$safeAs$iv = this.c.getContainingDeclaration();
        boolean $i$f$safeAs = false;
        DeclarationDescriptor declarationDescriptor = $this$safeAs$iv;
        if (!(declarationDescriptor instanceof CallableDescriptor)) {
            declarationDescriptor = null;
        }
        if (Intrinsics.areEqual((annotated = (CallableDescriptor)declarationDescriptor) == null ? null : DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)annotated), SuspendFunctionTypeUtilKt.KOTLIN_SUSPEND_BUILT_IN_FUNCTION_FQ_NAME)) {
            return this.createSimpleSuspendFunctionType(funType, suspendReturnType);
        }
        return this.createSimpleSuspendFunctionType(funType, suspendReturnType);
    }

    /*
     * WARNING - void declaration
     */
    private final SimpleType createSimpleSuspendFunctionType(KotlinType funType, KotlinType suspendReturnType) {
        Collection<KotlinType> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = CollectionsKt.dropLast(FunctionTypesKt.getValueParameterTypesFromFunctionType(funType), 1);
        KotlinType kotlinType = FunctionTypesKt.getReceiverTypeFromFunctionType(funType);
        Annotations annotations2 = funType.getAnnotations();
        KotlinBuiltIns kotlinBuiltIns = TypeUtilsKt.getBuiltIns(funType);
        boolean $i$f$map = false;
        void var5_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            KotlinType kotlinType2 = p0.getType();
            collection.add(kotlinType2);
        }
        collection = (List)destination$iv$iv;
        return FunctionTypesKt.createFunctionType(kotlinBuiltIns, annotations2, kotlinType, (List<? extends KotlinType>)collection, null, suspendReturnType, true).makeNullableAsSpecified(funType.isMarkedNullable());
    }

    private final TypeParameterDescriptor loadTypeParameter(int typeParameterId) {
        TypeDeserializer typeDeserializer;
        TypeParameterDescriptor typeParameterDescriptor = this.typeParameterDescriptors.get(typeParameterId);
        return typeParameterDescriptor == null ? ((typeDeserializer = this.parent) == null ? null : typeDeserializer.loadTypeParameter(typeParameterId)) : typeParameterDescriptor;
    }

    private final ClassifierDescriptor computeClassifierDescriptor(int fqNameIndex) {
        ClassId id = NameResolverUtilKt.getClassId(this.c.getNameResolver(), fqNameIndex);
        if (id.isLocal()) {
            return this.c.getComponents().deserializeClass(id);
        }
        return FindClassInModuleKt.findClassifierAcrossModuleDependencies(this.c.getComponents().getModuleDescriptor(), id);
    }

    private final SimpleType computeLocalClassifierReplacementType(int className) {
        if (NameResolverUtilKt.getClassId(this.c.getNameResolver(), className).isLocal()) {
            return this.c.getComponents().getLocalClassifierTypeSettings().getReplacementTypeForLocalClassifiers();
        }
        return null;
    }

    private final ClassifierDescriptor computeTypeAliasDescriptor(int fqNameIndex) {
        ClassId id = NameResolverUtilKt.getClassId(this.c.getNameResolver(), fqNameIndex);
        if (id.isLocal()) {
            return null;
        }
        return FindClassInModuleKt.findTypeAliasAcrossModuleDependencies(this.c.getComponents().getModuleDescriptor(), id);
    }

    private final TypeProjection typeArgument(TypeParameterDescriptor parameter, ProtoBuf.Type.Argument typeArgumentProto) {
        if (typeArgumentProto.getProjection() == ProtoBuf.Type.Argument.Projection.STAR) {
            return parameter == null ? (TypeProjection)new StarProjectionForAbsentTypeParameter(this.c.getComponents().getModuleDescriptor().getBuiltIns()) : (TypeProjection)new StarProjectionImpl(parameter);
        }
        ProtoBuf.Type.Argument.Projection projection = typeArgumentProto.getProjection();
        Intrinsics.checkNotNullExpressionValue(projection, "typeArgumentProto.projection");
        Variance projection2 = ProtoEnumFlags.INSTANCE.variance(projection);
        ProtoBuf.Type type2 = ProtoTypeTableUtilKt.type(typeArgumentProto, this.c.getTypeTable());
        if (type2 == null) {
            return new TypeProjectionImpl(ErrorUtils.createErrorType("No type recorded"));
        }
        ProtoBuf.Type type3 = type2;
        return new TypeProjectionImpl(projection2, this.type(type3));
    }

    @NotNull
    public String toString() {
        return Intrinsics.stringPlus(this.debugName, this.parent == null ? "" : Intrinsics.stringPlus(". Child of ", this.parent.debugName));
    }

    private static final List<ProtoBuf.Type.Argument> simpleType$collectAllArguments(ProtoBuf.Type $this$simpleType_u24collectAllArguments, TypeDeserializer this$0) {
        Object object = $this$simpleType_u24collectAllArguments.getArgumentList();
        Intrinsics.checkNotNullExpressionValue(object, "argumentList");
        Collection collection = (Collection)object;
        object = ProtoTypeTableUtilKt.outerType($this$simpleType_u24collectAllArguments, this$0.c.getTypeTable());
        List<ProtoBuf.Type.Argument> list = object == null ? null : TypeDeserializer.simpleType$collectAllArguments((ProtoBuf.Type)object, this$0);
        return CollectionsKt.plus(collection, (Iterable)(list == null ? CollectionsKt.emptyList() : list));
    }

    private static final ClassDescriptor typeConstructor$notFoundClass(TypeDeserializer this$0, ProtoBuf.Type $proto, int classIdIndex) {
        ClassId classId = NameResolverUtilKt.getClassId(this$0.c.getNameResolver(), classIdIndex);
        List<Integer> typeParametersCount2 = SequencesKt.toMutableList(SequencesKt.map(SequencesKt.generateSequence($proto, (Function1)new Function1<ProtoBuf.Type, ProtoBuf.Type>(this$0){
            final /* synthetic */ TypeDeserializer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final ProtoBuf.Type invoke(@NotNull ProtoBuf.Type it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return ProtoTypeTableUtilKt.outerType(it, TypeDeserializer.access$getC$p(this.this$0).getTypeTable());
            }
        }), typeConstructor.notFoundClass.typeParametersCount.2.INSTANCE));
        int classNestingLevel2 = SequencesKt.count(SequencesKt.generateSequence(classId, (Function1)typeConstructor.notFoundClass.classNestingLevel.1.INSTANCE));
        while (typeParametersCount2.size() < classNestingLevel2) {
            typeParametersCount2.add(0);
        }
        return this$0.c.getComponents().getNotFoundClasses().getClass(classId, typeParametersCount2);
    }

    public static final /* synthetic */ DeserializationContext access$getC$p(TypeDeserializer $this) {
        return $this.c;
    }

    public static final /* synthetic */ ClassifierDescriptor access$computeClassifierDescriptor(TypeDeserializer $this, int fqNameIndex) {
        return $this.computeClassifierDescriptor(fqNameIndex);
    }

    public static final /* synthetic */ ClassifierDescriptor access$computeTypeAliasDescriptor(TypeDeserializer $this, int fqNameIndex) {
        return $this.computeTypeAliasDescriptor(fqNameIndex);
    }
}

