/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.platform.runtime.android.device;

import com.google.testing.platform.api.device.Device;
import com.google.testing.platform.runtime.android.device.AndroidDeviceProperties;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\b\u0018\u0000 +2\u00020\u0001:\u0001+BK\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\rJ\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0006H\u00c6\u0003J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u000fJ\t\u0010 \u001a\u00020\nH\u00c6\u0003J\u0010\u0010!\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\"\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u000fJZ\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\bH\u00c6\u0001\u00a2\u0006\u0002\u0010$J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(H\u00d6\u0003J\t\u0010)\u001a\u00020\bH\u00d6\u0001J\t\u0010*\u001a\u00020\u0003H\u00d6\u0001R\u0015\u0010\u000b\u001a\u0004\u0018\u00010\b\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u0013\u0010\u000fR\u001a\u0010\t\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012R\u0015\u0010\f\u001a\u0004\u0018\u00010\b\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u0019\u0010\u000fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006,"}, d2={"Lcom/google/testing/platform/runtime/android/device/AndroidDevice;", "Lcom/google/testing/platform/api/device/Device;", "host", "", "serial", "type", "Lcom/google/testing/platform/api/device/Device$DeviceType;", "port", "", "properties", "Lcom/google/testing/platform/runtime/android/device/AndroidDeviceProperties;", "emulatorPort", "serverPort", "(Ljava/lang/String;Ljava/lang/String;Lcom/google/testing/platform/api/device/Device$DeviceType;Ljava/lang/Integer;Lcom/google/testing/platform/runtime/android/device/AndroidDeviceProperties;Ljava/lang/Integer;Ljava/lang/Integer;)V", "getEmulatorPort", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getHost", "()Ljava/lang/String;", "getPort", "getProperties", "()Lcom/google/testing/platform/runtime/android/device/AndroidDeviceProperties;", "setProperties", "(Lcom/google/testing/platform/runtime/android/device/AndroidDeviceProperties;)V", "getSerial", "getServerPort", "getType", "()Lcom/google/testing/platform/api/device/Device$DeviceType;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "(Ljava/lang/String;Ljava/lang/String;Lcom/google/testing/platform/api/device/Device$DeviceType;Ljava/lang/Integer;Lcom/google/testing/platform/runtime/android/device/AndroidDeviceProperties;Ljava/lang/Integer;Ljava/lang/Integer;)Lcom/google/testing/platform/runtime/android/device/AndroidDevice;", "equals", "", "other", "", "hashCode", "toString", "Companion", "java_com_google_testing_platform_runtime_android_device-android_device_api"})
public final class AndroidDevice
implements Device {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final String host;
    @NotNull
    private final String serial;
    @NotNull
    private final Device.DeviceType type;
    @Nullable
    private final Integer port;
    @NotNull
    private AndroidDeviceProperties properties;
    @Nullable
    private final Integer emulatorPort;
    @Nullable
    private final Integer serverPort;
    @Deprecated
    @NotNull
    public static final String LOCALHOST = "localhost";

    public AndroidDevice(@NotNull String host, @NotNull String serial, @NotNull Device.DeviceType type2, @Nullable Integer port, @NotNull AndroidDeviceProperties properties2, @Nullable Integer emulatorPort, @Nullable Integer serverPort) {
        Intrinsics.checkNotNullParameter(host, "host");
        Intrinsics.checkNotNullParameter(serial, "serial");
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        Intrinsics.checkNotNullParameter(properties2, "properties");
        this.host = host;
        this.serial = serial;
        this.type = type2;
        this.port = port;
        this.properties = properties2;
        this.emulatorPort = emulatorPort;
        this.serverPort = serverPort;
        if (!(((CharSequence)this.host).length() > 0)) {
            boolean $i$a$-require-AndroidDevice$62 = false;
            String $i$a$-require-AndroidDevice$62 = "host name cannot be empty";
            throw new IllegalArgumentException($i$a$-require-AndroidDevice$62.toString());
        }
        if (!(((CharSequence)this.getSerial()).length() > 0)) {
            boolean $i$a$-require-AndroidDevice$72 = false;
            String $i$a$-require-AndroidDevice$72 = "serial cannot be empty";
            throw new IllegalArgumentException($i$a$-require-AndroidDevice$72.toString());
        }
        if (!(this.getPort() == null || new IntRange(1, 65535).contains(this.getPort()))) {
            boolean $i$a$-require-AndroidDevice$82 = false;
            String $i$a$-require-AndroidDevice$82 = "Invalid adb port: " + this.getPort() + ". Must be in range 1..65535";
            throw new IllegalArgumentException($i$a$-require-AndroidDevice$82.toString());
        }
        if (!(this.serverPort == null || new IntRange(1, 65535).contains(this.serverPort))) {
            boolean $i$a$-require-AndroidDevice$92 = false;
            String $i$a$-require-AndroidDevice$92 = "Invalid server port: " + this.serverPort + ". Must be in range 1..65535";
            throw new IllegalArgumentException($i$a$-require-AndroidDevice$92.toString());
        }
        if (!(this.emulatorPort == null || new IntRange(1, 65535).contains(this.emulatorPort))) {
            boolean bl = false;
            String string = "Invalid emulator console port: " + this.emulatorPort + ". Must be in range 1..65535";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ AndroidDevice(String string, String string2, Device.DeviceType deviceType, Integer n, AndroidDeviceProperties androidDeviceProperties, Integer n2, Integer n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 1) != 0) {
            string = LOCALHOST;
        }
        if ((n4 & 8) != 0) {
            n = null;
        }
        if ((n4 & 0x20) != 0) {
            n2 = null;
        }
        if ((n4 & 0x40) != 0) {
            n3 = null;
        }
        this(string, string2, deviceType, n, androidDeviceProperties, n2, n3);
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    @Override
    @NotNull
    public String getSerial() {
        return this.serial;
    }

    @Override
    @NotNull
    public Device.DeviceType getType() {
        return this.type;
    }

    @Override
    @Nullable
    public Integer getPort() {
        return this.port;
    }

    @Override
    @NotNull
    public AndroidDeviceProperties getProperties() {
        return this.properties;
    }

    public void setProperties(@NotNull AndroidDeviceProperties androidDeviceProperties) {
        Intrinsics.checkNotNullParameter(androidDeviceProperties, "<set-?>");
        this.properties = androidDeviceProperties;
    }

    @Nullable
    public final Integer getEmulatorPort() {
        return this.emulatorPort;
    }

    @Nullable
    public final Integer getServerPort() {
        return this.serverPort;
    }

    @NotNull
    public final String component1() {
        return this.host;
    }

    @NotNull
    public final String component2() {
        return this.getSerial();
    }

    @NotNull
    public final Device.DeviceType component3() {
        return this.getType();
    }

    @Nullable
    public final Integer component4() {
        return this.getPort();
    }

    @NotNull
    public final AndroidDeviceProperties component5() {
        return this.getProperties();
    }

    @Nullable
    public final Integer component6() {
        return this.emulatorPort;
    }

    @Nullable
    public final Integer component7() {
        return this.serverPort;
    }

    @NotNull
    public final AndroidDevice copy(@NotNull String host, @NotNull String serial, @NotNull Device.DeviceType type2, @Nullable Integer port, @NotNull AndroidDeviceProperties properties2, @Nullable Integer emulatorPort, @Nullable Integer serverPort) {
        Intrinsics.checkNotNullParameter(host, "host");
        Intrinsics.checkNotNullParameter(serial, "serial");
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        Intrinsics.checkNotNullParameter(properties2, "properties");
        return new AndroidDevice(host, serial, type2, port, properties2, emulatorPort, serverPort);
    }

    public static /* synthetic */ AndroidDevice copy$default(AndroidDevice androidDevice, String string, String string2, Device.DeviceType deviceType, Integer n, AndroidDeviceProperties androidDeviceProperties, Integer n2, Integer n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            string = androidDevice.host;
        }
        if ((n4 & 2) != 0) {
            string2 = androidDevice.getSerial();
        }
        if ((n4 & 4) != 0) {
            deviceType = androidDevice.getType();
        }
        if ((n4 & 8) != 0) {
            n = androidDevice.getPort();
        }
        if ((n4 & 0x10) != 0) {
            androidDeviceProperties = androidDevice.getProperties();
        }
        if ((n4 & 0x20) != 0) {
            n2 = androidDevice.emulatorPort;
        }
        if ((n4 & 0x40) != 0) {
            n3 = androidDevice.serverPort;
        }
        return androidDevice.copy(string, string2, deviceType, n, androidDeviceProperties, n2, n3);
    }

    @NotNull
    public String toString() {
        return "AndroidDevice(host=" + this.host + ", serial=" + this.getSerial() + ", type=" + (Object)((Object)this.getType()) + ", port=" + this.getPort() + ", properties=" + this.getProperties() + ", emulatorPort=" + this.emulatorPort + ", serverPort=" + this.serverPort + ')';
    }

    public int hashCode() {
        int result2 = this.host.hashCode();
        result2 = result2 * 31 + this.getSerial().hashCode();
        result2 = result2 * 31 + this.getType().hashCode();
        result2 = result2 * 31 + (this.getPort() == null ? 0 : ((Object)this.getPort()).hashCode());
        result2 = result2 * 31 + this.getProperties().hashCode();
        result2 = result2 * 31 + (this.emulatorPort == null ? 0 : ((Object)this.emulatorPort).hashCode());
        result2 = result2 * 31 + (this.serverPort == null ? 0 : ((Object)this.serverPort).hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AndroidDevice)) {
            return false;
        }
        AndroidDevice androidDevice = (AndroidDevice)other;
        if (!Intrinsics.areEqual(this.host, androidDevice.host)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getSerial(), androidDevice.getSerial())) {
            return false;
        }
        if (this.getType() != androidDevice.getType()) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getPort(), androidDevice.getPort())) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getProperties(), androidDevice.getProperties())) {
            return false;
        }
        if (!Intrinsics.areEqual(this.emulatorPort, androidDevice.emulatorPort)) {
            return false;
        }
        return Intrinsics.areEqual(this.serverPort, androidDevice.serverPort);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/google/testing/platform/runtime/android/device/AndroidDevice$Companion;", "", "()V", "LOCALHOST", "", "java_com_google_testing_platform_runtime_android_device-android_device_api"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

