/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.platform.launcher;

import com.google.testing.platform.launcher.LogRecordWithThreadName;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\f\u0010\u000e\u001a\u00020\u0004*\u00020\u000fH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/google/testing/platform/launcher/LogFormatter;", "Ljava/util/logging/Formatter;", "()V", "format", "", "record", "Ljava/util/logging/LogRecord;", "getRootThreadGroup", "Ljava/lang/ThreadGroup;", "getThread", "Ljava/lang/Thread;", "threadID", "", "getThreadName", "stackTraceAsPrinted", "", "Companion", "java_com_google_testing_platform_launcher-thread_aware_console_handler"})
final class LogFormatter
extends Formatter {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Deprecated
    @NotNull
    private static final SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("yyMMdd HH:mm:ss.SSS", Locale.ROOT);
    @Deprecated
    @NotNull
    private static final Map<Level, Character> levels;
    @Deprecated
    @NotNull
    private static final Map<Long, String> threadNames;

    @Override
    @NotNull
    public String format(@NotNull LogRecord record) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(record, "record");
        StringBuilder $this$format_u24lambda_u2d0 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$format_u24lambda_u2d0.append(dateTimeFormatter.format(record.getMillis()));
        $this$format_u24lambda_u2d0.append(':');
        $this$format_u24lambda_u2d0.append(levels.getOrDefault(record.getLevel(), Character.valueOf('X')).charValue());
        if (record.getThrown() != null) {
            $this$format_u24lambda_u2d0.append('T');
        }
        $this$format_u24lambda_u2d0.append(' ');
        $this$format_u24lambda_u2d0.append(record.getThreadID());
        $this$format_u24lambda_u2d0.append(" [").append(this.getThreadName(record)).append(']');
        $this$format_u24lambda_u2d0.append(" [");
        if (record.getSourceClassName() != null && !Intrinsics.areEqual(record.getSourceClassName(), "<unknown class>")) {
            $this$format_u24lambda_u2d0.append(record.getSourceClassName());
            if (record.getSourceMethodName() != null) {
                $this$format_u24lambda_u2d0.append('.');
                $this$format_u24lambda_u2d0.append(record.getSourceMethodName());
            }
        } else {
            $this$format_u24lambda_u2d0.append(record.getLoggerName());
        }
        $this$format_u24lambda_u2d0.append("] ");
        $this$format_u24lambda_u2d0.append(this.formatMessage(record));
        $this$format_u24lambda_u2d0.append('\n');
        if (record.getThrown() != null) {
            Throwable throwable = record.getThrown();
            Intrinsics.checkNotNullExpressionValue(throwable, "record.thrown");
            $this$format_u24lambda_u2d0.append(this.stackTraceAsPrinted(throwable));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        String result2 = string;
        return result2;
    }

    private final String stackTraceAsPrinted(Throwable $this$stackTraceAsPrinted) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println();
        $this$stackTraceAsPrinted.printStackTrace(pw);
        pw.close();
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue(string, "sw.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String getThreadName(LogRecord record) {
        String string;
        if (record instanceof LogRecordWithThreadName) {
            string = ((LogRecordWithThreadName)record).getThreadName();
        } else {
            Object object;
            void $this$getOrPut$iv;
            Map<Long, String> map2 = threadNames;
            Long key$iv = record.getThreadID();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                String string2;
                String string3;
                boolean bl = false;
                Thread thread2 = this.getThread(record.getThreadID());
                String string4 = string3 = thread2 != null ? thread2.getName() : null;
                if (string4 == null) {
                    string2 = String.valueOf(record.getThreadID());
                } else {
                    Intrinsics.checkNotNullExpressionValue(string4, "getThread(record.threadI\u2026e ?: \"${record.threadID}\"");
                    string2 = string3;
                }
                String answer$iv = string2;
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            string = (String)object;
        }
        return string;
    }

    private final Thread getThread(long threadID) {
        Thread thread2;
        block2: {
            int n;
            ThreadGroup root = this.getRootThreadGroup();
            int n2 = 0;
            int n3 = root.activeCount();
            Thread[] threadArray = new Thread[n3];
            while (n2 < n3) {
                n = n2++;
                threadArray[n] = null;
            }
            Thread[] allThreads = threadArray;
            root.enumerate(allThreads);
            Thread[] threadArray2 = allThreads;
            n = threadArray2.length;
            for (int i = 0; i < n; ++i) {
                Thread thread3;
                Thread it = thread3 = threadArray2[i];
                boolean bl = false;
                Thread thread4 = it;
                boolean bl2 = thread4 != null ? thread4.getId() == threadID : false;
                if (!bl2) continue;
                thread2 = thread3;
                break block2;
            }
            thread2 = null;
        }
        return thread2;
    }

    private final ThreadGroup getRootThreadGroup() {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        while (group.getParent() != null) {
            group = group.getParent();
        }
        ThreadGroup threadGroup = group;
        Intrinsics.checkNotNullExpressionValue(threadGroup, "group");
        return threadGroup;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(Level.FINEST, Character.valueOf('D')), TuplesKt.to(Level.FINER, Character.valueOf('D')), TuplesKt.to(Level.FINE, Character.valueOf('D')), TuplesKt.to(Level.CONFIG, Character.valueOf('I')), TuplesKt.to(Level.INFO, Character.valueOf('I')), TuplesKt.to(Level.WARNING, Character.valueOf('W')), TuplesKt.to(Level.SEVERE, Character.valueOf('X'))};
        levels = MapsKt.mapOf(pairArray);
        threadNames = new LinkedHashMap();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R%\u0010\u0007\u001a\u0016\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\u0004\u0012\u00020\u000b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\r\u00a8\u0006\u0013"}, d2={"Lcom/google/testing/platform/launcher/LogFormatter$Companion;", "", "()V", "dateTimeFormatter", "Ljava/text/SimpleDateFormat;", "getDateTimeFormatter", "()Ljava/text/SimpleDateFormat;", "levels", "", "Ljava/util/logging/Level;", "kotlin.jvm.PlatformType", "", "getLevels", "()Ljava/util/Map;", "threadNames", "", "", "", "getThreadNames", "java_com_google_testing_platform_launcher-thread_aware_console_handler"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SimpleDateFormat getDateTimeFormatter() {
            return dateTimeFormatter;
        }

        @NotNull
        public final Map<Level, Character> getLevels() {
            return levels;
        }

        @NotNull
        public final Map<Long, String> getThreadNames() {
            return threadNames;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

