/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.platform.launcher;

import com.google.common.base.Preconditions;
import com.google.testing.platform.launcher.ThreadAwareConsoleHandler;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public final class Launcher {
    private static final Logger logger;
    private static final String RUNNER_MAIN_CLASS = "com.google.testing.platform.main.MainKt";
    private static final String RUNNER_MAIN_METHOD = "main";

    private Launcher() {
    }

    public static void main(String[] args2) throws Exception {
        if (System.getenv("UTP_THREAD_AWARE_CONSOLE_HANDLER") != null) {
            ThreadAwareConsoleHandler.swapConsoleHandlers();
        }
        Preconditions.checkArgument(args2.length > 0, "Missing path to UnifiedTestPlatform core Jar. Please run:'java com.google.testing.platform.launcher.Launcher -classpath UTP base Jars><custom plugin Jars> /path/to/core_deploy.jar");
        String coreJarPath = args2[0];
        Preconditions.checkArgument(coreJarPath != null && !coreJarPath.isEmpty(), "UnifiedTestPlatform core jar arg cannot be null or empty!");
        File runnerCoreJar = new File(coreJarPath);
        Preconditions.checkState(runnerCoreJar.exists(), "UnifiedTestPlatform core Jar path: %s does not exist!", (Object)coreJarPath);
        logger.fine("Launching UnifiedTestPlatform runner from Jar: " + runnerCoreJar.getAbsolutePath());
        String[] mainArgs = Arrays.copyOfRange(args2, 1, args2.length);
        URLClassLoader coreClassloader = new URLClassLoader(new URL[]{runnerCoreJar.toURI().toURL()}, Launcher.class.getClassLoader());
        try {
            Class<?> mainClass = Class.forName(RUNNER_MAIN_CLASS, true, coreClassloader);
            Method mainMethod = mainClass.getMethod(RUNNER_MAIN_METHOD, String[].class);
            mainMethod.invoke(null, new Object[]{mainArgs});
        }
        catch (Throwable throwable) {
            throw new RuntimeException("UnifiedTestPlatform encountered an error in: com.google.testing.platform.main.MainKt", throwable);
        }
    }

    static {
        System.setProperty("java.util.logging.manager", UtpLogManager.class.getName());
        logger = Logger.getLogger(Launcher.class.getSimpleName());
    }

    public static class UtpLogManager
    extends LogManager {
        static UtpLogManager manager;

        public UtpLogManager() {
            manager = this;
        }

        @Override
        public void reset() {
        }
    }
}

