/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.platform.core.telemetry;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.testing.platform.core.telemetry.EventRecordRequest;
import com.google.testing.platform.core.telemetry.TelemetryConstantsKt;
import com.google.testing.platform.core.telemetry.core.Detail;
import com.google.testing.platform.proto.api.core.PhaseProto;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u000f\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\"\u0010\u001e\u001a\u00020\u001f2\u001a\u0010\u0006\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00020\b0\u0013J*\u0010 \u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0002\u0018\u00010\b2\u0006\u0010!\u001a\u00020\u00042\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\bH\u0007J.\u0010\u0011\u001a\u00020\u001f2&\u0010\"\u001a\"\u0012\u0004\u0012\u00028\u0000\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00020\b0\u00130\u0012R%\u0010\u0006\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR(\u0010\f\u001a\u0004\u0018\u00010\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0005R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR:\u0010\u0011\u001a\"\u0012\u0004\u0012\u00028\u0000\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00020\b0\u00130\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R$\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u00198F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006#"}, d2={"Lcom/google/testing/platform/core/telemetry/EventRecordRequest;", "T", "", "name", "", "(Ljava/lang/String;)V", "attributes", "", "Lcom/google/testing/platform/core/telemetry/core/Detail;", "getAttributes", "()Ljava/util/Map;", "value", "displayName", "getDisplayName", "()Ljava/lang/String;", "setDisplayName", "getName$java_com_google_testing_platform_core_telemetry_telemetry_api", "onComplete", "Lkotlin/Function1;", "", "getOnComplete", "()Lkotlin/jvm/functions/Function1;", "setOnComplete", "(Lkotlin/jvm/functions/Function1;)V", "phase", "Lcom/google/testing/platform/proto/api/core/PhaseProto$TestPhase;", "getPhase", "()Lcom/google/testing/platform/proto/api/core/PhaseProto$TestPhase;", "setPhase", "(Lcom/google/testing/platform/proto/api/core/PhaseProto$TestPhase;)V", "addAllAttributes", "", "addAttribute", "key", "block", "java_com_google_testing_platform_core_telemetry-telemetry_api"})
public abstract class EventRecordRequest<T> {
    @NotNull
    private final String name;
    @NotNull
    private final Map<String, Detail<? extends Object>> attributes;
    @NotNull
    private Function1<? super T, ? extends Map<String, ? extends Detail<? extends Object>>> onComplete;

    public EventRecordRequest(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        this.name = name;
        this.attributes = new LinkedHashMap();
        this.onComplete = onComplete.1.INSTANCE;
    }

    @NotNull
    public final String getName$java_com_google_testing_platform_core_telemetry_telemetry_api() {
        return this.name;
    }

    @Nullable
    public final String getDisplayName() {
        Detail<? extends Object> detail = this.attributes.get("DisplayName");
        return String.valueOf(detail != null ? detail.getValue() : null);
    }

    public final void setDisplayName(@Nullable String value) {
        block0: {
            String string = value;
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            this.attributes.put("DisplayName", new Detail<String>(it));
        }
    }

    @NotNull
    public final PhaseProto.TestPhase getPhase() {
        Detail<? extends Object> detail = this.attributes.get(TelemetryConstantsKt.getPHASE_ATTRIBUTE_KEY());
        PhaseProto.TestPhase testPhase = (PhaseProto.TestPhase)(detail != null ? detail.getValue() : null);
        if (testPhase == null) {
            testPhase = PhaseProto.TestPhase.TEST_PHASE_UNSPECIFIED;
        }
        return testPhase;
    }

    public final void setPhase(@NotNull PhaseProto.TestPhase phase) {
        Intrinsics.checkNotNullParameter(phase, "phase");
        Map<String, Detail<? extends Object>> map2 = this.attributes;
        String string = TelemetryConstantsKt.getPHASE_ATTRIBUTE_KEY();
        Intrinsics.checkNotNullExpressionValue(string, "PHASE_ATTRIBUTE_KEY");
        String string2 = string;
        Detail<String> detail = new Detail<String>(phase.name());
        map2.put(string2, detail);
    }

    @NotNull
    public final Map<String, Detail<? extends Object>> getAttributes() {
        return this.attributes;
    }

    @NotNull
    public final Function1<T, Map<String, Detail<? extends Object>>> getOnComplete() {
        return this.onComplete;
    }

    public final void setOnComplete(@NotNull Function1<? super T, ? extends Map<String, ? extends Detail<? extends Object>>> function1) {
        Intrinsics.checkNotNullParameter(function1, "<set-?>");
        this.onComplete = function1;
    }

    public final void onComplete(@NotNull Function1<? super T, ? extends Map<String, ? extends Detail<? extends Object>>> block) {
        Intrinsics.checkNotNullParameter(block, "block");
        this.onComplete = block;
    }

    @CanIgnoreReturnValue
    @Nullable
    public final Detail<? extends Object> addAttribute(@NotNull String key, @NotNull Detail<? extends Object> value) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value, "value");
        return this.attributes.put(key, value);
    }

    public final void addAllAttributes(@NotNull Map<String, ? extends Detail<? extends Object>> attributes) {
        Intrinsics.checkNotNullParameter(attributes, "attributes");
        this.attributes.putAll(attributes);
    }
}

