/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.platform.api.device;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0018\u001a\u00020\u0003H\u0086\u0002J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0086\u0002J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001d\u001a\u00020\u0003H\u0016J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\t0\u001f2\b\b\u0002\u0010 \u001a\u00020!J\u0018\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0002\u0010 \u001a\u00020!H\u0002R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006#"}, d2={"Lcom/google/testing/platform/api/device/CommandResult;", "", "statusCode", "", "byteOutput", "", "(I[B)V", "output", "", "", "(ILjava/util/List;)V", "byteOutputStream", "Ljava/io/InputStream;", "(ILjava/io/InputStream;)V", "getByteOutput", "()[B", "byteOutput$delegate", "Lkotlin/Lazy;", "getByteOutputStream", "()Ljava/io/InputStream;", "getOutput", "()Ljava/util/List;", "getStatusCode", "()I", "component1", "component2", "equals", "", "other", "hashCode", "outputLineSequence", "Lkotlin/sequences/Sequence;", "charset", "Ljava/nio/charset/Charset;", "outputLines", "java_com_google_testing_platform_api_device-command_result_api"})
public final class CommandResult {
    private final int statusCode;
    @NotNull
    private final InputStream byteOutputStream;
    @NotNull
    private final Lazy byteOutput$delegate;

    public CommandResult(int statusCode, @NotNull InputStream byteOutputStream) {
        Intrinsics.checkNotNullParameter(byteOutputStream, "byteOutputStream");
        this.statusCode = statusCode;
        this.byteOutputStream = byteOutputStream;
        this.byteOutput$delegate = LazyKt.lazy((Function0)new Function0<byte[]>(this){
            final /* synthetic */ CommandResult this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final byte[] invoke() {
                return this.this$0.getByteOutputStream().readAllBytes();
            }
        });
    }

    public final int getStatusCode() {
        return this.statusCode;
    }

    @NotNull
    public final InputStream getByteOutputStream() {
        return this.byteOutputStream;
    }

    public CommandResult(int statusCode, @NotNull byte[] byteOutput2) {
        Intrinsics.checkNotNullParameter(byteOutput2, "byteOutput");
        this(statusCode, new ByteArrayInputStream(byteOutput2));
    }

    public CommandResult(int statusCode, @NotNull List<String> output) {
        Intrinsics.checkNotNullParameter(output, "output");
        byte[] byArray = CollectionsKt.joinToString$default(output, "\n", null, null, 0, null, null, 62, null).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
        this(statusCode, byArray);
    }

    @NotNull
    public final List<String> getOutput() {
        return this.outputLines(Charsets.UTF_8);
    }

    private final List<String> outputLines(Charset charset) {
        String $this$outputLines_u24lambda_u2d0 = ((Object)StringsKt.trim((CharSequence)new String(this.getByteOutput(), charset))).toString();
        boolean bl = false;
        return ((CharSequence)$this$outputLines_u24lambda_u2d0).length() == 0 ? CollectionsKt.emptyList() : StringsKt.lines($this$outputLines_u24lambda_u2d0);
    }

    static /* synthetic */ List outputLines$default(CommandResult commandResult, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return commandResult.outputLines(charset);
    }

    @NotNull
    public final byte[] getByteOutput() {
        Lazy lazy = this.byteOutput$delegate;
        Object t2 = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue(t2, "<get-byteOutput>(...)");
        return (byte[])t2;
    }

    @NotNull
    public final Sequence<String> outputLineSequence(@NotNull Charset charset) {
        Intrinsics.checkNotNullParameter(charset, "charset");
        Reader reader = new InputStreamReader(this.byteOutputStream, charset);
        int n = 8192;
        return TextStreamsKt.lineSequence(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n));
    }

    public static /* synthetic */ Sequence outputLineSequence$default(CommandResult commandResult, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return commandResult.outputLineSequence(charset);
    }

    public final int component1() {
        return this.statusCode;
    }

    @NotNull
    public final List<String> component2() {
        return this.getOutput();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(object != null ? object.getClass() : null, this.getClass())) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.google.testing.platform.api.device.CommandResult");
        }
        CommandResult cfr_ignored_0 = (CommandResult)object2;
        return this.statusCode == ((CommandResult)other).statusCode && Arrays.equals(this.getByteOutput(), ((CommandResult)other).getByteOutput());
    }

    public int hashCode() {
        return this.statusCode + 31 * Arrays.hashCode(this.getByteOutput());
    }
}

