/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.platform.lib.adb.command.instrument.lib;

import com.google.testing.platform.lib.adb.command.Instrumentation;
import com.google.testing.platform.lib.adb.command.instrument.lib.InstrumentationException;
import com.google.testing.platform.lib.logging.jvm.LoggerExtKt;
import com.google.testing.platform.proto.api.config.InstrumentationProto;
import com.google.testing.platform.proto.api.core.RegexPatternProto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\u0018\u0010\u000b\u001a\u0004\u0018\u00010\u00042\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\u0006\u0010\f\u001a\u00020\u0004J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\nJ\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0004H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/google/testing/platform/lib/adb/command/instrument/lib/InstrumentationFinder;", "", "availableInstrumentations", "", "Lcom/google/testing/platform/lib/adb/command/Instrumentation;", "configInstrumentation", "instrumentationFilter", "Lcom/google/testing/platform/proto/api/config/InstrumentationProto$InstrumentationFilter;", "(Ljava/util/Set;Lcom/google/testing/platform/lib/adb/command/Instrumentation;Lcom/google/testing/platform/proto/api/config/InstrumentationProto$InstrumentationFilter;)V", "findAndSortInstrumentations", "", "findConfigInstrumentation", "findFirst", "findTestServices", "matches", "", "Lcom/google/testing/platform/proto/api/core/RegexPatternProto$RegexPattern;", "instrumentation", "Lkotlin/text/Regex;", "Companion", "lib_java_com_google_testing_platform_lib_adb_command_instrument_lib-instrumentation_finder"})
public final class InstrumentationFinder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<Instrumentation> availableInstrumentations;
    @NotNull
    private final InstrumentationProto.InstrumentationFilter instrumentationFilter;
    @Nullable
    private final Instrumentation configInstrumentation;
    @NotNull
    public static final String ORCHESTRATOR_V1_INSTR = "androidx.test.orchestrator/androidx.test.orchestrator.AndroidTestOrchestrator";
    @NotNull
    public static final String ORCHESTRATOR_V1_SHORT_INSTR = "androidx.test.orchestrator/.AndroidTestOrchestrator";
    @NotNull
    public static final String ORCHESTRATOR_V2_INSTR = "com.google.testing.platform.android.core/com.google.testing.platform.android.core.AndroidTestOrchestrator";
    @NotNull
    public static final String ORCHESTRATOR_V2_SHORT_INSTR = "com.google.testing.platform.android.core/.AndroidTestOrchestrator";
    @NotNull
    private static final Logger logger = LoggerExtKt.getLogger(Companion);
    @NotNull
    private static final Set<String> IGNORED_INSTRUMENTATION_PKGS;
    @NotNull
    private static final Set<String> SUPPORTED_SERVICE_INSTRUMENTATION;

    public InstrumentationFinder(@NotNull Set<Instrumentation> availableInstrumentations, @Nullable Instrumentation configInstrumentation, @NotNull InstrumentationProto.InstrumentationFilter instrumentationFilter) {
        Intrinsics.checkNotNullParameter(availableInstrumentations, (String)"availableInstrumentations");
        Intrinsics.checkNotNullParameter((Object)instrumentationFilter, (String)"instrumentationFilter");
        this.availableInstrumentations = availableInstrumentations;
        this.instrumentationFilter = instrumentationFilter;
        Instrumentation instrumentation = configInstrumentation;
        this.configInstrumentation = instrumentation != null ? instrumentation.isValidOrNull() : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Instrumentation> findTestServices() {
        List list;
        void $this$filterTo$iv$iv;
        logger.fine("Requesting test service instrumentations from device.");
        Iterable $this$filter$iv = this.availableInstrumentations;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Instrumentation it = (Instrumentation)element$iv$iv;
            boolean bl = false;
            if (!SUPPORTED_SERVICE_INSTRUMENTATION.contains(it.getTestPackage() + '/' + it.getInstrumentationClass())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List it = list = (List)destination$iv$iv;
        boolean bl = false;
        logger.fine("Found the following test service instrumentation(s): " + CollectionsKt.joinToString$default((Iterable)it, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Instrumentation findFirst() {
        Instrumentation instrumentation;
        Instrumentation instrumentation2 = this.findConfigInstrumentation(this.availableInstrumentations);
        if (instrumentation2 != null) {
            Instrumentation it = instrumentation2;
            boolean bl = false;
            logger.info("Using specified instrumentation: " + it);
            return it;
        }
        List<Instrumentation> found = this.findAndSortInstrumentations(this.availableInstrumentations);
        switch (found.size()) {
            case 0: {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Collection collection;
                void $this$mapTo$iv$iv2;
                List list = this.instrumentationFilter.getInstrumentationClassFiltersList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"instrumentationFilter.in\u2026mentationClassFiltersList");
                Iterable $this$map$iv2 = list;
                boolean $i$f$map22 = false;
                Iterable iterable = $this$map$iv2;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    RegexPatternProto.RegexPattern regexPattern = (RegexPatternProto.RegexPattern)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    StringBuilder stringBuilder = new StringBuilder().append("  ");
                    String string = it.getExpression();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.expression");
                    collection.add(stringBuilder.append(StringsKt.replace$default((String)string, (String)"\\.", (String)".", (boolean)false, (int)4, null)).toString());
                }
                String acceptableInstrumentationsString = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                Iterable $i$f$map22 = this.availableInstrumentations;
                boolean $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Instrumentation bl = (Instrumentation)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add("  " + it.getAppPackage() + '/' + it.getInstrumentationClass());
                }
                String availableInstrumentationsString = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv2), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                throw new InstrumentationException("The available instrumentations are not supported. Must be one of:\n" + acceptableInstrumentationsString + ".\nYou may need to add an <instrumentation> element to your AndroidManifest file with an acceptable instrumentation using the test's package. Example:\n<instrumentation\n    android:name=\"androidx.test.runner.AndroidJUnitRunner\"\n    android:targetPackage=\"PACKAGE_NAME\">\n</instrumentation>\nAvailable instrumentations were:\n" + availableInstrumentationsString, null, 2, null);
            }
            case 1: {
                Object object = CollectionsKt.first(found);
                Instrumentation it = (Instrumentation)object;
                boolean bl = false;
                logger.info("Found instrumentation: " + it);
                instrumentation = (Instrumentation)object;
                break;
            }
            default: {
                Object object = CollectionsKt.first(found);
                Instrumentation it = (Instrumentation)object;
                boolean bl = false;
                logger.warning("Multiple instrumentations found: " + found);
                instrumentation = (Instrumentation)object;
            }
        }
        return instrumentation;
    }

    private final Instrumentation findConfigInstrumentation(Set<Instrumentation> availableInstrumentations) {
        Object v0;
        block3: {
            if (this.configInstrumentation == null) {
                return null;
            }
            Iterable $this$firstOrNull$iv = availableInstrumentations;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Instrumentation it = (Instrumentation)element$iv;
                boolean bl = false;
                if (!this.configInstrumentation.matches(it)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        Instrumentation instrumentation = v0;
        if (instrumentation != null) {
            Instrumentation it = instrumentation;
            boolean bl = false;
            return it;
        }
        throw new InstrumentationException("Configured instrumentation: " + this.configInstrumentation.getFullName() + " not found on device! Please check logs for more details!", null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Instrumentation> findAndSortInstrumentations(Set<Instrumentation> availableInstrumentations) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = availableInstrumentations;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Instrumentation it = (Instrumentation)element$iv$iv;
            boolean bl = false;
            if (!(!IGNORED_INSTRUMENTATION_PKGS.contains(it.getTestPackage()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List instrumentationsToCheck = (List)destination$iv$iv;
        List list = this.instrumentationFilter.getInstrumentationClassFiltersList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"instrumentationFilter.in\u2026mentationClassFiltersList");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$filterTo$iv$iv2;
            RegexPatternProto.RegexPattern classFilter = (RegexPatternProto.RegexPattern)element$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv2 = instrumentationsToCheck;
            boolean $i$f$filter2 = false;
            Iterable iterable2 = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv2) {
                boolean bl2;
                Instrumentation it = (Instrumentation)element$iv$iv2;
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)classFilter, (String)"classFilter");
                boolean isSupported = bl2 = this.matches(classFilter, it);
                boolean bl4 = false;
                if (!isSupported) {
                    logger.fine("Ignoring instrumentation: " + it);
                }
                if (!bl2) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
    }

    private final boolean matches(RegexPatternProto.RegexPattern $this$matches, Instrumentation instrumentation) {
        boolean bl = $this$matches.getInverted();
        String string = $this$matches.getExpression();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"expression");
        return bl ^ this.matches(new Regex(string), instrumentation);
    }

    private final boolean matches(Regex $this$matches, Instrumentation instrumentation) {
        return $this$matches.matches((CharSequence)instrumentation.getFullInstrumentationClass()) || $this$matches.matches((CharSequence)instrumentation.getInstrumentationClass());
    }

    static {
        Object[] objectArray = new String[]{"com.android.smoketest", "com.android.emulator.smoketests"};
        IGNORED_INSTRUMENTATION_PKGS = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{ORCHESTRATOR_V1_INSTR, ORCHESTRATOR_V1_SHORT_INSTR, ORCHESTRATOR_V2_INSTR, ORCHESTRATOR_V2_SHORT_INSTR};
        SUPPORTED_SERVICE_INSTRUMENTATION = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u00020\f8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\r\u0010\u0002\u00a8\u0006\u000e"}, d2={"Lcom/google/testing/platform/lib/adb/command/instrument/lib/InstrumentationFinder$Companion;", "", "()V", "IGNORED_INSTRUMENTATION_PKGS", "", "", "ORCHESTRATOR_V1_INSTR", "ORCHESTRATOR_V1_SHORT_INSTR", "ORCHESTRATOR_V2_INSTR", "ORCHESTRATOR_V2_SHORT_INSTR", "SUPPORTED_SERVICE_INSTRUMENTATION", "logger", "Ljava/util/logging/Logger;", "getLogger$annotations", "lib_java_com_google_testing_platform_lib_adb_command_instrument_lib-instrumentation_finder"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getLogger$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

