/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.platform.lib.adb.command.instrument;

import com.google.testing.platform.lib.adb.command.instrument.AmInstrumentationListener;
import com.google.testing.platform.lib.adb.command.instrument.InstrumentationResult;
import com.google.testing.platform.lib.adb.command.instrument.TestIdentifier;
import com.google.testing.platform.lib.adb.command.instrument.TestResult;
import com.google.testing.platform.lib.adb.command.timing.TestTimeTracker;
import com.google.testing.platform.proto.api.core.TestStatusProto;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 >2\u00020\u0001:\u0002>?B%\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0006\u0010'\u001a\u00020(J\b\u0010)\u001a\u00020\u0016H\u0002J\u0014\u0010*\u001a\u00020(2\n\b\u0002\u0010+\u001a\u0004\u0018\u00010\u000bH\u0002J\u0017\u0010,\u001a\u00020(2\b\u0010-\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0002\u0010.J\u000e\u0010/\u001a\u00020(2\u0006\u00100\u001a\u00020\u000bJ\u0018\u00101\u001a\u00020(2\u0006\u00100\u001a\u00020\u000b2\u0006\u00102\u001a\u00020\rH\u0002J\u0018\u00103\u001a\u00020(2\u0006\u00100\u001a\u00020\u000b2\u0006\u00102\u001a\u00020\rH\u0002J\u0010\u00104\u001a\u00020(2\u0006\u0010#\u001a\u00020\"H\u0002J\u0010\u00105\u001a\u00020(2\u0006\u00106\u001a\u00020\u000bH\u0002J\u0012\u00107\u001a\u00020(2\b\u00108\u001a\u0004\u0018\u00010\u0016H\u0002J\u0010\u00109\u001a\u00020(2\u0006\u0010:\u001a\u00020;H\u0002J\u0010\u0010<\u001a\u00020(2\u0006\u00108\u001a\u00020\u0016H\u0002J\b\u0010=\u001a\u00020(H\u0002R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0018\u00010\u0012j\u0004\u0018\u0001`\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n\u0018\u00010\u0012j\u0004\u0018\u0001`\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u001c\u001a\u0004\u0018\u00010\u000b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010#\u001a\u0004\u0018\u00010\"2\b\u0010\u001b\u001a\u0004\u0018\u00010\"@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/google/testing/platform/lib/adb/command/instrument/AmInstrumentationParser;", "", "listeners", "", "Lcom/google/testing/platform/lib/adb/command/instrument/AmInstrumentationListener;", "testTimeTrackerFactory", "Lkotlin/Function0;", "Lcom/google/testing/platform/lib/adb/command/timing/TestTimeTracker;", "(Ljava/util/Set;Lkotlin/jvm/functions/Function0;)V", "bundle", "", "", "code", "", "Ljava/lang/Integer;", "completedTestsCount", "currentKey", "currentResultValue", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "currentStatusValue", "currentTestRecord", "Lcom/google/testing/platform/lib/adb/command/instrument/AmInstrumentationParser$TestRecord;", "expectedTestsCount", "instrumentationEnded", "", "instrumentationEndedReported", "<set-?>", "instrumentationError", "getInstrumentationError", "()Ljava/lang/String;", "instrumentationStartedReported", "onErrorMessage", "parsingEnded", "Lcom/google/testing/platform/lib/adb/command/instrument/InstrumentationResult;", "result", "getResult", "()Lcom/google/testing/platform/lib/adb/command/instrument/InstrumentationResult;", "testStartedReported", "done", "", "getOrCreateCurrentTestRecord", "handleInstrumentationEnded", "errorCause", "handleStatusCode", "statusCode", "(Ljava/lang/Integer;)V", "parse", "line", "parseResultKeyValue", "startIndex", "parseStatusKeyValue", "reportInstrumentationEnded", "reportInstrumentationFailed", "message", "reportInstrumentationStarted", "testRecord", "reportTestEnded", "testResult", "Lcom/google/testing/platform/lib/adb/command/instrument/TestResult;", "reportTestStarted", "storeCurrentValue", "Companion", "TestRecord", "lib_java_com_google_testing_platform_lib_adb_command_instrument-instrumentation_parser"})
public final class AmInstrumentationParser {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<AmInstrumentationListener> listeners;
    @NotNull
    private final Function0<TestTimeTracker> testTimeTrackerFactory;
    @Nullable
    private InstrumentationResult result;
    @Nullable
    private String instrumentationError;
    @Nullable
    private String currentKey;
    @Nullable
    private StringBuilder currentResultValue;
    @Nullable
    private StringBuilder currentStatusValue;
    @Nullable
    private Integer code;
    @NotNull
    private Map<String, String> bundle;
    @Nullable
    private Integer expectedTestsCount;
    private int completedTestsCount;
    @Nullable
    private TestRecord currentTestRecord;
    @Nullable
    private String onErrorMessage;
    private boolean parsingEnded;
    private boolean instrumentationEnded;
    private boolean instrumentationStartedReported;
    private boolean instrumentationEndedReported;
    private boolean testStartedReported;
    @Deprecated
    @NotNull
    public static final String ABORTED = "INSTRUMENTATION_ABORTED: ";
    @Deprecated
    @NotNull
    public static final String CODE = "INSTRUMENTATION_CODE: ";
    @Deprecated
    @NotNull
    public static final String ON_ERROR = "onError: ";
    @Deprecated
    @NotNull
    public static final String RESULT = "INSTRUMENTATION_RESULT: ";
    @Deprecated
    @NotNull
    public static final String STATUS = "INSTRUMENTATION_STATUS: ";
    @Deprecated
    @NotNull
    public static final String STATUS_CODE = "INSTRUMENTATION_STATUS_CODE: ";
    @Deprecated
    @NotNull
    public static final String STATUS_FAILED = "INSTRUMENTATION_FAILED: ";
    @Deprecated
    @NotNull
    public static final String PREFIX = "INSTRUMENTATION_";
    @Deprecated
    @NotNull
    public static final String STATUS_CLASS = "class";
    @Deprecated
    @NotNull
    public static final String STATUS_CURRENT = "current";
    @Deprecated
    @NotNull
    public static final String STATUS_ERROR = "Error";
    @Deprecated
    @NotNull
    public static final String STATUS_ID = "id";
    @Deprecated
    @NotNull
    public static final String STATUS_NUMTESTS = "numtests";
    @Deprecated
    @NotNull
    public static final String STATUS_SHORTMSG = "shortMsg";
    @Deprecated
    @NotNull
    public static final String STATUS_STACK = "stack";
    @Deprecated
    @NotNull
    public static final String STATUS_STREAM = "stream";
    @Deprecated
    @NotNull
    public static final String STATUS_TEST = "test";
    @Deprecated
    @NotNull
    private static final Set<String> knownStatus;
    @Deprecated
    public static final int STATUS_CODE_START = 1;
    @Deprecated
    public static final int STATUS_CODE_IN_PROGRESS = 2;
    @Deprecated
    public static final int STATUS_CODE_OK = 0;
    @Deprecated
    public static final int STATUS_CODE_ERROR = -1;
    @Deprecated
    public static final int STATUS_CODE_FAILURE = -2;
    @Deprecated
    public static final int STATUS_CODE_IGNORED = -3;
    @Deprecated
    public static final int STATUS_CODE_ASSUMPTION_FAILURE = -4;
    @Deprecated
    @NotNull
    public static final String ERROR_NO_TEST_RESULTS = "No test results";
    @Deprecated
    @NotNull
    public static final String FATAL_ERROR_MSG = "Fatal exception when running tests";
    @Deprecated
    @NotNull
    public static final String STREAM_INSTRUMENTATION_PROCESS_CRASHED = "Test instrumentation process crashed";
    @Deprecated
    @NotNull
    private static final Regex STREAM_FAILURES_REGEX;

    public AmInstrumentationParser(@NotNull Set<? extends AmInstrumentationListener> listeners, @NotNull Function0<? extends TestTimeTracker> testTimeTrackerFactory) {
        Intrinsics.checkNotNullParameter(listeners, (String)"listeners");
        Intrinsics.checkNotNullParameter(testTimeTrackerFactory, (String)"testTimeTrackerFactory");
        this.listeners = listeners;
        this.testTimeTrackerFactory = testTimeTrackerFactory;
        this.bundle = new LinkedHashMap();
    }

    public /* synthetic */ AmInstrumentationParser(Set set, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 2) != 0) {
            function0 = 1.INSTANCE;
        }
        this(set, (Function0<? extends TestTimeTracker>)function0);
    }

    @Nullable
    public final InstrumentationResult getResult() {
        return this.result;
    }

    @Nullable
    public final String getInstrumentationError() {
        return this.instrumentationError;
    }

    public final void parse(@NotNull String line) {
        block6: {
            StringBuilder stringBuilder;
            block13: {
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                block8: {
                                    block7: {
                                        block5: {
                                            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                                            if (!(!this.parsingEnded)) {
                                                boolean bl = false;
                                                String string = "Parsing was completed, but parse() was called again!";
                                                throw new IllegalStateException(string.toString());
                                            }
                                            if (StringsKt.startsWith$default((String)line, (String)PREFIX, (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)line, (String)ON_ERROR, (boolean)false, (int)2, null)) {
                                                this.storeCurrentValue();
                                            }
                                            if (!StringsKt.startsWith$default((String)line, (String)STATUS, (boolean)false, (int)2, null)) break block5;
                                            this.parseStatusKeyValue(line, STATUS.length());
                                            break block6;
                                        }
                                        if (!StringsKt.startsWith$default((String)line, (String)STATUS_CODE, (boolean)false, (int)2, null)) break block7;
                                        String string = line.substring(STATUS_CODE.length());
                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                                        Integer statusCode = StringsKt.toIntOrNull((String)((Object)StringsKt.trim((CharSequence)string)).toString());
                                        this.handleStatusCode(statusCode);
                                        break block6;
                                    }
                                    if (!StringsKt.startsWith$default((String)line, (String)STATUS_FAILED, (boolean)false, (int)2, null)) break block8;
                                    AmInstrumentationParser.handleInstrumentationEnded$default(this, null, 1, null);
                                    break block6;
                                }
                                if (!StringsKt.startsWith$default((String)line, (String)ON_ERROR, (boolean)false, (int)2, null)) break block9;
                                this.onErrorMessage = ((Object)StringsKt.trim((CharSequence)line)).toString();
                                break block6;
                            }
                            if (!StringsKt.startsWith$default((String)line, (String)ABORTED, (boolean)false, (int)2, null)) break block10;
                            String string = this.onErrorMessage;
                            if (string == null) {
                                String string2 = line.substring(ABORTED.length());
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                                string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                            }
                            this.onErrorMessage = string;
                            break block6;
                        }
                        if (!StringsKt.startsWith$default((String)line, (String)CODE, (boolean)false, (int)2, null)) break block11;
                        String string = line.substring(CODE.length());
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                        this.code = StringsKt.toIntOrNull((String)((Object)StringsKt.trim((CharSequence)string)).toString());
                        this.instrumentationEnded = true;
                        AmInstrumentationParser.handleInstrumentationEnded$default(this, null, 1, null);
                        break block6;
                    }
                    if (!StringsKt.startsWith$default((String)line, (String)RESULT, (boolean)false, (int)2, null)) break block12;
                    this.parseResultKeyValue(line, RESULT.length());
                    break block6;
                }
                if (this.currentStatusValue == null) break block13;
                StringBuilder stringBuilder2 = this.currentStatusValue;
                if (stringBuilder2 == null) break block6;
                StringBuilder stringBuilder3 = stringBuilder2.append('\n');
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append('\\n')");
                stringBuilder2 = stringBuilder3;
                if (stringBuilder3 != null) {
                    stringBuilder2.append(line);
                }
                break block6;
            }
            if (this.currentResultValue == null || (stringBuilder = this.currentResultValue) == null) break block6;
            StringBuilder stringBuilder4 = stringBuilder.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append('\\n')");
            stringBuilder = stringBuilder4;
            if (stringBuilder4 != null) {
                stringBuilder.append(line);
            }
        }
    }

    public final void done() {
        if (!(!this.parsingEnded)) {
            boolean bl = false;
            String string = "Parsing was completed, but done() was called again!";
            throw new IllegalStateException(string.toString());
        }
        this.parsingEnded = true;
        this.storeCurrentValue();
        AmInstrumentationParser.handleInstrumentationEnded$default(this, null, 1, null);
    }

    private final void parseResultKeyValue(String line, int startIndex) {
        int idx = StringsKt.indexOf$default((CharSequence)line, (char)'=', (int)startIndex, (boolean)false, (int)4, null);
        if (idx != -1) {
            String string = line.substring(startIndex, idx);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            this.currentKey = ((Object)StringsKt.trim((CharSequence)string)).toString();
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = line.substring(idx + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            this.currentResultValue = stringBuilder.append(string2);
        }
    }

    private final void parseStatusKeyValue(String line, int startIndex) {
        int idx = StringsKt.indexOf$default((CharSequence)line, (char)'=', (int)startIndex, (boolean)false, (int)4, null);
        if (idx != -1) {
            String string = line.substring(startIndex, idx);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            this.currentKey = ((Object)StringsKt.trim((CharSequence)string)).toString();
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = line.substring(idx + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            this.currentStatusValue = stringBuilder.append(string2);
        }
    }

    private final void storeCurrentValue() {
        String string = this.currentKey;
        if (string == null) {
            return;
        }
        String key = string;
        StringBuilder statusValue = this.currentStatusValue;
        if (statusValue != null) {
            TestRecord testRecord = this.getOrCreateCurrentTestRecord();
            String string2 = statusValue.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"statusValue.toString()");
            testRecord.storeStatus(key, string2);
            this.currentStatusValue = null;
            return;
        }
        StringBuilder resultValue = this.currentResultValue;
        if (resultValue != null) {
            Map<String, String> map = this.bundle;
            String string3 = resultValue.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"resultValue.toString()");
            String string4 = string3;
            map.put(key, string4);
            this.currentResultValue = null;
        }
    }

    private final void handleStatusCode(Integer statusCode) {
        TestRecord testRecord;
        TestRecord testRecord2 = testRecord = this.currentTestRecord;
        if (!(testRecord2 != null ? testRecord2.isComplete() : false)) {
            return;
        }
        if (!this.instrumentationStartedReported) {
            this.reportInstrumentationStarted(testRecord);
        }
        Integer n = statusCode;
        int n2 = 2;
        if (n != null && n == n2) {
            return;
        }
        Integer n3 = statusCode;
        n2 = 1;
        if (n3 != null && n3 == n2) {
            this.reportTestStarted(testRecord);
            testRecord.markTestStarted();
            return;
        }
        this.currentTestRecord = null;
        if (this.testStartedReported) {
            this.reportTestEnded(testRecord.toTestResult(statusCode));
        }
        if (testRecord.getError() != null) {
            this.handleInstrumentationEnded(testRecord.getError());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleInstrumentationEnded(String errorCause) {
        InstrumentationResult result;
        Map map;
        String error;
        if (this.instrumentationEndedReported) {
            return;
        }
        String shortMsg = this.bundle.get(STATUS_SHORTMSG);
        String string = this.bundle.get(STATUS_STREAM);
        if (string == null) {
            string = "";
        }
        String streamMsg = string;
        boolean wasInstrumentationStartedReported = this.instrumentationStartedReported;
        Integer n = this.expectedTestsCount;
        String notEnoughTestsError = (n != null ? n : 0) > this.completedTestsCount ? "Expected " + this.expectedTestsCount + " tests, received " + this.completedTestsCount : (String)null;
        String string2 = errorCause;
        if (string2 == null) {
            if (shortMsg != null) {
                string2 = "Instrumentation run failed due to " + shortMsg;
            } else if (!wasInstrumentationStartedReported && !this.instrumentationEnded) {
                string2 = ERROR_NO_TEST_RESULTS;
            } else {
                string2 = notEnoughTestsError;
                if (string2 == null) {
                    string2 = StringsKt.contains$default((CharSequence)streamMsg, (CharSequence)FATAL_ERROR_MSG, (boolean)false, (int)2, null) ? streamMsg : null;
                }
            }
        }
        if ((error = string2) != null) {
            String string3 = this.onErrorMessage != null ? error + ". " + this.onErrorMessage : (error = STREAM_FAILURES_REGEX.containsMatchIn((CharSequence)streamMsg) ? error + ". " + streamMsg : error);
        }
        if (error == null && this.expectedTestsCount == null && STREAM_FAILURES_REGEX.containsMatchIn((CharSequence)streamMsg) && StringsKt.contains$default((CharSequence)streamMsg, (CharSequence)STREAM_INSTRUMENTATION_PROCESS_CRASHED, (boolean)false, (int)2, null)) {
            error = ((Object)StringsKt.trim((CharSequence)streamMsg)).toString();
        }
        if (!this.instrumentationStartedReported) {
            this.reportInstrumentationStarted(this.currentTestRecord);
        }
        if (this.testStartedReported) {
            TestRecord testRecord = this.getOrCreateCurrentTestRecord();
            this.currentTestRecord = null;
            this.reportTestEnded(testRecord.toTestResult(-1));
        }
        this.instrumentationError = error;
        if (error != null) {
            this.reportInstrumentationFailed("Test run failed to complete. " + error);
        }
        Map map2 = map = MapsKt.toMutableMap(this.bundle);
        Integer n2 = this.code;
        boolean bl = false;
        Iterable $this$forEach$iv = knownStatus;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void it;
            String p0 = (String)element$iv;
            boolean bl2 = false;
            it.remove(p0);
        }
        Map map3 = map;
        Integer n3 = n2;
        this.result = result = new InstrumentationResult(n3, map3);
        this.reportInstrumentationEnded(result);
    }

    static /* synthetic */ void handleInstrumentationEnded$default(AmInstrumentationParser amInstrumentationParser, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        amInstrumentationParser.handleInstrumentationEnded(string);
    }

    private final void reportInstrumentationStarted(TestRecord testRecord) {
        TestRecord testRecord2 = testRecord;
        this.expectedTestsCount = testRecord2 != null ? testRecord2.getNumTests() : null;
        this.instrumentationStartedReported = true;
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AmInstrumentationListener it = (AmInstrumentationListener)element$iv;
            boolean bl = false;
            Integer n = this.expectedTestsCount;
            it.instrumentationStarted(n != null ? n : 0);
        }
    }

    private final void reportTestStarted(TestRecord testRecord) {
        TestIdentifier testIdentifier = testRecord.toTestIdentifier();
        this.testStartedReported = true;
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AmInstrumentationListener it = (AmInstrumentationListener)element$iv;
            boolean bl = false;
            it.testStarted(testIdentifier);
        }
    }

    private final void reportTestEnded(TestResult testResult) {
        ++this.completedTestsCount;
        this.testStartedReported = false;
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AmInstrumentationListener it = (AmInstrumentationListener)element$iv;
            boolean bl = false;
            it.testEnded(testResult);
        }
    }

    private final void reportInstrumentationFailed(String message) {
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AmInstrumentationListener it = (AmInstrumentationListener)element$iv;
            boolean bl = false;
            it.instrumentationFailed(message);
        }
    }

    private final void reportInstrumentationEnded(InstrumentationResult result) {
        this.instrumentationEndedReported = true;
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AmInstrumentationListener it = (AmInstrumentationListener)element$iv;
            boolean bl = false;
            it.instrumentationEnded(result);
        }
    }

    private final TestRecord getOrCreateCurrentTestRecord() {
        TestRecord testResult = this.currentTestRecord;
        if (testResult == null) {
            this.currentTestRecord = testResult = new TestRecord((TestTimeTracker)this.testTimeTrackerFactory.invoke());
        }
        return testResult;
    }

    public AmInstrumentationParser() {
        this(null, null, 3, null);
    }

    static {
        Object[] objectArray = new String[]{STATUS_CLASS, STATUS_CURRENT, STATUS_ERROR, STATUS_ID, STATUS_NUMTESTS, STATUS_SHORTMSG, STATUS_STACK, STATUS_STREAM, STATUS_TEST};
        knownStatus = SetsKt.setOf((Object[])objectArray);
        STREAM_FAILURES_REGEX = new Regex("There (?:was|were) \\d+ failure");
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0006J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0015\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\"R\"\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR$\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\u0005\u001a\u0004\u0018\u00010\n@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/google/testing/platform/lib/adb/command/instrument/AmInstrumentationParser$TestRecord;", "", "testTimeTracker", "Lcom/google/testing/platform/lib/adb/command/timing/TestTimeTracker;", "(Lcom/google/testing/platform/lib/adb/command/timing/TestTimeTracker;)V", "<set-?>", "", "error", "getError", "()Ljava/lang/String;", "", "numTests", "getNumTests", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "stackTrace", "startedTestClass", "startedTestMethod", "statusBundle", "", "testClass", "testMethod", "isComplete", "", "markTestStarted", "", "storeStatus", "key", "value", "toTestIdentifier", "Lcom/google/testing/platform/lib/adb/command/instrument/TestIdentifier;", "toTestResult", "Lcom/google/testing/platform/lib/adb/command/instrument/TestResult;", "statusCode", "(Ljava/lang/Integer;)Lcom/google/testing/platform/lib/adb/command/instrument/TestResult;", "lib_java_com_google_testing_platform_lib_adb_command_instrument-instrumentation_parser"})
    private static final class TestRecord {
        @NotNull
        private final TestTimeTracker testTimeTracker;
        @Nullable
        private Integer numTests;
        @Nullable
        private String error;
        @Nullable
        private String testClass;
        @Nullable
        private String testMethod;
        @Nullable
        private String stackTrace;
        @NotNull
        private final Map<String, String> statusBundle;
        @Nullable
        private String startedTestClass;
        @Nullable
        private String startedTestMethod;

        public TestRecord(@NotNull TestTimeTracker testTimeTracker) {
            Intrinsics.checkNotNullParameter((Object)testTimeTracker, (String)"testTimeTracker");
            this.testTimeTracker = testTimeTracker;
            this.statusBundle = new LinkedHashMap();
            this.testTimeTracker.testStart();
        }

        @Nullable
        public final Integer getNumTests() {
            return this.numTests;
        }

        @Nullable
        public final String getError() {
            return this.error;
        }

        public final void markTestStarted() {
            this.startedTestClass = this.testClass;
            this.startedTestMethod = this.testMethod;
            this.testClass = null;
            this.testMethod = null;
        }

        public final boolean isComplete() {
            return this.testClass != null && this.testMethod != null || this.error != null;
        }

        public final void storeStatus(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            String string = key;
            if (Intrinsics.areEqual((Object)string, (Object)AmInstrumentationParser.STATUS_CLASS)) {
                this.testClass = ((Object)StringsKt.trim((CharSequence)value)).toString();
            } else if (Intrinsics.areEqual((Object)string, (Object)AmInstrumentationParser.STATUS_TEST)) {
                this.testMethod = ((Object)StringsKt.trim((CharSequence)value)).toString();
            } else if (Intrinsics.areEqual((Object)string, (Object)AmInstrumentationParser.STATUS_STACK)) {
                this.stackTrace = value;
            } else if (Intrinsics.areEqual((Object)string, (Object)AmInstrumentationParser.STATUS_NUMTESTS)) {
                this.numTests = StringsKt.toIntOrNull((String)((Object)StringsKt.trim((CharSequence)value)).toString());
            } else if (Intrinsics.areEqual((Object)string, (Object)AmInstrumentationParser.STATUS_ERROR)) {
                this.error = value;
            } else if (!Companion.getKnownStatus().contains(string)) {
                this.statusBundle.put(key, value);
            }
        }

        @NotNull
        public final TestIdentifier toTestIdentifier() {
            String string = this.testClass;
            if (string == null && (string = this.startedTestClass) == null) {
                string = "";
            }
            String testClass = string;
            String string2 = StringsKt.substringBeforeLast((String)testClass, (char)'.', (String)"");
            String string3 = StringsKt.substringAfterLast((String)testClass, (char)'.', (String)testClass);
            String string4 = this.testMethod;
            if (string4 == null && (string4 = this.startedTestMethod) == null) {
                string4 = "unknown test method";
            }
            return new TestIdentifier(string2, string3, string4);
        }

        @NotNull
        public final TestResult toTestResult(@Nullable Integer statusCode) {
            TestStatusProto.TestStatus testStatus;
            Integer n;
            this.testTimeTracker.testEnd();
            TestIdentifier testIdentifier = this.toTestIdentifier();
            Integer n2 = n = statusCode;
            if (n2 != null && n2 == 0) {
                testStatus = TestStatusProto.TestStatus.PASSED;
            } else {
                Integer n3 = n;
                int n4 = -1;
                if (n3 != null && n3 == n4) {
                    testStatus = TestStatusProto.TestStatus.FAILED;
                } else {
                    Integer n5 = n;
                    n4 = -2;
                    if (n5 != null && n5 == n4) {
                        testStatus = TestStatusProto.TestStatus.FAILED;
                    } else {
                        boolean bl;
                        Integer n6 = n;
                        n4 = -4;
                        if (n6 != null && n6 == n4) {
                            bl = true;
                        } else {
                            Integer n7 = n;
                            n4 = -3;
                            bl = n7 != null && n7 == n4;
                        }
                        testStatus = bl ? TestStatusProto.TestStatus.IGNORED : TestStatusProto.TestStatus.ERROR;
                    }
                }
            }
            Instant instant = Instant.ofEpochMilli(this.testTimeTracker.getTestTimingData().getStartTime());
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochMilli(testTimeTra\u2026testTimingData.startTime)");
            Instant instant2 = Instant.ofEpochMilli(this.testTimeTracker.getTestTimingData().getEndTime());
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"ofEpochMilli(testTimeTra\u2026r.testTimingData.endTime)");
            return new TestResult(testIdentifier, testStatus, instant, instant2, this.stackTrace, MapsKt.toMap(this.statusBundle));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u0006("}, d2={"Lcom/google/testing/platform/lib/adb/command/instrument/AmInstrumentationParser$Companion;", "", "()V", "ABORTED", "", "CODE", "ERROR_NO_TEST_RESULTS", "FATAL_ERROR_MSG", "ON_ERROR", "PREFIX", "RESULT", "STATUS", "STATUS_CLASS", "STATUS_CODE", "STATUS_CODE_ASSUMPTION_FAILURE", "", "STATUS_CODE_ERROR", "STATUS_CODE_FAILURE", "STATUS_CODE_IGNORED", "STATUS_CODE_IN_PROGRESS", "STATUS_CODE_OK", "STATUS_CODE_START", "STATUS_CURRENT", "STATUS_ERROR", "STATUS_FAILED", "STATUS_ID", "STATUS_NUMTESTS", "STATUS_SHORTMSG", "STATUS_STACK", "STATUS_STREAM", "STATUS_TEST", "STREAM_FAILURES_REGEX", "Lkotlin/text/Regex;", "getSTREAM_FAILURES_REGEX", "()Lkotlin/text/Regex;", "STREAM_INSTRUMENTATION_PROCESS_CRASHED", "knownStatus", "", "getKnownStatus", "()Ljava/util/Set;", "lib_java_com_google_testing_platform_lib_adb_command_instrument-instrumentation_parser"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getKnownStatus() {
            return knownStatus;
        }

        @NotNull
        public final Regex getSTREAM_FAILURES_REGEX() {
            return STREAM_FAILURES_REGEX;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

