/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal;

import dagger.internal.AbstractMapFactory;
import dagger.internal.DaggerCollections;
import dagger.internal.InstanceFactory;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Provider;

public final class MapFactory<K, V>
extends AbstractMapFactory<K, V, V> {
    private static final Provider<Map<Object, Object>> EMPTY = InstanceFactory.create(Collections.emptyMap());

    public static <K, V> Builder<K, V> builder(int size) {
        return new Builder(size);
    }

    public static <K, V> Provider<Map<K, V>> emptyMapProvider() {
        return EMPTY;
    }

    private MapFactory(Map<K, Provider<V>> map2) {
        super(map2);
    }

    @Override
    public Map<K, V> get() {
        LinkedHashMap result = DaggerCollections.newLinkedHashMapWithExpectedSize(this.contributingMap().size());
        for (Map.Entry entry : this.contributingMap().entrySet()) {
            result.put(entry.getKey(), entry.getValue().get());
        }
        return Collections.unmodifiableMap(result);
    }

    public static final class Builder<K, V>
    extends AbstractMapFactory.Builder<K, V, V> {
        private Builder(int size) {
            super(size);
        }

        public Builder<K, V> put(K key, Provider<V> providerOfValue) {
            super.put(key, providerOfValue);
            return this;
        }

        public Builder<K, V> putAll(Provider<Map<K, V>> mapFactory) {
            super.putAll(mapFactory);
            return this;
        }

        public MapFactory<K, V> build() {
            return new MapFactory(this.map);
        }
    }
}

