/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.platform.runtime.android.provider.local;

import com.google.testing.platform.api.config.Environment;
import com.google.testing.platform.api.device.Device;
import com.google.testing.platform.config.v1.extension.LocalAndroidDeviceProviderExtKt;
import com.google.testing.platform.proto.api.config.LocalAndroidDeviceProviderProto;
import com.google.testing.platform.runtime.android.device.AndroidDevice;
import com.google.testing.platform.runtime.android.device.AndroidDeviceProperties;
import com.google.testing.platform.runtime.android.provider.local.AndroidDeviceFromSerialKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"deviceFromConfig", "Lcom/google/testing/platform/runtime/android/device/AndroidDevice;", "config", "Lcom/google/testing/platform/proto/api/config/LocalAndroidDeviceProviderProto$LocalAndroidDeviceProvider;", "environment", "Lcom/google/testing/platform/api/config/Environment;", "java_com_google_testing_platform_runtime_android_provider_local-android_device_from_config"})
public final class AndroidDeviceFromConfigKt {
    @NotNull
    public static final AndroidDevice deviceFromConfig(@NotNull LocalAndroidDeviceProviderProto.LocalAndroidDeviceProvider config, @NotNull Environment environment) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        String host = LocalAndroidDeviceProviderExtKt.getHostOrDefault(config);
        String serial = LocalAndroidDeviceProviderExtKt.getDeviceSerialOrDefault(config);
        Integer adbPort = LocalAndroidDeviceProviderExtKt.getAdbPortOrDefault(config);
        Integer consolePort = LocalAndroidDeviceProviderExtKt.getConsolePortOrDefault(config);
        Integer adbServerPort = LocalAndroidDeviceProviderExtKt.getAdbServerPortOrDefault(config);
        String string = config.getSerial();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"config.serial");
        if (StringsKt.isBlank((CharSequence)string)) {
            String string2 = config.getHost();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"config.host");
            if (!StringsKt.isBlank((CharSequence)string2) && config.getAdbPort() > 0) {
                serial = host + ':' + adbPort;
            }
        }
        String string3 = config.getSerial();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"config.serial");
        if (!StringsKt.isBlank((CharSequence)string3) && config.getAdbPort() < 1) {
            String string4 = config.getSerial();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"config.serial");
            AndroidDevice device = AndroidDeviceFromSerialKt.deviceFromSerial(string4, config, environment);
            host = device.getHost();
            adbPort = device.getPort();
            if (config.getConsolePort() < 1 && device.getEmulatorPort() != null) {
                consolePort = device.getEmulatorPort();
            }
        }
        String string5 = host;
        String string6 = serial;
        Device.DeviceType deviceType = Device.DeviceType.valueOf((String)config.getDeviceType().name());
        Integer n = adbPort;
        Integer n2 = consolePort;
        AndroidDeviceProperties androidDeviceProperties = new AndroidDeviceProperties(null, null, null, null, null, null, null, environment.getAndroidLogcatOptions(), null, 383, null);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"host");
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"serial");
        return new AndroidDevice(string5, string6, deviceType, n, androidDeviceProperties, n2, adbServerPort);
    }
}

