/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.platform.runtime.android.controller;

import com.google.auto.service.AutoService;
import com.google.common.annotations.VisibleForTesting;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.testing.platform.api.config.AndroidSdk;
import com.google.testing.platform.api.config.Config;
import com.google.testing.platform.api.config.Configurable;
import com.google.testing.platform.api.config.Environment;
import com.google.testing.platform.api.config.Setup;
import com.google.testing.platform.api.context.Context;
import com.google.testing.platform.api.context.ContextExtKt;
import com.google.testing.platform.api.device.CommandHandle;
import com.google.testing.platform.api.device.CommandResult;
import com.google.testing.platform.api.device.Device;
import com.google.testing.platform.api.device.DeviceController;
import com.google.testing.platform.core.device.inject.DeviceControllerComponent;
import com.google.testing.platform.core.telemetry.SequentialEventRecordRequest;
import com.google.testing.platform.core.telemetry.Telemetry;
import com.google.testing.platform.core.telemetry.TelemetryKt;
import com.google.testing.platform.core.telemetry.core.DiagnosticScope;
import com.google.testing.platform.lib.adb.command.inject.AdbCommandComponent;
import com.google.testing.platform.lib.adb.command.inject.AdbCommands;
import com.google.testing.platform.lib.adb.command.inject.AdbConfig;
import com.google.testing.platform.lib.adb.command.inject.AdbTimeout;
import com.google.testing.platform.lib.adb.command.inject.CommandComponent;
import com.google.testing.platform.lib.adb.command.inject.DaggerAdbCommandComponent;
import com.google.testing.platform.proto.api.config.AdbConfigProto;
import com.google.testing.platform.proto.api.config.RuntimeProto;
import com.google.testing.platform.proto.api.core.ArtifactKt;
import com.google.testing.platform.proto.api.core.LogMessageProto;
import com.google.testing.platform.proto.api.core.PathKt;
import com.google.testing.platform.proto.api.core.PathProto;
import com.google.testing.platform.proto.api.core.PhaseProto;
import com.google.testing.platform.proto.api.core.TestArtifactProto;
import com.google.testing.platform.runtime.android.config.AndroidDeviceControllerConfig;
import com.google.testing.platform.runtime.android.controller.AndroidDeviceController;
import com.google.testing.platform.runtime.android.controller.ext.AndroidDeviceControllerExtKt;
import com.google.testing.platform.runtime.android.device.AndroidDevice;
import com.google.testing.platform.runtime.android.device.AndroidDeviceProperties;
import com.google.testing.platform.runtime.android.inject.AndroidDeviceControllerComponent;
import com.google.testing.platform.runtime.android.inject.DaggerAndroidDeviceControllerComponent;
import com.google.testing.platform.runtime.android.logcat.DefaultLogcatReader;
import com.google.testing.platform.runtime.android.logcat.LogcatReader;
import java.io.File;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 B2\u00020\u00012\u00020\u0002:\u0001BB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\n\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'H\u0002J\u001c\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020*0)H\u0002J\u0010\u0010,\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020'H\u0002J \u0010-\u001a\u00020.2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020*0)2\b\u0010/\u001a\u0004\u0018\u000100H\u0017J*\u00101\u001a\u0002022\f\u0010+\u001a\b\u0012\u0004\u0012\u00020*0)2\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020\u001d04H\u0016J\u0014\u00105\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020*06H\u0002J\b\u00107\u001a\u00020\u0013H\u0016J\u0010\u00108\u001a\u00020.2\u0006\u00109\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020<2\u0006\u00109\u001a\u00020:H\u0016J\u0010\u0010=\u001a\u00020<2\u0006\u00109\u001a\u00020:H\u0016J\u0010\u0010>\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'H\u0016J\u000e\u0010?\u001a\b\u0012\u0004\u0012\u00020A0@H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/google/testing/platform/runtime/android/controller/AndroidDeviceController;", "Lcom/google/testing/platform/api/device/DeviceController;", "Lcom/google/testing/platform/api/config/Configurable;", "()V", "adbCommands", "Lcom/google/testing/platform/lib/adb/command/inject/AdbCommands;", "getAdbCommands", "()Lcom/google/testing/platform/lib/adb/command/inject/AdbCommands;", "setAdbCommands", "(Lcom/google/testing/platform/lib/adb/command/inject/AdbCommands;)V", "adbConfig", "Lcom/google/testing/platform/proto/api/config/AdbConfigProto$AdbConfig;", "adbTimeout", "Lcom/google/testing/platform/lib/adb/command/inject/AdbTimeout;", "androidDeviceControllerComponentBuilder", "Lcom/google/testing/platform/runtime/android/inject/AndroidDeviceControllerComponent$Builder;", "androidSdk", "Lcom/google/testing/platform/api/config/AndroidSdk;", "controlledDevice", "Lcom/google/testing/platform/runtime/android/device/AndroidDevice;", "environment", "Lcom/google/testing/platform/api/config/Environment;", "instrumentationRuntimeConfig", "Lcom/google/testing/platform/proto/api/config/RuntimeProto$AndroidInstrumentationRuntime;", "logcatReader", "Lcom/google/testing/platform/runtime/android/logcat/LogcatReader;", "testSetup", "Lcom/google/testing/platform/api/config/Setup;", "configAdbCommands", "", "Lcom/google/testing/platform/lib/adb/command/inject/AdbConfig;", "configDeviceProperties", "originalProperties", "Lcom/google/testing/platform/runtime/android/device/AndroidDeviceProperties;", "configure", "context", "Lcom/google/testing/platform/api/context/Context;", "configureLogcatReader", "device", "Lcom/google/testing/platform/api/device/Device;", "convertCommandToShellScriptIfNecessary", "", "", "args", "createAdbConfig", "execute", "Lcom/google/testing/platform/api/device/CommandResult;", "timeout", "Ljava/time/Duration;", "executeAsync", "Lcom/google/testing/platform/api/device/CommandHandle;", "processor", "Lkotlin/Function1;", "getAndroidDevicePropertiesMap", "", "getDevice", "install", "artifact", "Lcom/google/testing/platform/proto/api/core/TestArtifactProto$Artifact;", "pull", "", "push", "setDevice", "streamLogs", "Lkotlinx/coroutines/flow/Flow;", "Lcom/google/testing/platform/proto/api/core/LogMessageProto$LogMessage;", "Companion", "java_com_google_testing_platform_runtime_android_controller-android_device_controller"})
@AutoService(value={DeviceController.class})
public final class AndroidDeviceController
implements DeviceController,
Configurable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public AdbCommands adbCommands;
    private AdbTimeout adbTimeout;
    private AndroidDevice controlledDevice;
    private Environment environment;
    private Setup testSetup;
    private AndroidSdk androidSdk;
    private AdbConfigProto.AdbConfig adbConfig;
    private RuntimeProto.AndroidInstrumentationRuntime instrumentationRuntimeConfig;
    @NotNull
    private AndroidDeviceControllerComponent.Builder androidDeviceControllerComponentBuilder;
    private LogcatReader logcatReader;
    private static final Duration DEFAULT_ADB_TIMEOUT = Duration.ofSeconds(120L);
    @NotNull
    private static final String SYSTEM_USER = "0";
    public static final int MAX_ADB_DEVICE_SHELL_COMMAND_LENGTH = 1018;
    @NotNull
    private static final String SHELL_BINARY = "/system/bin/sh";
    @NotNull
    private static final String DEVICE_SCRIPT_PREFIX = "run_command_";

    public AndroidDeviceController() {
        AndroidDeviceControllerComponent.Builder builder = DaggerAndroidDeviceControllerComponent.builder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder()");
        this.androidDeviceControllerComponentBuilder = builder;
    }

    @NotNull
    public final AdbCommands getAdbCommands() {
        AdbCommands adbCommands = this.adbCommands;
        if (adbCommands != null) {
            return adbCommands;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"adbCommands");
        return null;
    }

    public final void setAdbCommands(@NotNull AdbCommands adbCommands) {
        Intrinsics.checkNotNullParameter((Object)adbCommands, (String)"<set-?>");
        this.adbCommands = adbCommands;
    }

    public void configure(@NotNull Context context) {
        Duration duration;
        Duration duration2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Config config = ContextExtKt.getConfig(context);
        AndroidDeviceControllerConfig cfr_ignored_0 = (AndroidDeviceControllerConfig)config;
        this.environment = ((AndroidDeviceControllerConfig)config).getEnvironment();
        this.testSetup = ((AndroidDeviceControllerConfig)config).getSetup();
        this.androidSdk = ((AndroidDeviceControllerConfig)config).getAndroidSdk();
        this.adbConfig = ((AndroidDeviceControllerConfig)config).getAdbConfig();
        this.instrumentationRuntimeConfig = ((AndroidDeviceControllerConfig)config).getInstrumentation();
        AdbConfigProto.AdbConfig adbConfig = this.adbConfig;
        if (adbConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adbConfig");
            adbConfig = null;
        }
        if (adbConfig.getAdbTimeout().getDefaultAdbTimeout() <= 0L) {
            duration2 = DEFAULT_ADB_TIMEOUT;
        } else {
            AdbConfigProto.AdbConfig adbConfig2 = this.adbConfig;
            if (adbConfig2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"adbConfig");
                adbConfig2 = null;
            }
            duration2 = Duration.ofSeconds(adbConfig2.getAdbTimeout().getDefaultAdbTimeout());
        }
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"if (adbConfig.adbTimeout\u2026ltAdbTimeout)\n          }");
        AdbConfigProto.AdbConfig adbConfig3 = this.adbConfig;
        if (adbConfig3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adbConfig");
            adbConfig3 = null;
        }
        if (adbConfig3.getAdbTimeout().getInstallCmdTimeout() <= 0L) {
            duration = null;
        } else {
            AdbConfigProto.AdbConfig adbConfig4 = this.adbConfig;
            if (adbConfig4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"adbConfig");
                adbConfig4 = null;
            }
            duration = Duration.ofSeconds(adbConfig4.getAdbTimeout().getInstallCmdTimeout());
        }
        this.adbTimeout = new AdbTimeout(duration2, duration);
    }

    @NotNull
    public AndroidDevice getDevice() {
        AndroidDevice androidDevice = this.controlledDevice;
        if (androidDevice == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"controlledDevice");
            androidDevice = null;
        }
        return androidDevice;
    }

    public void setDevice(@NotNull Device device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        AndroidDeviceProperties originalProperties = ((AndroidDevice)device).getProperties();
        this.configAdbCommands(this.createAdbConfig(device));
        this.configDeviceProperties(originalProperties);
        this.configureLogcatReader(device);
    }

    @NotNull
    public Flow<LogMessageProto.LogMessage> streamLogs() {
        LogcatReader logcatReader = this.logcatReader;
        if (logcatReader == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logcatReader");
            logcatReader = null;
        }
        return logcatReader.getLogcatFlow();
    }

    private final AdbConfig createAdbConfig(Device device) {
        Environment environment;
        AdbTimeout adbTimeout;
        String string;
        Object object;
        AndroidDevice cfr_ignored_0 = (AndroidDevice)device;
        this.controlledDevice = (AndroidDevice)device;
        Environment environment2 = this.environment;
        if (environment2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"environment");
            environment2 = null;
        }
        String string2 = environment2.getTestLogDirectory();
        Environment environment3 = this.environment;
        if (environment3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"environment");
            environment3 = null;
        }
        String string3 = environment3.getTempDirectory();
        String string4 = device.getSerial();
        AdbConfigProto.AdbConfig adbConfig = this.adbConfig;
        if (adbConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adbConfig");
            adbConfig = null;
        }
        if (!((object = (CharSequence)adbConfig.getCustomAdbPath().getPath()) == null || StringsKt.isBlank((CharSequence)object))) {
            AdbConfigProto.AdbConfig adbConfig2 = this.adbConfig;
            if (adbConfig2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"adbConfig");
                adbConfig2 = null;
            }
            string = adbConfig2.getCustomAdbPath().getPath();
        } else {
            AndroidSdk androidSdk = this.androidSdk;
            if (androidSdk == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"androidSdk");
                androidSdk = null;
            }
            string = androidSdk.getAdbPath();
        }
        String string5 = string;
        object = ((AndroidDevice)device).getServerPort();
        String string6 = ((AndroidDevice)device).getHost();
        Integer n = device.getPort();
        Integer n2 = ((AndroidDevice)device).getEmulatorPort();
        AdbTimeout adbTimeout2 = this.adbTimeout;
        if (adbTimeout2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adbTimeout");
            adbTimeout2 = adbTimeout = null;
        }
        if ((environment = this.environment) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"environment");
            environment = null;
        }
        String string7 = environment.getTestLogDirectory();
        Environment environment4 = this.environment;
        if (environment4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"environment");
            environment4 = null;
        }
        String string8 = new File(string7, environment4.getTestRunLog()).getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"absolutePath");
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"if (!adbConfig.customAdb\u2026roidSdk.adbPath\n        }");
        return new AdbConfig(string2, string3, string8, string5, adbTimeout, string6, (Integer)object, n, n2, string4);
    }

    private final void configAdbCommands(AdbConfig adbConfig) {
        AndroidSdk androidSdk = this.androidSdk;
        if (androidSdk == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"androidSdk");
            androidSdk = null;
        }
        DeviceControllerComponent.Builder builder = this.androidDeviceControllerComponentBuilder.androidSdk(androidSdk);
        RuntimeProto.AndroidInstrumentationRuntime androidInstrumentationRuntime = this.instrumentationRuntimeConfig;
        if (androidInstrumentationRuntime == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"instrumentationRuntimeConfig");
            androidInstrumentationRuntime = null;
        }
        DeviceControllerComponent.Builder builder2 = builder.runtime(androidInstrumentationRuntime);
        Setup setup = this.testSetup;
        if (setup == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testSetup");
            setup = null;
        }
        AndroidDeviceControllerComponent.Builder androidDeviceControllerComponentBuilder = (AndroidDeviceControllerComponent.Builder)builder2.setup(setup);
        CommandComponent.Builder builder3 = DaggerAdbCommandComponent.builder().adbConfig(adbConfig);
        AndroidSdk androidSdk2 = this.androidSdk;
        if (androidSdk2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"androidSdk");
            androidSdk2 = null;
        }
        AdbCommandComponent adbCommandComponent = (AdbCommandComponent)builder3.androidSdk(androidSdk2).build();
        this.setAdbCommands(((AndroidDeviceControllerComponent)androidDeviceControllerComponentBuilder.commandComponent(adbCommandComponent).build()).getAdbCommands());
    }

    private final void configureLogcatReader(Device device) {
        this.logcatReader = new DefaultLogcatReader(this.getAdbCommands(), device);
    }

    private final void configDeviceProperties(AndroidDeviceProperties originalProperties) {
        String user2 = (String)TelemetryKt.createEvent((Telemetry)Telemetry.INSTANCE, (String)"GetUser", (Function1)((Function1)new Function1<SequentialEventRecordRequest<String>, Unit>(this){
            final /* synthetic */ AndroidDeviceController this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull SequentialEventRecordRequest<String> $this$createEvent) {
                Intrinsics.checkNotNullParameter($this$createEvent, (String)"$this$createEvent");
                $this$createEvent.setPhase(PhaseProto.TestPhase.SETUP);
                $this$createEvent.run((Function1)new Function1<DiagnosticScope, String>(this.this$0){
                    final /* synthetic */ AndroidDeviceController this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final String invoke(@NotNull DiagnosticScope $this$run) {
                        Intrinsics.checkNotNullParameter((Object)$this$run, (String)"$this$run");
                        Object[] objectArray = new String[]{"am", "get-current-user"};
                        return (String)CollectionsKt.first((List)AndroidDeviceControllerExtKt.deviceShell$default(this.this$0, CollectionsKt.listOf((Object[])objectArray), null, 2, null).getOutput());
                    }
                });
            }
        })).getOrThrow();
        AndroidDevice androidDevice = this.controlledDevice;
        if (androidDevice == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"controlledDevice");
            androidDevice = null;
        }
        androidDevice.setProperties((AndroidDeviceProperties)TelemetryKt.createEvent((Telemetry)Telemetry.INSTANCE, (String)"GetDeviceProperties", (Function1)((Function1)new Function1<SequentialEventRecordRequest<AndroidDeviceProperties>, Unit>(this, originalProperties, user2){
            final /* synthetic */ AndroidDeviceController this$0;
            final /* synthetic */ AndroidDeviceProperties $originalProperties;
            final /* synthetic */ String $user;
            {
                this.this$0 = $receiver;
                this.$originalProperties = $originalProperties;
                this.$user = $user;
                super(1);
            }

            public final void invoke(@NotNull SequentialEventRecordRequest<AndroidDeviceProperties> $this$createEvent) {
                Intrinsics.checkNotNullParameter($this$createEvent, (String)"$this$createEvent");
                $this$createEvent.setPhase(PhaseProto.TestPhase.SETUP);
                $this$createEvent.setOnComplete((Function1)configDeviceProperties.1.INSTANCE);
                $this$createEvent.run((Function1)new Function1<DiagnosticScope, AndroidDeviceProperties>(this.this$0, this.$originalProperties, this.$user){
                    final /* synthetic */ AndroidDeviceController this$0;
                    final /* synthetic */ AndroidDeviceProperties $originalProperties;
                    final /* synthetic */ String $user;
                    {
                        this.this$0 = $receiver;
                        this.$originalProperties = $originalProperties;
                        this.$user = $user;
                        super(1);
                    }

                    @NotNull
                    public final AndroidDeviceProperties invoke(@NotNull DiagnosticScope $this$run) {
                        AndroidDeviceProperties androidDeviceProperties;
                        String string;
                        Intrinsics.checkNotNullParameter((Object)$this$run, (String)"$this$run");
                        Map propMap = AndroidDeviceController.access$getAndroidDevicePropertiesMap(this.this$0);
                        AndroidDevice androidDevice = AndroidDeviceController.access$getControlledDevice$p(this.this$0);
                        if (androidDevice == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"controlledDevice");
                            androidDevice = null;
                        }
                        if (androidDevice.getType() == Device.DeviceType.VIRTUAL) {
                            AdbTimeout adbTimeout = AndroidDeviceController.access$getAdbTimeout$p(this.this$0);
                            if (adbTimeout == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"adbTimeout");
                                adbTimeout = null;
                            }
                            string = this.this$0.getAdbCommands().getGetAvdName().get().execute(adbTimeout.getDefaultTimeout());
                        } else {
                            string = null;
                        }
                        String avdName = string;
                        Object object = this.$originalProperties.getLogcatOptions();
                        AndroidDeviceProperties props = new AndroidDeviceProperties(propMap, null, null, null, null, null, avdName, (List)object, this.$user, 62, null);
                        if (!Intrinsics.areEqual((Object)this.$user, (Object)"0") && Integer.parseInt(props.getDeviceApiLevel()) >= 30) {
                            object = "/mnt/pass_through/" + this.$user + "/emulated/" + this.$user + '/';
                            List list = this.$originalProperties.getLogcatOptions();
                            androidDeviceProperties = new AndroidDeviceProperties(propMap, null, null, null, null, (String)object, avdName, list, this.$user, 30, null);
                        } else if (!Intrinsics.areEqual((Object)this.$user, (Object)"0") && Integer.parseInt(props.getDeviceApiLevel()) >= 28) {
                            object = "/storage/emulated/" + this.$user;
                            List list = this.$originalProperties.getLogcatOptions();
                            androidDeviceProperties = new AndroidDeviceProperties(propMap, null, null, null, null, (String)object, avdName, list, this.$user, 30, null);
                        } else {
                            androidDeviceProperties = props;
                        }
                        return androidDeviceProperties;
                    }
                });
            }
        })).getOrThrow());
    }

    private final Map<String, String> getAndroidDevicePropertiesMap() {
        AdbTimeout adbTimeout = this.adbTimeout;
        if (adbTimeout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adbTimeout");
            adbTimeout = null;
        }
        Map<String, String> map2 = this.getAdbCommands().getGetDeviceEnvVariables().get().execute(adbTimeout.getDefaultTimeout()).getEnvironmentVars();
        AdbTimeout adbTimeout2 = this.adbTimeout;
        if (adbTimeout2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adbTimeout");
            adbTimeout2 = null;
        }
        return MapsKt.plus(map2, this.getAdbCommands().getGetDeviceProperties().get().execute(adbTimeout2.getDefaultTimeout()).getDeviceProperties());
    }

    @NotNull
    public CommandResult install(@NotNull TestArtifactProto.Artifact artifact) {
        Duration duration;
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        if (!(TestArtifactProto.ArtifactType.ANDROID_APK == artifact.getType())) {
            boolean $i$a$-require-AndroidDeviceController$install$32 = false;
            String $i$a$-require-AndroidDeviceController$install$32 = "Artifact needs to be of type: " + TestArtifactProto.ArtifactType.ANDROID_APK + ", but was " + artifact.getType();
            throw new IllegalArgumentException($i$a$-require-AndroidDeviceController$install$32.toString());
        }
        if (!artifact.hasSourcePath()) {
            boolean bl = false;
            String string = "Artifact source path needs to be set!";
            throw new IllegalArgumentException(string.toString());
        }
        String string = artifact.getSourcePath().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"artifact.sourcePath.path");
        AdbTimeout adbTimeout = this.adbTimeout;
        if (adbTimeout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adbTimeout");
            adbTimeout = null;
        }
        if ((duration = adbTimeout.getInstallCmdTimeout()) == null) {
            AdbTimeout adbTimeout2 = this.adbTimeout;
            if (adbTimeout2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"adbTimeout");
                adbTimeout2 = null;
            }
            duration = adbTimeout2.getDefaultTimeout();
        }
        return this.getAdbCommands().getInstallApkOnDevice().get().execute(string, duration, AndroidDeviceControllerExtKt.getExtraInstallOptions$default(this, false, false, true, true, 3, null));
    }

    @CanIgnoreReturnValue
    @NotNull
    public CommandResult execute(@NotNull List<String> args, @Nullable Duration timeout) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Duration duration = timeout;
        if (duration == null) {
            AdbTimeout adbTimeout = this.adbTimeout;
            if (adbTimeout == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"adbTimeout");
                adbTimeout = null;
            }
            duration = adbTimeout.getDefaultTimeout();
        }
        Duration cmdTimeout = duration;
        CommandResult result = this.getAdbCommands().getCommand().get().execute(this.convertCommandToShellScriptIfNecessary(args), cmdTimeout);
        return new CommandResult(result.getStatusCode(), result.getByteOutput());
    }

    @NotNull
    public CommandHandle executeAsync(@NotNull List<String> args, @NotNull Function1<? super String, Unit> processor) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        return this.getAdbCommands().getAsyncCommand().get().execute(this.convertCommandToShellScriptIfNecessary(args), processor);
    }

    public int push(@NotNull TestArtifactProto.Artifact artifact) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        if (!(artifact.hasSourcePath() && artifact.hasDestinationPath())) {
            boolean bl = false;
            String string = "Artifact source and destination paths need to be set!";
            throw new IllegalArgumentException(string.toString());
        }
        String string = artifact.getSourcePath().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"artifact.sourcePath.path");
        String string2 = artifact.getDestinationPath().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"artifact.destinationPath.path");
        AdbTimeout adbTimeout = this.adbTimeout;
        if (adbTimeout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adbTimeout");
            adbTimeout = null;
        }
        return this.getAdbCommands().getPushToDevice().get().execute(string, string2, adbTimeout.getDefaultTimeout());
    }

    public int pull(@NotNull TestArtifactProto.Artifact artifact) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        if (!(artifact.hasSourcePath() && artifact.hasDestinationPath())) {
            boolean bl = false;
            String string = "Artifact source and destination paths need to be set!";
            throw new IllegalArgumentException(string.toString());
        }
        String string = artifact.getDestinationPath().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"artifact.destinationPath.path");
        String string2 = artifact.getSourcePath().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"artifact.sourcePath.path");
        AdbTimeout adbTimeout = this.adbTimeout;
        if (adbTimeout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adbTimeout");
            adbTimeout = null;
        }
        return this.getAdbCommands().getPullFromDevice().get().execute(string, string2, adbTimeout.getDefaultTimeout());
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> convertCommandToShellScriptIfNecessary(List<String> args) {
        void $this$convertCommandToShellScriptIfNecessary_u24lambda_u2d7_u24lambda_u2d6;
        PathKt.Dsl $this$convertCommandToShellScriptIfNecessary_u24lambda_u2d7_u24lambda_u2d5;
        PathKt.Dsl dsl;
        ArtifactKt.Dsl dsl2;
        File file;
        if (!Intrinsics.areEqual((Object)args.get(0), (Object)"shell")) {
            return args;
        }
        String fullCommand = CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)args, (int)1), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        if (fullCommand.length() < 1018) {
            return args;
        }
        Environment environment = this.environment;
        if (environment == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"environment");
            environment = null;
        }
        File it = file = File.createTempFile(DEVICE_SCRIPT_PREFIX, ".sh", new File(environment.getTempDirectory()));
        boolean bl = false;
        it.deleteOnExit();
        File localScript = file;
        Intrinsics.checkNotNullExpressionValue((Object)localScript, (String)"localScript");
        FilesKt.writeText$default((File)localScript, (String)fullCommand, null, (int)2, null);
        StringBuilder stringBuilder = new StringBuilder();
        AndroidDevice androidDevice = this.controlledDevice;
        if (androidDevice == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"controlledDevice");
            androidDevice = null;
        }
        String devicePath = stringBuilder.append(androidDevice.getProperties().getExternalStorageDir()).append('/').append(localScript.getName()).toString();
        boolean bl2 = false;
        TestArtifactProto.Artifact.Builder builder = TestArtifactProto.Artifact.newBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder()");
        ArtifactKt.Dsl $this$artifact_u24lambda_u2d0$iv = dsl2 = ArtifactKt.Dsl.Companion._create(builder);
        boolean bl3 = false;
        ArtifactKt.Dsl $this$convertCommandToShellScriptIfNecessary_u24lambda_u2d7 = $this$artifact_u24lambda_u2d0$iv;
        boolean bl4 = false;
        boolean bl5 = false;
        PathProto.Path.Builder builder2 = PathProto.Path.newBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"newBuilder()");
        PathKt.Dsl $this$path_u24lambda_u2d0$iv = dsl = PathKt.Dsl.Companion._create(builder2);
        boolean bl6 = false;
        PathKt.Dsl dsl3 = $this$path_u24lambda_u2d0$iv;
        ArtifactKt.Dsl dsl4 = $this$convertCommandToShellScriptIfNecessary_u24lambda_u2d7;
        boolean bl7 = false;
        String string = localScript.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"localScript.absolutePath");
        $this$convertCommandToShellScriptIfNecessary_u24lambda_u2d7_u24lambda_u2d5.setPath(string);
        dsl4.setSourcePath(dsl._build());
        bl5 = false;
        PathProto.Path.Builder builder3 = PathProto.Path.newBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"newBuilder()");
        $this$path_u24lambda_u2d0$iv = dsl = PathKt.Dsl.Companion._create(builder3);
        bl6 = false;
        $this$convertCommandToShellScriptIfNecessary_u24lambda_u2d7_u24lambda_u2d5 = $this$path_u24lambda_u2d0$iv;
        dsl4 = $this$convertCommandToShellScriptIfNecessary_u24lambda_u2d7;
        boolean bl8 = false;
        $this$convertCommandToShellScriptIfNecessary_u24lambda_u2d7_u24lambda_u2d6.setPath(devicePath);
        dsl4.setDestinationPath(dsl._build());
        TestArtifactProto.Artifact tempArtifact = dsl2._build();
        this.push(tempArtifact);
        Object[] objectArray = new String[]{"shell", SHELL_BINARY, devicePath};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public static final /* synthetic */ Map access$getAndroidDevicePropertiesMap(AndroidDeviceController $this) {
        return $this.getAndroidDevicePropertiesMap();
    }

    public static final /* synthetic */ AndroidDevice access$getControlledDevice$p(AndroidDeviceController $this) {
        return $this.controlledDevice;
    }

    public static final /* synthetic */ AdbTimeout access$getAdbTimeout$p(AndroidDeviceController $this) {
        return $this.adbTimeout;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u00020\u00078\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\u0002\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/google/testing/platform/runtime/android/controller/AndroidDeviceController$Companion;", "", "()V", "DEFAULT_ADB_TIMEOUT", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "DEVICE_SCRIPT_PREFIX", "", "getDEVICE_SCRIPT_PREFIX$annotations", "getDEVICE_SCRIPT_PREFIX", "()Ljava/lang/String;", "MAX_ADB_DEVICE_SHELL_COMMAND_LENGTH", "", "SHELL_BINARY", "SYSTEM_USER", "java_com_google_testing_platform_runtime_android_controller-android_device_controller"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getDEVICE_SCRIPT_PREFIX() {
            return DEVICE_SCRIPT_PREFIX;
        }

        @VisibleForTesting
        public static /* synthetic */ void getDEVICE_SCRIPT_PREFIX$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

