/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.platform.lib.process.logger;

import com.google.common.annotations.VisibleForTesting;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.google.testing.platform.lib.process.logger.SubprocessLogger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001c\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0016H\u0002J\u0016\u0010\u0017\u001a\u00020\u00032\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u0019H\u0016J*\u0010\u001a\u001a\u00020\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u00192\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0016H\u0016J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u0003H\u0016R\u0012\u0010\u0007\u001a\u00020\b8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/google/testing/platform/lib/process/logger/DefaultSubprocessLogger;", "Lcom/google/testing/platform/lib/process/logger/SubprocessLogger;", "logDir", "", "flushEagerly", "", "(Ljava/lang/String;Z)V", "bufferedWriter", "Ljava/io/BufferedWriter;", "duration", "Ljava/time/Duration;", "endTime", "Ljava/time/Instant;", "logFile", "Ljava/io/File;", "startTime", "finishLogging", "exitCode", "", "formatEnvironmentMap", "", "envMap", "", "getLogPrefix", "args", "", "startLogging", "environment", "writeLine", "line", "Companion", "lib_java_com_google_testing_platform_lib_process_logger-subprocess_logger"})
public final class DefaultSubprocessLogger
implements SubprocessLogger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String logDir;
    private final boolean flushEagerly;
    @GuardedBy(value="this")
    private BufferedWriter bufferedWriter;
    private File logFile;
    private Instant startTime;
    private Instant endTime;
    private Duration duration;
    @NotNull
    private static final AtomicInteger COMMAND_COUNT = new AtomicInteger(0);
    private static final DateTimeFormatter DATETIME_PATTERN = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS").withZone(ZoneId.systemDefault());
    private static final DateTimeFormatter DATETIME_PATTERN_NANO = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSSSSS").withZone(ZoneId.systemDefault());
    private static final String LINE_SEPARATOR = System.lineSeparator();

    @Inject
    public DefaultSubprocessLogger(@NotNull String logDir, boolean flushEagerly) {
        Intrinsics.checkNotNullParameter((Object)logDir, (String)"logDir");
        this.logDir = logDir;
        this.flushEagerly = flushEagerly;
    }

    public /* synthetic */ DefaultSubprocessLogger(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(string, bl);
    }

    @Override
    public synchronized void startLogging(@NotNull List<String> args, @NotNull Map<String, String> environment) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter(environment, (String)"environment");
        Files.createDirectories(Paths.get(this.logDir, new String[0]), new FileAttribute[0]);
        String logFilePrefix = this.getLogPrefix(args);
        Object object = new String[]{logFilePrefix + '.' + COMMAND_COUNT.incrementAndGet() + ".txt"};
        File file = Paths.get(this.logDir, object).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"get(logDir, \"$logFilePre\u2026tAndGet()}.txt\").toFile()");
        this.logFile = file;
        File file2 = this.logFile;
        if (file2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logFile");
            file2 = null;
        }
        Object object2 = file2;
        object2 = new FileOutputStream((File)object2);
        object = Charsets.UTF_8;
        Writer writer = new OutputStreamWriter((OutputStream)object2, (Charset)object);
        int n = 8192;
        this.bufferedWriter = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n);
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        this.startTime = instant;
        BufferedWriter bufferedWriter = this.bufferedWriter;
        if (bufferedWriter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bufferedWriter");
            bufferedWriter = null;
        }
        StringBuilder stringBuilder = new StringBuilder().append("EXECUTING: ").append(CollectionsKt.joinToString$default((Iterable)args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)).append(LINE_SEPARATOR).append("CURRENT_WORKING_DIRECTORY: ").append(System.getProperty("user.dir")).append(LINE_SEPARATOR).append("START_TIME: ");
        Instant instant2 = this.startTime;
        if (instant2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"startTime");
            instant2 = null;
        }
        StringBuilder stringBuilder2 = stringBuilder.append(DATETIME_PATTERN.format(instant2)).append(LINE_SEPARATOR).append("START_TIME-NANOS: ");
        Instant instant3 = this.startTime;
        if (instant3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"startTime");
            instant3 = null;
        }
        bufferedWriter.write(stringBuilder2.append(DATETIME_PATTERN_NANO.format(instant3)).append(LINE_SEPARATOR).toString());
        this.formatEnvironmentMap(environment);
        BufferedWriter bufferedWriter2 = this.bufferedWriter;
        if (bufferedWriter2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bufferedWriter");
            bufferedWriter2 = null;
        }
        bufferedWriter2.flush();
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized void formatEnvironmentMap(Map<String, String> envMap) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        BufferedWriter bufferedWriter = this.bufferedWriter;
        if (bufferedWriter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bufferedWriter");
            bufferedWriter = null;
        }
        Iterable iterable = MapsKt.toList(envMap);
        StringBuilder stringBuilder = new StringBuilder().append("ENVIRONMENT:").append(LINE_SEPARATOR);
        BufferedWriter bufferedWriter2 = bufferedWriter;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it.getFirst() + '=' + (String)it.getSecond());
        }
        collection = (List)destination$iv$iv;
        Iterable iterable2 = collection;
        String string = LINE_SEPARATOR;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"LINE_SEPARATOR");
        bufferedWriter2.write(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)iterable2, (CharSequence)string, null, null, (int)0, null, null, (int)62, null)).append(LINE_SEPARATOR).append("*****************************************").append(LINE_SEPARATOR).append("STDOUT/STDERR BELOW").append(LINE_SEPARATOR).append("===================").append(LINE_SEPARATOR).toString());
    }

    @Override
    public synchronized void writeLine(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        BufferedWriter bufferedWriter = this.bufferedWriter;
        if (bufferedWriter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bufferedWriter");
            bufferedWriter = null;
        }
        bufferedWriter.write(line + LINE_SEPARATOR);
        if (this.flushEagerly) {
            BufferedWriter bufferedWriter2 = this.bufferedWriter;
            if (bufferedWriter2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bufferedWriter");
                bufferedWriter2 = null;
            }
            bufferedWriter2.flush();
        }
    }

    @Override
    @NotNull
    public synchronized String finishLogging(int exitCode) {
        File file;
        String suffix;
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        this.endTime = instant;
        Instant instant2 = this.startTime;
        if (instant2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"startTime");
            instant2 = null;
        }
        Temporal temporal = instant2;
        Instant instant3 = this.endTime;
        if (instant3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"endTime");
            instant3 = null;
        }
        Duration duration = Duration.between(temporal, instant3);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"between(startTime, endTime)");
        this.duration = duration;
        BufferedWriter bufferedWriter = this.bufferedWriter;
        if (bufferedWriter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bufferedWriter");
            bufferedWriter = null;
        }
        StringBuilder stringBuilder = new StringBuilder().append("===================").append(LINE_SEPARATOR).append("END_TIME: ");
        Instant instant4 = this.endTime;
        if (instant4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"endTime");
            instant4 = null;
        }
        StringBuilder stringBuilder2 = stringBuilder.append(DATETIME_PATTERN.format(instant4)).append(LINE_SEPARATOR).append("END_TIME-NANOS: ");
        Instant instant5 = this.endTime;
        if (instant5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"endTime");
            instant5 = null;
        }
        StringBuilder stringBuilder3 = stringBuilder2.append(DATETIME_PATTERN_NANO.format(instant5)).append(LINE_SEPARATOR).append("DURATION: ");
        Duration duration2 = this.duration;
        if (duration2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"duration");
            duration2 = null;
        }
        bufferedWriter.write(stringBuilder3.append(duration2.toMillis()).append("ms").append(LINE_SEPARATOR).append("EXIT CODE: ").append(exitCode).append(LINE_SEPARATOR).toString());
        BufferedWriter bufferedWriter2 = this.bufferedWriter;
        if (bufferedWriter2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bufferedWriter");
            bufferedWriter2 = null;
        }
        bufferedWriter2.flush();
        BufferedWriter bufferedWriter3 = this.bufferedWriter;
        if (bufferedWriter3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bufferedWriter");
            bufferedWriter3 = null;
        }
        bufferedWriter3.close();
        switch (exitCode) {
            case 0: {
                String string = ".ok.txt";
                break;
            }
            case 143: {
                String string = ".aborted.txt";
                break;
            }
            default: {
                String string = suffix = ".fail.txt";
            }
        }
        if ((file = this.logFile) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logFile");
            file = null;
        }
        String string = file.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"logFile.absolutePath");
        CharSequence charSequence = string;
        String newName = new Regex(".txt$").replace(charSequence, suffix);
        File it = new File(newName);
        boolean bl = false;
        File file2 = this.logFile;
        if (file2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logFile");
            file2 = null;
        }
        file2.renameTo(it);
        String string2 = it.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.absolutePath");
        return string2;
    }

    @Override
    @NotNull
    public String getLogPrefix(@NotNull List<String> args) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        CharSequence charSequence = (CharSequence)CollectionsKt.first(args);
        String[] stringArray = new String[1];
        Intrinsics.checkNotNullExpressionValue((Object)File.separator, (String)"separator");
        return (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \n*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/google/testing/platform/lib/process/logger/DefaultSubprocessLogger$Companion;", "", "()V", "COMMAND_COUNT", "Ljava/util/concurrent/atomic/AtomicInteger;", "getCOMMAND_COUNT$annotations", "getCOMMAND_COUNT", "()Ljava/util/concurrent/atomic/AtomicInteger;", "DATETIME_PATTERN", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "DATETIME_PATTERN_NANO", "LINE_SEPARATOR", "", "lib_java_com_google_testing_platform_lib_process_logger-subprocess_logger"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AtomicInteger getCOMMAND_COUNT() {
            return COMMAND_COUNT;
        }

        @VisibleForTesting
        public static /* synthetic */ void getCOMMAND_COUNT$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

