/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.platform.lib.adb.command.subprocess.executor;

import com.google.testing.platform.api.config.AndroidSdk;
import com.google.testing.platform.api.device.CommandHandle;
import com.google.testing.platform.api.device.CommandResult;
import com.google.testing.platform.lib.adb.command.AdbCommandException;
import com.google.testing.platform.lib.adb.command.AdbTimeoutException;
import com.google.testing.platform.lib.adb.command.CommandExecutor;
import com.google.testing.platform.lib.adb.command.inject.AdbConfig;
import com.google.testing.platform.lib.adb.command.subprocess.executor.CommandHandleImpl;
import com.google.testing.platform.lib.logging.jvm.LoggerExtKt;
import com.google.testing.platform.lib.process.Handle;
import com.google.testing.platform.lib.process.Subprocess;
import com.google.testing.platform.lib.process.inject.DaggerSubprocessComponent;
import com.google.testing.platform.lib.process.inject.SubprocessComponent;
import com.google.testing.platform.lib.process.logger.SubprocessLoggerFactory;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.ExperimentalCoroutinesApi;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0017\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ#\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J/\u0010\u0014\u001a\u00020\u00152\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00180\u0017H\u0016\u00a2\u0006\u0002\u0010\u0019J!\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u001b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010H\u0002\u00a2\u0006\u0002\u0010\u001cR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/google/testing/platform/lib/adb/command/subprocess/executor/AdbCommandExecutor;", "Lcom/google/testing/platform/lib/adb/command/CommandExecutor;", "config", "Lcom/google/testing/platform/lib/adb/command/inject/AdbConfig;", "androidSdk", "Lcom/google/testing/platform/api/config/AndroidSdk;", "(Lcom/google/testing/platform/lib/adb/command/inject/AdbConfig;Lcom/google/testing/platform/api/config/AndroidSdk;)V", "subprocessComponent", "Lcom/google/testing/platform/lib/process/inject/SubprocessComponent;", "(Lcom/google/testing/platform/lib/adb/command/inject/AdbConfig;Lcom/google/testing/platform/api/config/AndroidSdk;Lcom/google/testing/platform/lib/process/inject/SubprocessComponent;)V", "environmentVariables", "", "", "execute", "Lcom/google/testing/platform/api/device/CommandResult;", "commandArgs", "", "timeout", "Ljava/time/Duration;", "([Ljava/lang/String;Ljava/time/Duration;)Lcom/google/testing/platform/api/device/CommandResult;", "executeAsync", "Lcom/google/testing/platform/api/device/CommandHandle;", "processor", "Lkotlin/Function1;", "", "([Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Lcom/google/testing/platform/api/device/CommandHandle;", "setUpArgs", "", "([Ljava/lang/String;)Ljava/util/List;", "Companion", "lib_java_com_google_testing_platform_lib_adb_command_subprocess_executor-adb_command_executor"})
@ExperimentalCoroutinesApi
public final class AdbCommandExecutor
implements CommandExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AdbConfig config;
    @NotNull
    private final AndroidSdk androidSdk;
    @NotNull
    private final SubprocessComponent subprocessComponent;
    @NotNull
    private Map<String, String> environmentVariables;
    @NotNull
    private static final Logger logger = LoggerExtKt.getLogger(Companion);
    @NotNull
    private static final String ANDROID_SDK_HOME = "ANDROID_SDK_HOME";
    @NotNull
    private static final String ANDROID_ADB = "ANDROID_ADB";

    public AdbCommandExecutor(@NotNull AdbConfig config, @NotNull AndroidSdk androidSdk, @NotNull SubprocessComponent subprocessComponent) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)androidSdk, (String)"androidSdk");
        Intrinsics.checkNotNullParameter((Object)subprocessComponent, (String)"subprocessComponent");
        this.config = config;
        this.androidSdk = androidSdk;
        this.subprocessComponent = subprocessComponent;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)ANDROID_SDK_HOME, (Object)this.androidSdk.getSdkPath()), TuplesKt.to((Object)ANDROID_ADB, (Object)this.androidSdk.getAdbPath())};
        this.environmentVariables = MapsKt.mapOf((Pair[])pairArray);
    }

    @Inject
    public AdbCommandExecutor(@NotNull AdbConfig config, @NotNull AndroidSdk androidSdk) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)androidSdk, (String)"androidSdk");
        this(config, androidSdk, DaggerSubprocessComponent.builder().subprocessLoggerFactory(new SubprocessLoggerFactory.AdbSubprocessLoggerFactory(config.getOutputDirectory(), false, 2, null)).build());
    }

    private final List<String> setUpArgs(String[] commandArgs) {
        Object object = new String[]{this.config.getAdbPath()};
        List args = CollectionsKt.mutableListOf((Object[])object);
        object = this.config.getAdbServerHost();
        if (!(object == null || object.length() == 0)) {
            Collection collection = args;
            object = new String[2];
            object[0] = "-H";
            Intrinsics.checkNotNull((Object)this.config.getAdbServerHost());
            CollectionsKt.addAll((Collection)collection, (Object[])object);
        }
        if (this.config.getAdbServerPort() != null) {
            object = new String[]{"-P", String.valueOf(this.config.getAdbServerPort())};
            CollectionsKt.addAll((Collection)args, (Object[])object);
        }
        CollectionsKt.addAll((Collection)args, (Object[])commandArgs);
        return args;
    }

    @Override
    @NotNull
    public CommandResult execute(@NotNull String[] commandArgs, @NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)commandArgs, (String)"commandArgs");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        List<String> args = this.setUpArgs(commandArgs);
        logger.fine("Executing Adb command: " + args);
        try {
            CommandResult commandResult;
            Subprocess processHandler = this.subprocessComponent.subprocess();
            CommandResult it = commandResult = processHandler.execute(args, this.environmentVariables, timeout);
            boolean bl = false;
            if (it.getStatusCode() != 0) {
                logger.warning(StringsKt.trimMargin$default((String)("Adb call failed.\n            |Exit code: " + it.getStatusCode() + "\n            |Command: " + CollectionsKt.joinToString$default((Iterable)args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + "\n            |Timeout: " + timeout), null, (int)1, null));
            }
            return commandResult;
        }
        catch (TimeoutException exception) {
            throw new AdbTimeoutException(StringsKt.trimMargin$default((String)("Adb command timed out.\n      |Command: " + CollectionsKt.joinToString$default((Iterable)args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + "\n      |Timeout: " + timeout + "\n      |Message: " + exception.getMessage()), null, (int)1, null));
        }
        catch (Exception exception) {
            throw new AdbCommandException(StringsKt.trimMargin$default((String)("Failed to execute adb command.\n          |Command: " + CollectionsKt.joinToString$default((Iterable)args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + "\n          |Timeout: " + timeout), null, (int)1, null), exception);
        }
    }

    @Override
    @NotNull
    public CommandHandle executeAsync(@NotNull String[] commandArgs, @NotNull Function1<? super String, Unit> processor) {
        Intrinsics.checkNotNullParameter((Object)commandArgs, (String)"commandArgs");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        List<String> args = this.setUpArgs(commandArgs);
        logger.fine("Executing Adb command: " + args);
        try {
            Subprocess processHandler = this.subprocessComponent.subprocess();
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)ANDROID_SDK_HOME, (Object)this.androidSdk.getSdkPath()), TuplesKt.to((Object)ANDROID_ADB, (Object)this.androidSdk.getAdbPath())};
            Handle handle = Subprocess.DefaultImpls.executeAsync$default(processHandler, args, MapsKt.mapOf((Pair[])pairArray), processor, null, 8, null);
            return new CommandHandleImpl(handle);
        }
        catch (Exception exception) {
            throw new AdbCommandException("Failed to execute async adb command.Command: " + CollectionsKt.joinToString$default((Iterable)args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + ' ', exception);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0002\u00a8\u0006\t"}, d2={"Lcom/google/testing/platform/lib/adb/command/subprocess/executor/AdbCommandExecutor$Companion;", "", "()V", "ANDROID_ADB", "", "ANDROID_SDK_HOME", "logger", "Ljava/util/logging/Logger;", "getLogger$annotations", "lib_java_com_google_testing_platform_lib_adb_command_subprocess_executor-adb_command_executor"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getLogger$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

