/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.platform.lib.adb.command.parser;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.LineProcessor;
import com.google.testing.platform.lib.adb.command.parser.Instrumentation;
import java.util.List;

public class AdbInstrumentationListProcessor
implements LineProcessor<List<Instrumentation>> {
    private static final String HEADER = "instrumentation:";
    private static final String TARGET = "(target=";
    private final List<Instrumentation> instrumentations = Lists.newArrayList();

    public boolean processLine(String line) {
        if ((line = line.trim()).isEmpty()) {
            return true;
        }
        if (line.startsWith("WARNING:")) {
            return true;
        }
        if (line.startsWith("FORTIFY:")) {
            return true;
        }
        Preconditions.checkState((boolean)line.startsWith(HEADER), (String)"Not an instrumentation line: %s", (Object)line);
        int packageClassSeperatorIndex = line.indexOf("/");
        int classTargetSeperatorIndex = line.indexOf(" ");
        Preconditions.checkState((-1 != packageClassSeperatorIndex ? 1 : 0) != 0, (String)"Seperating / not found: %s", (Object)line);
        Preconditions.checkState((-1 != classTargetSeperatorIndex ? 1 : 0) != 0, (String)"Seperating whitespace not found: %s", (Object)line);
        String androidPackage = line.substring(HEADER.length(), packageClassSeperatorIndex);
        String instrumentationClass = line.substring(packageClassSeperatorIndex + 1, classTargetSeperatorIndex);
        int targetStartPosition = line.indexOf(TARGET);
        int targetEndPosition = line.indexOf(")");
        Preconditions.checkState((-1 != targetStartPosition ? 1 : 0) != 0, (String)"target= missing. %s", (Object)line);
        Preconditions.checkState((-1 != targetEndPosition ? 1 : 0) != 0, (String)"closing ) not found. %s", (Object)line);
        String targetPackage = line.substring(targetStartPosition + TARGET.length(), targetEndPosition);
        this.instrumentations.add(new Instrumentation.Builder().withAndroidPackage(androidPackage.intern()).withInstrumentationClass(instrumentationClass.intern()).withTargetPackage(targetPackage.intern()).build());
        return true;
    }

    public List<Instrumentation> getResult() {
        return ImmutableList.copyOf(this.instrumentations);
    }
}

