/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.platform.lib.adb.command.parser;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.LineProcessor;
import java.util.List;

public class AdbDevicesLineProcessor
implements LineProcessor<List<String>> {
    private static final String SUFFIX = "device";
    private final List<String> deviceSerialIds = Lists.newArrayList();

    public boolean processLine(String line) {
        if ((line = line.trim()).endsWith(SUFFIX) && line.length() > SUFFIX.length()) {
            int endIndex = line.indexOf(SUFFIX) - 1;
            this.deviceSerialIds.add(line.substring(0, endIndex).trim());
        }
        return true;
    }

    public List<String> getResult() {
        return ImmutableList.copyOf(this.deviceSerialIds);
    }
}

