/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.platform.lib.adb.command.parser;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.LineProcessor;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

abstract class AbstractRegexpLineProcessor<T>
implements LineProcessor<T> {
    private final List<Matcher> matched = Lists.newArrayList();
    private final Pattern pattern;
    private final boolean stopOnFirstMatch;

    public AbstractRegexpLineProcessor(Pattern pattern, boolean stopOnFirstMatch) {
        this.pattern = (Pattern)Preconditions.checkNotNull((Object)pattern);
        this.stopOnFirstMatch = stopOnFirstMatch;
    }

    protected List<Matcher> getMatched() {
        return Lists.newArrayList(this.matched);
    }

    public final boolean processLine(String line) {
        Matcher matcher = this.pattern.matcher(line);
        if (matcher.matches()) {
            this.matched.add(matcher);
            return !this.stopOnFirstMatch;
        }
        return true;
    }

    static class RegexpProcessorBuilder {
        private Pattern pattern;

        RegexpProcessorBuilder() {
        }

        public RegexpProcessorBuilder withPattern(Pattern pattern) {
            this.pattern = pattern;
            return this;
        }

        public FirstMatchProcessor buildFirstMatchProcessor() {
            return new FirstMatchProcessor(this.pattern);
        }

        public RegexpPresentProcessor buildRegexpPresentProcessor() {
            return new RegexpPresentProcessor(this.pattern);
        }
    }

    static class FirstMatchProcessor
    extends AbstractRegexpLineProcessor<String> {
        private FirstMatchProcessor(Pattern pattern) {
            super(pattern, true);
        }

        public String getResult() {
            return !this.getMatched().isEmpty() ? this.getMatched().get(0).group(1) : null;
        }
    }

    static class RegexpPresentProcessor
    extends AbstractRegexpLineProcessor<Boolean> {
        public RegexpPresentProcessor(Pattern pattern) {
            super(pattern, true);
        }

        public Boolean getResult() {
            return !this.getMatched().isEmpty();
        }
    }
}

