/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import autovalue.shaded.com.google$.common.collect.$ImmutableMap;
import autovalue.shaded.com.google$.common.collect.$Iterables;
import com.google.auto.value.processor.TypeEncoder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;
import javax.tools.Diagnostic;

final class AnnotationOutput {
    private AnnotationOutput() {
    }

    static String sourceFormForInitializer(AnnotationValue annotationValue, ProcessingEnvironment processingEnv, String memberName, Element context) {
        InitializerSourceFormVisitor visitor = new InitializerSourceFormVisitor(processingEnv, memberName, context);
        StringBuilder sb = new StringBuilder();
        visitor.visit(annotationValue, sb);
        return sb.toString();
    }

    static String sourceFormForAnnotation(AnnotationMirror annotationMirror) {
        StringBuilder sb = new StringBuilder();
        new AnnotationSourceFormVisitor().visitAnnotation(annotationMirror, sb);
        return sb.toString();
    }

    private static StringBuilder appendQuoted(StringBuilder sb, String s) {
        sb.append('\"');
        for (int i = 0; i < s.length(); ++i) {
            AnnotationOutput.appendEscaped(sb, s.charAt(i));
        }
        return sb.append('\"');
    }

    private static StringBuilder appendQuoted(StringBuilder sb, char c) {
        sb.append('\'');
        AnnotationOutput.appendEscaped(sb, c);
        return sb.append('\'');
    }

    private static void appendEscaped(StringBuilder sb, char c) {
        switch (c) {
            case '\"': 
            case '\'': 
            case '\\': {
                sb.append('\\').append(c);
                break;
            }
            case '\n': {
                sb.append("\\n");
                break;
            }
            case '\r': {
                sb.append("\\r");
                break;
            }
            case '\t': {
                sb.append("\\t");
                break;
            }
            default: {
                if (c < ' ') {
                    sb.append(String.format("\\%03o", c));
                    break;
                }
                if (c < '\u007f' || Character.isLetter(c)) {
                    sb.append(c);
                    break;
                }
                sb.append(String.format("\\u%04x", c));
            }
        }
    }

    private static class AnnotationSourceFormVisitor
    extends SourceFormVisitor {
        private AnnotationSourceFormVisitor() {
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> values, StringBuilder sb) {
            if (values.size() == 1) {
                this.visit(values.get(0), sb);
                return null;
            }
            return super.visitArray(values, sb);
        }

        @Override
        public Void visitAnnotation(AnnotationMirror a, StringBuilder sb) {
            sb.append('@').append(TypeEncoder.encode(a.getAnnotationType()));
            $ImmutableMap<ExecutableElement, AnnotationValue> map2 = $ImmutableMap.copyOf(a.getElementValues());
            if (!map2.isEmpty()) {
                sb.append('(');
                Optional<AnnotationValue> shortForm = AnnotationSourceFormVisitor.shortForm(map2);
                if (shortForm.isPresent()) {
                    this.visit(shortForm.get(), sb);
                } else {
                    String sep = "";
                    for (Map.Entry entry : map2.entrySet()) {
                        sb.append(sep).append(((ExecutableElement)entry.getKey()).getSimpleName()).append(" = ");
                        sep = ", ";
                        this.visit((AnnotationValue)entry.getValue(), sb);
                    }
                }
                sb.append(')');
            }
            return null;
        }

        private static Optional<AnnotationValue> shortForm(Map<ExecutableElement, AnnotationValue> values) {
            if (values.size() == 1 && $Iterables.getOnlyElement(values.keySet()).getSimpleName().contentEquals("value")) {
                return Optional.of($Iterables.getOnlyElement(values.values()));
            }
            return Optional.empty();
        }
    }

    private static class InitializerSourceFormVisitor
    extends SourceFormVisitor {
        private final ProcessingEnvironment processingEnv;
        private final String memberName;
        private final Element context;

        InitializerSourceFormVisitor(ProcessingEnvironment processingEnv, String memberName, Element context) {
            this.processingEnv = processingEnv;
            this.memberName = memberName;
            this.context = context;
        }

        @Override
        public Void visitAnnotation(AnnotationMirror a, StringBuilder sb) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@AutoAnnotation cannot yet supply a default value for annotation-valued member '" + this.memberName + "'", this.context);
            sb.append("null");
            return null;
        }
    }

    private static abstract class SourceFormVisitor
    extends SimpleAnnotationValueVisitor8<Void, StringBuilder> {
        private SourceFormVisitor() {
        }

        @Override
        protected Void defaultAction(Object value, StringBuilder sb) {
            sb.append(value);
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> values, StringBuilder sb) {
            sb.append('{');
            String sep = "";
            for (AnnotationValue annotationValue : values) {
                sb.append(sep);
                this.visit(annotationValue, sb);
                sep = ", ";
            }
            sb.append('}');
            return null;
        }

        @Override
        public Void visitChar(char c, StringBuilder sb) {
            AnnotationOutput.appendQuoted(sb, c);
            return null;
        }

        @Override
        public Void visitLong(long i, StringBuilder sb) {
            sb.append(i).append('L');
            return null;
        }

        @Override
        public Void visitDouble(double d, StringBuilder sb) {
            if (Double.isNaN(d)) {
                sb.append("Double.NaN");
            } else if (d == Double.POSITIVE_INFINITY) {
                sb.append("Double.POSITIVE_INFINITY");
            } else if (d == Double.NEGATIVE_INFINITY) {
                sb.append("Double.NEGATIVE_INFINITY");
            } else {
                sb.append(d);
            }
            return null;
        }

        @Override
        public Void visitFloat(float f, StringBuilder sb) {
            if (Float.isNaN(f)) {
                sb.append("Float.NaN");
            } else if (f == Float.POSITIVE_INFINITY) {
                sb.append("Float.POSITIVE_INFINITY");
            } else if (f == Float.NEGATIVE_INFINITY) {
                sb.append("Float.NEGATIVE_INFINITY");
            } else {
                sb.append(f).append('F');
            }
            return null;
        }

        @Override
        public Void visitEnumConstant(VariableElement c, StringBuilder sb) {
            sb.append(TypeEncoder.encode(c.asType())).append('.').append(c.getSimpleName());
            return null;
        }

        @Override
        public Void visitString(String s, StringBuilder sb) {
            AnnotationOutput.appendQuoted(sb, s);
            return null;
        }

        @Override
        public Void visitType(TypeMirror classConstant, StringBuilder sb) {
            sb.append(TypeEncoder.encode(classConstant)).append(".class");
            return null;
        }
    }
}

