/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types.parse;

import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.types.parse.ParseException;
import com.google.template.soy.types.parse.Token;
import com.google.template.soy.types.parse.TypeParserConstants;
import java.util.List;

final class ParseErrors {
    ParseErrors() {
    }

    static String formatParseException(ParseException e) {
        Token errorToken = e.currentToken;
        if (errorToken.next != null) {
            errorToken = errorToken.next;
        }
        ImmutableSet.Builder expectedTokenImages = ImmutableSet.builder();
        for (int[] expected : e.expectedTokenSequences) {
            expectedTokenImages.add((Object)ParseErrors.getTokenDisplayName(expected[0]));
        }
        return BaseUtils.formatParseExceptionDetails(errorToken.image, (List<String>)expectedTokenImages.build().asList());
    }

    private static String getTokenDisplayName(int tokenId) {
        switch (tokenId) {
            case 12: {
                return "identifier";
            }
            case 0: {
                return "eof";
            }
            case 14: {
                throw new AssertionError((Object)"we should never expect the unexpected token");
            }
        }
        return TypeParserConstants.tokenImage[tokenId];
    }
}

