/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.template.soy.ErrorReporterImpl;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.internalutils.NodeContentKinds;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.soytree.AbstractCommandNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CommandTextAttributesParser;
import com.google.template.soy.soytree.ExprUnion;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public abstract class CallParamNode
extends AbstractCommandNode {
    private static final SoyErrorKind INVALID_COMMAND_TEXT = SoyErrorKind.of("Invalid param command text \"{0}\"");
    private static final Pattern NONATTRIBUTE_COMMAND_TEXT = Pattern.compile("^ \\s* (\\w+) (?: \\s* : \\s* (\\S .*) | \\s* (\\S .*) )? $", 36);
    private static final CommandTextAttributesParser ATTRIBUTES_PARSER = new CommandTextAttributesParser("param", new CommandTextAttributesParser.Attribute("kind", NodeContentKinds.getAttributeValues(), null));

    protected CallParamNode(int id, SourceLocation sourceLocation, String commandText) {
        super(id, sourceLocation, "param", commandText);
    }

    protected CallParamNode(CallParamNode orig, CopyState copyState) {
        super(orig, copyState);
    }

    public abstract String getKey();

    @Override
    public CallNode getParent() {
        return (CallNode)super.getParent();
    }

    static class Builder {
        protected final int id;
        protected final String commandText;
        protected final SourceLocation sourceLocation;

        protected Builder(int id, String commandText, SourceLocation sourceLocation) {
            this.id = id;
            this.commandText = commandText;
            this.sourceLocation = sourceLocation;
        }

        protected CommandTextParseResult parseCommandTextHelper(ErrorReporter errorReporter) {
            SanitizedContent.ContentKind contentKind;
            String commandText = this.commandText;
            Matcher nctMatcher = NONATTRIBUTE_COMMAND_TEXT.matcher(commandText);
            if (!nctMatcher.matches()) {
                errorReporter.report(this.sourceLocation, INVALID_COMMAND_TEXT, commandText);
                return new CommandTextParseResult("bad_key", null, null);
            }
            String key = nctMatcher.group(1);
            new ExpressionParser("$" + key, this.sourceLocation, errorReporter).parseVariable();
            if (nctMatcher.group(3) != null) {
                Preconditions.checkState((nctMatcher.group(2) == null ? 1 : 0) != 0);
                Map<String, String> attributes = ATTRIBUTES_PARSER.parse(nctMatcher.group(3), errorReporter, this.sourceLocation);
                contentKind = NodeContentKinds.forAttributeValue(attributes.get("kind"));
            } else {
                contentKind = null;
            }
            String valueExprText = nctMatcher.group(2);
            if (valueExprText == null) {
                return new CommandTextParseResult(key, null, contentKind);
            }
            ErrorReporterImpl throwaway = new ErrorReporterImpl();
            ErrorReporter.Checkpoint checkpoint = throwaway.checkpoint();
            ExprNode valueExpr = new ExpressionParser(valueExprText, this.sourceLocation, throwaway).parseExpression();
            ExprUnion valueExprUnion = throwaway.errorsSince(checkpoint) ? new ExprUnion(valueExprText) : new ExprUnion(valueExpr);
            return new CommandTextParseResult(key, valueExprUnion, contentKind);
        }
    }

    protected static class CommandTextParseResult {
        final String key;
        @Nullable
        final ExprUnion valueExprUnion;
        @Nullable
        final SanitizedContent.ContentKind contentKind;

        private CommandTextParseResult(String key, @Nullable ExprUnion valueExprUnion, @Nullable SanitizedContent.ContentKind contentKind) {
            this.key = key;
            this.valueExprUnion = valueExprUnion;
            this.contentKind = contentKind;
        }
    }
}

